#!/bin/sh

HOST_NAME=$1
PARAM=$2
TYPE=$3

FILE="/tmp/hostname"
TEMP="/tmp/hostname.tmp"

if [ $TYPE == "NETBIOS" ]; then
	MAC=`arp -n | grep $PARAM | awk -F" " '{ print $4 }'`
	if [ -z $MAC ]; then
		#echo "Can't get MAC address from ARP table!!!"
		exit 0
	fi
fi

if [ $TYPE == "DHCP" ]; then
	MAC=$PARAM
fi

TOTAL=`ps | grep -c "hostname.sh" || echo 0`

if [ $TOTAL -gt 5 ]; then
    exit 0
fi

grep -q "$HOST_NAME $MAC" $FILE > /dev/null 2>&1 && return

touch $FILE 
FOUND=`echo "$HOST_NAME $MAC"`
cat $FILE | grep -q -E "\<$FOUND\>"

if [ $? -ne 0 ]; then
    cat $FILE | grep -q -E "\<$MAC\>"
     
    if [ $? -eq 0 ]; then
        REPLICATE=`cat $FILE | grep -E "\<$MAC\>"`
        cat $FILE | sed "s/$REPLICATE/$HOST_NAME $MAC/" > $TEMP
        cp $TEMP $FILE  
    else
        echo "$HOST_NAME $MAC" >> $FILE
    fi

fi

sort -u $FILE > $TEMP 0>/dev/null
cp $TEMP $FILE



