#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

init_net()
{
    goahead &
    tr069_client &
    dray_fwup &
    telnetd
}

case "$1" in
    leasefail)
        if [ "`ps|grep [g]oahead`" ]; then
            ip=$(nvram_get lan_ipaddr)
            subnet=$(nvram_get lan_netmask)
            ifconfig $interface $ip netmask $subnet
        else
            init_net
        fi

        echo APM register static
        goahead apm_reg
        ;;

    deconfig)
        ifconfig $interface 0.0.0.0
        ;;

    renew|bound)
        gw=$(echo $router|awk '{print $1}')
        apm_svr=$(echo "$vendorspec"|sed 's/^\(APM_Server\).*/\1/')
        opmode=$(nvram_get 2860 OperationMode)
        opmode_5g=$(nvram_get 2860 OperationMode_5g)

        ifconfig $interface $ip netmask $subnet
        [ "$opmode" = "0" -a "$gw" ] && route add default gw $gw                # (see lan.sh)

        if [ "$opmode" = "2" -o "$opmode" = "3" -o "$opmode_5g" = "1" ]; then   # (see internet.sh: ApCliSetWAN; udhcpc.sh)
            lan_route=$(ip route | grep "$ip" | awk '{print $1}')
            [ $lan_route ] && ip route del $lan_route 2>/dev/null
            eval $(ipcalc -n $ip $subnet)
            route add -net $NETWORK netmask $subnet dev br0 2>/dev/null
        fi

        if [ -z "`ps|grep [g]oahead`" ]; then
            init_net
        fi
        [ "$apm_svr" != "APM_Server" ] && (goahead apm_reg; echo APM register static)
        ;;
esac

exit 0
