#!/bin/sh

# Copyright (C) 2009 Draytek

#step1 make /var/natwork
[ -d /var/network ]
if [ $? != "0" ]; then
        mkdir /var/network
fi

#set wan web setting time=0
#	echo "0" > /var/network/wan_settime

#step2 set wan_up and 3gwan_up =0
	echo "0" > /var/network/wan_up
	echo "0" > /var/network/3gwan_up

#step3 set wan_up_time and wan_util_up_time =0     #for wan up time detect
	echo "0" > /var/network/wan_up_time
	echo "0" > /var/network/wan_until_up_time

DHCP_WAN_START=0
	
#step4 loop check wan and 3gwan state
 while [ 1 ]
 do
	
	PROTO=$(nvram_get 2860 wanConnectionMode)
	BK_3G=$(nvram_get 2860 3gwan_backup)
	
	case $PROTO in
		"3G")
			#echo "3G wan mode"
			#check ppp0 interface
			W_INFO=$(ifconfig | grep "ppp0")
			if [ "$W_INFO" != "" ]; then
				#echo "ppp0 interface exist, 3G wan is up"
				echo "1" > /var/network/wan_up
			else
				#echo "ppp0 interface is not exist, 3G wan is down"
				echo "0" > /var/network/wan_up
			fi
			;;
		"DHCP")
			#echo "DHCP wan mode"
			#check phy link and eth2.2 wan ip address
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			W_LINK=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			if [ "$W_LINK" == "" ]; then
				#echo "wan link down"
				echo "0" > /var/network/wan_up
				DHCP_WAN_START=0
				WADDR_INFO=$(ifconfig eth2.2 | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#clean DHCP ip
					ifconfig eth2.2 0.0.0.0
				fi
				#echo "WAN link down!!!! "
			else
				# Add for G19795 : Remove WAN1 cable to another domain but DHCP client didn't reinitialize. -- Fanny
				PREV_LINK=$(cat /var/network/wan_up)
				UP_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')

				if [ $UP_TIME -gt 35 -a "$PREV_LINK" = "0" -a "$DHCP_WAN_START" = "0" ]; then
					wan.sh
					DHCP_WAN_START=1
				fi
				#echo "WAN link up!!!! "
				WADDR_INFO=$(ifconfig eth2.2 | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#echo "DHCP get ip, wan is up"
					echo "1" > /var/network/wan_up
					#echo "YES WAN IP!!!! "
				else
					#echo "DHCP can't get ip, wan is down"
					echo "0" > /var/network/wan_up
					#echo "NO WAN IP!!!! "
				fi
			fi

			;;
		"STATIC")
			#echo "Static wan mode"
			#check phy link and arp state
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			W_LINK=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			if [ "$W_LINK" == "" ]; then
				#echo "wan link down"
				echo "0" > /var/network/wan_up
			else
				#echo "wan link up"
				echo "1" > /var/network/wan_up
			fi
			;;
		*)
			#echo "PPPoE / PPTP / L2TP wan mode"
			#check phy link and ppp0 interface
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			TST=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			W_LINK=$(mii_mgr -g -p 1 -r 1 | grep "***d")
			if [ "$W_LINK" == "" ]; then
				#echo "wan link down"
				echo "0" > /var/network/wan_up
			else
				#echo "wan link up"
				W_INFO=$(ifconfig | grep "ppp0")
				if [ "$W_INFO" != "" ]; then
					#echo "ppp0 interface exist, wan is up"
					echo "1" > /var/network/wan_up
				else
					#echo "ppp0 interface is not exist, wan is down"
					echo "0" > /var/network/wan_up
				fi
			fi
		;;
	esac
	#check 3g backup state
	if [ "$BK_3G" == "1" ];then
		W_INFO=$(ifconfig | grep "ppp1")
		if [ "$W_INFO" != "" ]; then
			#echo "ppp1 interface exist, 3gwan is up"
			echo "1" > /var/network/3gwan_up
		else
			#echo "ppp1 interface is not exist, 3gwan is down"
			echo "0" > /var/network/3gwan_up
		fi
	else
		#echo "3gwan flag is not set."
		echo "0" > /var/network/3gwan_up
	fi
	
	#wan up time detect
	WAN_ST=$(cat /var/network/wan_up)
	if [ $WAN_ST = "1" ]; then
		#wan is up, update wan up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		OLD_TIME=$(cat /var/network/wan_until_up_time)
		WAN_UP_TIME=$(expr $NEW_TIME - $OLD_TIME)
		echo "$WAN_UP_TIME" > /var/network/wan_up_time
	else
		#wan is down, update wan until up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		echo "$NEW_TIME" > /var/network/wan_until_up_time
		echo "0" > /var/network/wan_up_time
	fi
	#echo "$(cat /var/network/wan_up_time)"
	#sleep 2 sec and wait
	sleep 2
 done
