#ifndef __IP_SET_PROTOCOL_H
#define __IP_SET_PROTOCOL_H

#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SETTYPE_NAME		"ipp2p"
	
#define IPP2P_MSN 0
#define IPP2P_YM 1
#define IPP2P_ICQ 2
#define IPP2P_AIM 3
#define IPP2P_QQ 4
#define IPP2P_ICHAT 5
#define IPP2P_GT 6
#define IPP2P_WIM 7
#define IPP2P_WMSN 8
#define IPP2P_JAJAH 9
#define IPP2P_SKYPE 10
#define IPP2P_SOULSEEK 11
#define IPP2P_EDONKEY 12
#define IPP2P_FASTTRACK 13
#define IPP2P_GNUTELLA 14
#define IPP2P_BITTORRENT 15
#define IPP2P_OPENFT 16
#define IPP2P_OPENNAP 17
#define IPP2P_WINNY 18
#define IPP2P_XUNLEI 19
#define IPP2P_VAGAA 20
#define IPP2P_PP365 21
#define IPP2P_POCO 22
#define IPP2P_CLUBBOX 23
#define IPP2P_ARES 24
#define IPP2P_EZPEER 25
#define IPP2P_PANDO 26
#define IPP2P_HUNTMINE 27
#define IPP2P_KUWO 28
#define IPP2P_MAX 29

#define IPP2P_FROM 0
#define IPP2P_TO IPP2P_MAX-1
#define IPP2P_NUM IPP2P_MAX

struct ip_set_ipp2p {
	void *members;			/* the ipp2p proper */
	ip_set_ip_t first_ip;		/* host byte order, included in range */
	ip_set_ip_t last_ip;		/* host byte order, included in range */
	u_int32_t size;			/* size of the __IP_SET_IPP2P_H proper */
};

struct ip_set_req_ipp2p_create {
	ip_set_ip_t from;
	ip_set_ip_t to;
};

struct ip_set_req_ipp2p {
	ip_set_ip_t ip;
};

#endif /* __IP_SET_IPP2P_H */
