#ifndef __IP_SET_KEYWORD_H
#define __IP_SET_KEYWORD_H

#ifdef __KERNEL__
#include <linux/list.h>
#endif
#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>


#define SETTYPE_NAME		"keyword"
#define IP_SET_KEYWORD_MAXCONTENTSLEN		64

#ifdef __KERNEL__
struct ip_set_keyword {
	struct list_head head;
	u_int32_t size;
};
#endif

struct ip_set_req_keyword {
	char contents[IP_SET_KEYWORD_MAXCONTENTSLEN];
};


struct ip_set_req_keyword_create {
	u_int32_t size;
};

#ifdef __KERNEL__
struct keyword_list {
	struct ip_set_req_keyword keyword;
	struct list_head list;
};
#endif

#endif /* __IP_SET_KEYWORD_H */
