<html>
<head>
<title>Quick Start Wizard Setup Internet</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("admin");
Butterlate.setTextDomain("internet");

var w = parent.wizard;
var f;

var yotaWebExist = "<% getWimaxExit(); %>";
var wimaxFlag = '<% getWimaxFlag(); %>';

function chgL2tpMode()
{
	var mode = getVleFromElmt(f.l2tpMode[0], 0);
	if(mode == 0) {
		f.l2tpIp.disabled = false;
		f.l2tpNetmask.disabled = false;
		f.l2tpGateway.disabled = false;
	} else {
		f.l2tpIp.disabled = true;
		f.l2tpNetmask.disabled = true;
		f.l2tpGateway.disabled = true;
	}
}

function chgPptpMode()
{
	var mode = getVleFromElmt(f.pptpMode[0], 0);
	if(mode == 0) {
		f.pptpIp.disabled = false;
		f.pptpNetmask.disabled = false;
		f.pptpGateway.disabled = false;
	} else {
		f.pptpIp.disabled = true;
		f.pptpNetmask.disabled = true;
		f.pptpGateway.disabled = true;
	}
}

function pppoeOPModeSwitch()
{
	if (f.pppoeOPMode.selectedIndex == 1)
		SetVisible("pppoeIdleTimeoutRow", true);
	else
		SetVisible("pppoeIdleTimeoutRow", false);
}

function l2tpOPModeSwitch()
{
	if (f.l2tpOPMode.selectedIndex == 1)
		SetVisible("l2tpIdleTimeoutRow", true);
	else
		SetVisible("l2tpIdleTimeoutRow", false);
}

function pptpOPModeSwitch()
{
	if (f.pptpOPMode.selectedIndex == 1)
		SetVisible("pptpIdleTimeoutRow", true);
	else
		SetVisible("pptpIdleTimeoutRow", false);
}

function onChgServPro()
{
	var WimaxSerPro = getVleFromElmt(f.WimaxSerPro, 0);
	
	if (WimaxSerPro == '4' || WimaxSerPro == '5' || WimaxSerPro == '7' || WimaxSerPro == '8'){
		showElmtByClass(document, "tr", "WimaxSerTwGlob");
		if(WimaxSerPro == '8'){
			if (f.wimax_cipher.options.length == 3)
				f.wimax_cipher.removeChild(f.wimax_cipher.options[2]);				
		}else{
			if (f.wimax_cipher.options.length == 2)
				f.wimax_cipher.options[2] = new Option("DHE_RSA_AES_256_SHA", "2", false, false);
		}
	}else{
		hideElmtByClass(document, "tr", "WimaxSerTwGlob");	
	}

	if (WimaxSerPro == '1' || WimaxSerPro == '2') {	// Russia or Nicaragua
		SetVisible("trwimaxselrul", true);
	} else {
		SetVisible("trwimaxselrul", false);
	}

	if (WimaxSerPro == '6' || wimaxFlag == 9 || wimaxFlag == 1) {	// Sweden or Megafon or Yota
		SetVisible("tr4gpin", true);
		SetVisible("tr4gnmod", true);
		SetVisible("tr4gapn", true);
	} else {
		SetVisible("tr4gpin", false);
		SetVisible("tr4gnmod", false);
		SetVisible("tr4gapn", false);
	}
}

function connectionTypeSwitch()
{
	var connectionType = getVleFromElmt(f.connectionType, 0);

	SetVisible("static", false);
	SetVisible("dhcp", false);
	SetVisible("pppoe", false);
	SetVisible("l2tp", false);
	SetVisible("pptp", false);
	SetVisible("3G", false);
	SetVisible("wimax", false);

	if (connectionType == "STATIC") {
		SetVisible("static", true);
	} else if (connectionType == "DHCP") {
		SetVisible("dhcp", true);
	} else if (connectionType == "PPPOE") {
		SetVisible("pppoe", true);
		pppoeOPModeSwitch();
	} else if (connectionType == "L2TP") {
		SetVisible("l2tp", true);
		chgL2tpMode();
		l2tpOPModeSwitch();
	} else if (connectionType == "PPTP") {
		SetVisible("pptp", true);
		chgPptpMode();
		pptpOPModeSwitch();
	} else if (connectionType == "3G") {
		SetVisible("3G", true);
	} else if (connectionType == "Wimax") {
		SetVisible("wimax", true);
		onChgServPro();
	}
}

function CheckValue()
{
	var connectionType = getVleFromElmt(f.connectionType, 0);
	if (connectionType == "STATIC") {      //STATIC
		if (!checkIpAddr(f.staticIp, false))
			return false;
		if (!checkIpAddr(f.staticNetmask, true))
			return false;
		if (f.staticGateway.value != "")
			if (!checkIpAddr(f.staticGateway, false))
				return false;
		if (f.staticPriDns.value != "")
			if (!checkIpAddr(f.staticPriDns, false))
				return false;
		if (f.staticSecDns.value != "")
			if (!checkIpAddr(f.staticSecDns, false))
				return false;
	} else if (connectionType == "DHCP") { //DHCP
		var re = /^[\w]+$/;
		var routername = f.hostname.value;
		if (!re.test(routername) && routername != "") {
			alert(_("msg router name error"));
			return false;	
		}					
	} else if (connectionType == "PPPOE") { //PPPOE
		if (f.pppoePass.value != f.pppoePass2.value) {
			alert(_("msg wan pwdmismatch"));
			return false;
		}
		if (f.pppoeOPMode.options.selectedIndex == 1) {
			if (!isIntWithinRange(f.pppoeIdleTime, 0, 546, _("wan protocol opmode str1")))
				return false;
		}
	} else if (connectionType == "L2TP") { //L2TP
		if (f.l2tpOPMode.options.selectedIndex == 1) {
			if (!isIntWithinRange(f.l2tpIdleTime, 0, 546, _("wan protocol opmode str1")))
				return false;
		}
		var mode = getVleFromElmt(f.l2tpMode[0], 0);
		if (mode == 0) {
			if (!checkIpAddr(f.l2tpIp, false))
				return false;
			if (!checkIpAddr(f.l2tpNetmask, true))
				return false;
			if (!checkIpAddr(f.l2tpGateway, false))
				return false;
		}
	} else if (connectionType == "PPTP") { //PPTP
		if (f.pptpOPMode.options.selectedIndex == 1) {
			if (!isIntWithinRange(f.pptpIdleTime, 0, 546, _("wan protocol opmode str1")))
				return false;
		}
		var mode = getVleFromElmt(f.pptpMode[0], 0);
		if (mode == 0) {
			if (!checkIpAddr(f.pptpIp, false))
				return false;
			if (!checkIpAddr(f.pptpNetmask, true))
				return false;
			if (!checkIpAddr(f.pptpGateway, false))
				return false;
		}
	} else if (connectionType == "3G") { //3G
			
	} else if (connectionType == "Wimax") { //Wimax

	}
	return true;
}

function onClkBtnNxt()
{
	if (!CheckValue())
		return false;

	var connectionType = getVleFromElmt(f.connectionType, 0);
	if (connectionType == "STATIC") {      //STATIC
		w.wBackupconnectType = "STATIC";
		w.wBackupstaticIp = f.staticIp.value;
		w.wBackupstaticNetmask = f.staticNetmask.value;
		w.wBackupstaticGateway = f.staticGateway.value;
		w.wBackupstaticPriDns = f.staticPriDns.value;
		w.wBackupstaticSecDns = f.staticSecDns.value;
	} else if (connectionType == "DHCP") { //DHCP
		w.wBackupconnectType = "DHCP";
		w.wBackuphostname = f.hostname.value;
	} else if (connectionType == "PPPOE") { //PPPOE
		w.wBackupconnectType = "PPPOE";
		w.wBackuppppoeUser = f.pppoeUser.value;
		w.wBackuppppoePass = f.pppoePass.value;
		if (f.pppoeOPMode.selectedIndex == 0) {
			w.wBackuppppoeOPMode = "KeepAlive";
		} else if (f.pppoeOPMode.selectedIndex == 1) {
			w.wBackuppppoeOPMode = "OnDemand";
			w.wBackuppppoeIdleTime = f.pppoeIdleTime.value;
		}
	} else if (connectionType == "L2TP") { //L2TP
		w.wBackupconnectType = "L2TP";
		w.wBackupL2tpServer = f.l2tpServer.value;
		w.wBackupL2tpUser = f.l2tpUser.value;
		w.wBackupL2tpPass = f.l2tpPass.value;
		var mode = getVleFromElmt(f.l2tpMode[0], 0);
		if (mode == 0) {
			w.wBackupL2tpMode = "0";
			w.wBackupL2tpIp = f.l2tpIp.value;
			w.wBackupL2tpNetmask = f.l2tpNetmask.value;
			w.wBackupL2tpGateway = f.l2tpGateway.value;
		} else
			w.wBackupL2tpMode = "1";
		if (f.l2tpOPMode.selectedIndex == 0) {
			w.wBackupL2tpOPMode = "KeepAlive";
		} else if (f.l2tpOPMode.selectedIndex == 1) {
			w.wBackupL2tpOPMode = "OnDemand";
			w.wBackupL2tpIdleTime = f.l2tpIdleTime.value;
		}
	} else if (connectionType == "PPTP") { //PPTP
		w.wBackupconnectType = "PPTP";
		w.wBackupPptpServer = f.pptpServer.value;
		w.wBackupPptpUser = f.pptpUser.value;
		w.wBackupPptpPass = f.pptpPass.value;
		var mode = getVleFromElmt(f.pptpMode[0], 0);
		if (mode == 0) {
			w.wBackupPptpMode = "0";
			w.wBackupPptpIp = f.pptpIp.value;
			w.wBackupPptpNetmask = f.pptpNetmask.value;
			w.wBackupPptpGateway = f.pptpGateway.value;
		} else
			w.wBackupPptpMode = "1";
		if (f.pptpOPMode.selectedIndex == 0) {
			w.wBackupPptpOPMode = "KeepAlive";
		} else if (f.pptpOPMode.selectedIndex == 1) {
			w.wBackupPptpOPMode = "OnDemand";
			w.wBackupPptpIdleTime = f.pptpIdleTime.value;
		}
	} else if (connectionType == "3G") { //3G
		w.wBackupconnectType = "3G";
		w.wBackup_pincode = f.wan_pincode.value;
		w.wBackup_init_str1 = f.wan_init_str1.value;
		w.wBackup_init_str2 = f.wan_init_str2.value;
		w.wBackup_apn = f.wan_apn.value;
		w.wBackup_dial_str = f.wan_dial_str.value;
		w.wBackup_usr = f.wan_usr.value;
		w.wBackup_pwd = f.wan_pwd.value;
		if (f.wan_auth.options.selectedIndex == 0)
			w.wBackup_auth = "0";
		else
			w.wBackup_auth = "1";
	} else if (connectionType == "Wimax") { //Wimax
		w.wBackupconnectType = "Wimax";
		w.wWimaxSerPro = getVleFromElmt(f.WimaxSerPro, 0);
		w.wWimaxSerProUsr = getVleFromElmt(f.wimax_user, 0);
		w.wWimaxSerProPass = getVleFromElmt(f.wimax_passwd, 0);
		w.wWimax_cipher = getVleFromElmt(f.wimax_cipher, 0);
		w.wSelrul = getVleFromElmt(f.selrul, 0);
		w.wLte_pin = f.lte_pin.value;
		w.wLte_net_mode = getVleFromElmt(f.lte_net_mode, 0);
		w.wLte_apn = f.lte_apn.value;
	} else {
		w.wBackupconnectType = "None";
	}

	document.location.href = "./wizard_wifi.asp";

	return true;
}

function onClkBtnCcl()
{
	if(confirm(_("msg wiz cancel"))) {
		parent.location = "/home.asp";
	}
}

function initTranslation()
{
	var e = document.getElementById("wizTitle");
	e.innerHTML = _("wiz title");

	e = document.getElementById("wizWanTitle");
	e.innerHTML = _("wan title")+" - "+_("parent wan")+" 2";
	e = document.getElementById("wAccMode");
	e.innerHTML = _("wan accmode");

	e = document.getElementById("wStaticMode");
	e.innerHTML = _("wan static mode");
	e = document.getElementById("wStaticIpNetSet");
	e.innerHTML = _("wan address mode");
	e = document.getElementById("wStaticIp");
	e.innerHTML = _("inet ip");
	e = document.getElementById("wStaticNetmask");
	e.innerHTML = _("inet netmask");
	e = document.getElementById("wStaticGateway");
	e.innerHTML = _("inet gateway");
	e = document.getElementById("wStaticDns");
	e.innerHTML = _("inet dns");
	e = document.getElementById("wStaticPriDns");
	e.innerHTML = _("inet pri dns");
	e = document.getElementById("wStaticSecDns");
	e.innerHTML = _("inet sec dns");

	e = document.getElementById("wDhcpMode");
	e.innerHTML = _("wan dhcp mode");
	e = document.getElementById("wDhcpHost");
	e.innerHTML = _("inet hostname");

	e = document.getElementById("wPppoeMode");
	e.innerHTML = _("wan pppoe mode");
	e = document.getElementById("wPppoeUser");
	e.innerHTML = _("inet user");
	e = document.getElementById("wPppoePassword");
	e.innerHTML = _("inet password");
	e = document.getElementById("wPppoePass2");
	e.innerHTML = _("inet pass2");
	e = document.getElementById("wPppoeOPMode");
	e.innerHTML = _("wan protocol opmode");
	e = document.getElementById("wPppoeKeepAlive");
	e.innerHTML = _("wan protocol opmode keepalive");
	e = document.getElementById("wPppoeOnDemand");
	e.innerHTML = _("wan protocol opmode ondemand");
	e = document.getElementById("wPppoeIdle");
	e.innerHTML = _("wan protocol opmode str1");
	e = document.getElementById("wPppoeMin");
	e.innerHTML = _("inet minutes");

	e = document.getElementById("wL2tpMode");
	e.innerHTML = _("wan l2tp mode");
	e = document.getElementById("wL2tpServer");
	e.innerHTML = _("inet server");
	e = document.getElementById("wL2tpUser");
	e.innerHTML = _("inet user");
	e = document.getElementById("wL2tpPassword");
	e.innerHTML = _("inet password");
	e = document.getElementById("wL2tpAddrMode");
	e.innerHTML = _("wan address mode");
	e = document.getElementById("wL2tpModeDhcp");
	e.innerHTML = _("wan address mode obtain");
	e = document.getElementById("wL2tpModeStatic");
	e.innerHTML = _("wan address mode specify");
	e = document.getElementById("wL2tpIp");
	e.innerHTML = _("inet ip");
	e = document.getElementById("wL2tpNetmask");
	e.innerHTML = _("inet netmask");
	e = document.getElementById("wL2tpGateway");
	e.innerHTML = _("inet gateway");
	e = document.getElementById("wL2tpOPMode");
	e.innerHTML = _("wan protocol opmode");
	e = document.getElementById("wL2tpKeepAlive");
	e.innerHTML = _("wan protocol opmode keepalive");
	e = document.getElementById("wL2tpOnDemand");
	e.innerHTML = _("wan protocol opmode ondemand");
	e = document.getElementById("wL2tpIdle");
	e.innerHTML = _("wan protocol opmode str1");
	e = document.getElementById("wL2tpMin");
	e.innerHTML = _("inet minutes");

	e = document.getElementById("wPptpMode");
	e.innerHTML = _("wan pptp mode");
	e = document.getElementById("wPptpServer");
	e.innerHTML = _("inet server");
	e = document.getElementById("wPptpUser");
	e.innerHTML = _("inet user");
	e = document.getElementById("wPptpPassword");
	e.innerHTML = _("inet password");
	e = document.getElementById("wPptpAddrMode");
	e.innerHTML = _("wan address mode");
	e = document.getElementById("wPptpModeDhcp");
	e.innerHTML = _("wan address mode obtain");
	e = document.getElementById("wPptpModeStatic");
	e.innerHTML = _("wan address mode specify");
	e = document.getElementById("wPptpIp");
	e.innerHTML = _("inet ip");
	e = document.getElementById("wPptpNetmask");
	e.innerHTML = _("inet netmask");
	e = document.getElementById("wPptpGateway");
	e.innerHTML = _("inet gateway");
	e = document.getElementById("wPptpOPMode");
	e.innerHTML = _("wan protocol opmode");
	e = document.getElementById("wPptpKeepAlive");
	e.innerHTML = _("wan protocol opmode keepalive");
	e = document.getElementById("wPptpOnDemand");
	e.innerHTML = _("wan protocol opmode ondemand");
	e = document.getElementById("wPptpIdle");
	e.innerHTML = _("wan protocol opmode str1");
	e = document.getElementById("wPptpMin");
	e.innerHTML = _("inet minutes");

	e = document.getElementById("w3GMode");
	e.innerHTML = _("wan 3G mode");
	e = document.getElementById("w3GPin");
	e.innerHTML = _("wan 3G pincode");
	e = document.getElementById("w3GInitStr1");
	e.innerHTML = _("wan 3G initstr1");
	e = document.getElementById("w3GInitStr2");
	e.innerHTML = _("wan 3G initstr2");
	e = document.getElementById("w3GAPN");
	e.innerHTML = _("wan 3G apn");
	e = document.getElementById("w3GDialStr");
	e.innerHTML = _("wan 3G dialstr");
	e = document.getElementById("w3GPPPUser");
	e.innerHTML = _("wan 3G pppuser");
	e = document.getElementById("w3GPPPPwd");
	e.innerHTML = _("wan 3G ppppwd");
	e = document.getElementById("w3GPPPAuth");
	e.innerHTML = _("wan 3G pppauth");
	e = document.getElementById("w3GAuthOnly");
	e.innerHTML = _("wan 3G pppauth only");
	e = document.getElementById("w3GAuthBoth");
	e.innerHTML = _("wan 3G pppauth both");
	for (var i = 0; i < 4; i++) {
		e = eval("document.getElementById('wDefaultstr"+i+"')");
		e.innerHTML = _("inet defaultstr");
	}

	e = document.getElementById("wWimaxMode");
	e.innerHTML = _("wan 4G mode");

	e = document.getElementById("wWimaxServPro");
	e.innerHTML = _("wan wimax service provider");
	e = document.getElementById("wWimaxSerProNone");
	e.innerHTML = _("inet none");
	e = document.getElementById("wWimaxSerTwGlobUsr");
	e.innerHTML = _("inet user");
	e = document.getElementById("wWimaxSerTwGlobPass");
	e.innerHTML = _("inet password");
	e = document.getElementById("wWimaxSerTwGlobCipher");
	e.innerHTML = _("wan wimax cipher");

	e = document.getElementById("wWimaxSelRule");
	e.innerHTML = _("wan wimax select rule");
	e = document.getElementById("wWimaxSelRuleFirstBS");
	e.innerHTML = _("wan wimax select rule FirstBS");
	e = document.getElementById("wWimaxSelRuleRSSI");
	e.innerHTML = _("wan wimax select rule rssi");
	e = document.getElementById("wWimaxSelRuleCINR");
	e.innerHTML = _("wan wimax select rule cinr");
	e = document.getElementById("wWimaxSelRuleFrequency");
	e.innerHTML = _("wan wimax select rule frequency");
	e = document.getElementById("w4GPin");
	e.innerHTML = _("wan 3G pincode");
	e = document.getElementById("w4GNetworkMode");
	e.innerHTML = _("wan wimax mode");
	e = document.getElementById("w4GNModDef");
	e.innerHTML = _("inet defaultstr");
	e = document.getElementById("w4GAPN");
	e.innerHTML = _("wan 3G apn");

	e = document.getElementById("wNote");
	e.innerHTML = _("note head");
	e = document.getElementById("wNote1");
	e.innerHTML = _("wan backup note");

	e = document.getElementById("btnBck");
	e.value = _("wiz btn back");
	e = document.getElementById("btnNxt");
	e.value = _("wiz btn next");
	e = document.getElementById("btnFin");
	e.value = _("wiz btn finish");
	e = document.getElementById("btnCcl");
	e.value = _("admin cancel");
}

function initWan2()
{
	var mode = "<% getCfgGeneral(1, "wanConnectionMode", 1); %>";
	var mode2 = '<% getCfgGeneral(1, "3gwan_backup", 1); %>';
	var backMode = '<% getCfgGeneral(1, "wan2ConnectionMode", 1); %>';

	if (w.mode != "")
		mode = w.mode;
	if (w.wBackupconnectType != "") {
		backMode = w.wBackupconnectType;
		mode2 = (w.wBackupconnectType == "3G")?"1":"0";
	}

	if (yotaWebExist == 1) {
		if (mode == "Wimax" || mode == "3G") {
			f.connectionType.options.length = 0;
			f.connectionType.options[0] = new Option(_("inet none"), "NONE", false, false);
			f.connectionType.options[1] = new Option(_("wan connection type static"), "STATIC", false, false);
			f.connectionType.options[2] = new Option(_("wan connection type dhcp"), "DHCP", false, false);
			f.connectionType.options[3] = new Option(_("wan connection type pppoe"), "PPPOE", false, false);
			f.connectionType.options[4] = new Option(_("wan connection type l2tp"), "L2TP", false, false);
			f.connectionType.options[5] = new Option(_("wan connection type pptp"), "PPTP", false, false);
			if (backMode == "STATIC") {
				f.connectionType.options.selectedIndex = 1;
			}else if (backMode == "DHCP") {
				f.connectionType.options.selectedIndex = 2;
			}else if (backMode == "PPPOE") {
				f.connectionType.options.selectedIndex = 3;
			}else if (backMode == "L2TP") {
				f.connectionType.options.selectedIndex = 4;
			}else if (backMode == "PPTP") {
				f.connectionType.options.selectedIndex = 5;
			}else {
				f.connectionType.options.selectedIndex = 0;
			}
		}else if (mode == "YotaKey") {
			f.connectionType.options.length = 0;
			f.connectionType.options[0] = new Option(_("inet none"), "NONE", false, false);
			f.connectionType.options.selectedIndex = 0;
		}else {
			f.connectionType.options.length = 0;
			f.connectionType.options[0] = new Option(_("inet none"), "NONE", false, false);
			f.connectionType.options[1] = new Option(_("wan connection type 3g"), "3G", false, false);
			f.connectionType.options[2] = new Option(_("wan connection type 4g"), "Wimax", false, false);
			if (backMode == "3G") {
				f.connectionType.options.selectedIndex = 1;
			}else if (backMode == "Wimax") {
				f.connectionType.options.selectedIndex = 2;
			}else {
				f.connectionType.options.selectedIndex = 0;
			}
		}
	}else {
		if (mode == "3G") {
			f.connectionType.options.length = 0;
			f.connectionType.options[0] = new Option(_("inet none"), "NONE", false, false);
			f.connectionType.options.selectedIndex = 0;
		}else {
			f.connectionType.options.length = 0;
			f.connectionType.options[0] = new Option(_("inet none"), "NONE", false, false);
			f.connectionType.options[1] = new Option(_("wan connection type 3g"), "3G", false, false);
			f.connectionType.options.selectedIndex = mode2;//option
		}
	}

}

function initValue()
{
	f = document.wanCfg;

	initTranslation();

	if (yotaWebExist == 1) {	// pppoe
		var pppoe_opmode = "<% getCfgGeneral(1, "wan2_pppoe_opmode", 1); %>";
		var pppoe_optime = "<% getCfgGeneral(1, "wan2_pppoe_optime", 1); %>";
		if (pppoe_opmode == "OnDemand") {
			f.pppoeOPMode.selectedIndex = 1;
			if (pppoe_optime != "")
				f.pppoeIdleTime.value = pppoe_optime;
		} else if (pppoe_opmode == "KeepAlive") {
			f.pppoeOPMode.selectedIndex = 0;
		}

	}
	if (yotaWebExist == 1) {	// l2tp
		var l2tpMode   = '<% getCfgZero(1, "wan2_l2tp_mode"); %>';
		var l2tp_opmode = "<% getCfgGeneral(1, "wan2_l2tp_opmode", 1); %>";
		var l2tp_optime = "<% getCfgGeneral(1, "wan2_l2tp_optime", 1); %>";
		setVle2Elmt(f.l2tpMode[0], 1*l2tpMode, 0);
		if (l2tp_opmode == "OnDemand") {
			f.l2tpOPMode.selectedIndex = 1;
			if (l2tp_optime != "")
				f.l2tpIdleTime.value = l2tp_optime;
		} else if (l2tp_opmode == "KeepAlive") {
			f.l2tpOPMode.selectedIndex = 0;
		}
	}
	if (yotaWebExist == 1) {	// pptp
		var pptpMode   = '<% getCfgZero(1, "wan2_pptp_mode"); %>';
		var pptp_opmode = "<% getCfgGeneral(1, "wan2_pptp_opmode", 1); %>";
		var pptp_optime = "<% getCfgGeneral(1, "wan2_pptp_optime", 1); %>";
		setVle2Elmt(f.pptpMode[0], 1*pptpMode, 0);
		if (pptp_opmode == "OnDemand") {
			f.pptpOPMode.selectedIndex = 1;
			if (pptp_optime != "")
				f.pptpIdleTime.value = pptp_optime;
		} else if (pptp_opmode == "KeepAlive") {
			f.pptpOPMode.selectedIndex = 0;
		}
	}
	{	// 3g
		var wan_auth = "<% getCfgGeneral(1, "3gwan_auth", 1); %>";
		if (wan_auth == "0")
			f.wan_auth.options.selectedIndex = 0;
	}
	if (yotaWebExist == 1) {	// wimax
		var wimax_ser_pro = '<% getCfgZero(1, "wimax_service_provider"); %>';
		var wimax_cipher = '<% getCfgGeneral(1, "wimax_cipher", 1); %>';
		var wimax_select_rule = '<% getCfgGeneral(1, "wimax_select_rule", 1); %>';
		var lte_pin = '<% getCfgGeneral(1, "lte_pin", 1); %>';
		var lte_net_mode = '<% getCfgZero(1, "lte_net_mode"); %>';

		if (wimaxFlag == 1 || wimaxFlag == 2 || wimaxFlag == 3 || wimaxFlag ==6)
			wimax_ser_pro = wimaxFlag;
		else if (wimaxFlag == 9)
			wimax_ser_pro = 6;

		setVle2Elmt(f.WimaxSerPro, wimax_ser_pro, 0);
		if (!isInt(wimax_cipher) || wimax_cipher < 0 || wimax_cipher > 2) {
			if (wimax_ser_pro == '8')
				wimax_cipher = 0;
			else
				wimax_cipher = 2;
		}
		setVle2Elmt(f.wimax_cipher, wimax_cipher, 0);	
		if (!isInt(wimax_select_rule) || wimax_select_rule < 0 || wimax_select_rule > 3) {
			if (wimax_ser_pro == '2')
				wimax_select_rule = 3;
			else
				wimax_select_rule = 1;
		}
		setVle2Elmt(f.selrul[0], wimax_select_rule, 0);
		if(/^\d/.test(lte_pin)) {
			var hpin = document.getElementById("tdlte_pin");
			hpin.removeChild(hpin.firstChild);
			var elte_pin = document.createElement("input");
			elte_pin.type = "password";
			elte_pin.name = "lte_pin";
			elte_pin.id = "lte_pin";
			elte_pin.maxLength = 15;
			hpin.appendChild(elte_pin);
		}
		document.getElementById("lte_pin").value = lte_pin;
		f.lte_net_mode.value = lte_net_mode;
	}
	
	initWan2();

	var connectionType = getVleFromElmt(f.connectionType, 0);
	if (connectionType == "STATIC" && yotaWebExist == 1) {
		if (w.wBackupstaticIp != "")
			f.staticIp.value = w.wBackupstaticIp;
		if (w.wBackupstaticNetmask != "")
			f.staticNetmask.value = w.wBackupstaticNetmask;
		if (w.wBackupstaticGateway != "")
			f.staticGateway.value = w.wBackupstaticGateway;
		if (w.wBackupstaticPriDns != "")
			f.staticPriDns.value = w.wBackupstaticPriDns;
		if (w.wBackupstaticSecDns != "")
			f.staticSecDns.value = w.wBackupstaticSecDns;
	} else if (connectionType == "DHCP" && yotaWebExist == 1) {
		if (w.wBackuphostname != "")
			f.hostname.value = w.wBackuphostname;
	} else if (connectionType == "PPPOE" && yotaWebExist == 1) {
		if (w.wBackuppppoeUser != "")
			f.pppoeUser.value = w.wBackuppppoeUser;
		if (w.wBackuppppoePass != "") {
			f.pppoePass.value = w.wBackuppppoePass;
			f.pppoePass2.value = w.wBackuppppoePass;
		}

		if (w.wBackuppppoeOPMode != "") {
			if (w.wBackuppppoeOPMode == "OnDemand") {
				f.pppoeOPMode.selectedIndex = 1;
			} else if (w.wBackuppppoeOPMode == "KeepAlive") {
				f.pppoeOPMode.selectedIndex = 0;
			}
		}
		if (w.wBackuppppoeIdleTime != "")
			f.pppoeIdleTime.value = w.wBackuppppoeIdleTime;
	} else if (connectionType == "L2TP" && yotaWebExist == 1) {
		if (w.wBackupL2tpServer != "")
			f.l2tpServer.value = w.wBackupL2tpServer;
		if (w.wBackupL2tpUser != "")
			f.l2tpUser.value = w.wBackupL2tpUser;
		if (w.wBackupL2tpPass != "")
			f.l2tpPass.value = w.wBackupL2tpPass;

		if (w.wBackupL2tpMode != "")
			setVle2Elmt(f.l2tpMode[0], 1*(w.wBackupL2tpMode), 0);
		
		if (w.wBackupL2tpIp != "")
			f.l2tpIp.value = w.wBackupL2tpIp;
		if (w.wBackupL2tpNetmask != "")
			f.l2tpNetmask.value = w.wBackupL2tpNetmask;
		if (w.wBackupL2tpGateway != "")
			f.l2tpGateway.value = w.wBackupL2tpGateway;
		
		if (w.wBackupL2tpOPMode != "") {
			if (w.wBackupL2tpOPMode == "OnDemand") {
				f.l2tpOPMode.selectedIndex = 1;
				
			} else if (w.wBackupL2tpOPMode == "KeepAlive") {
				f.l2tpOPMode.selectedIndex = 0;
			}
		}
		if (w.wBackupL2tpIdleTime != "")
			f.l2tpIdleTime.value = w.wBackupL2tpIdleTime;
	} else if (connectionType == "PPTP" && yotaWebExist == 1) {
		if (w.wBackupPptpServer != "")
			f.pptpServer.value = w.wBackupPptpServer;
		if (w.wBackupPptpUser != "")
			f.pptpUser.value = w.wBackupPptpUser;
		if (w.wBackupPptpPass != "")
			f.pptpPass.value = w.wBackupPptpPass;

		if (w.wBackupPptpMode != "")
			setVle2Elmt(f.pptpMode[0], 1*(w.wBackupPptpMode), 0);
		
		if (w.wBackupPptpIp != "")
			f.pptpIp.value = w.wBackupPptpIp;
		if (w.wBackupPptpNetmask != "")
			f.pptpNetmask.value = w.wBackupPptpNetmask;
		if (w.wBackupPptpGateway != "")
			f.pptpGateway.value = w.wBackupPptpGateway;

		if (w.wBackupPptpOPMode != "") {
			if (w.wBackupPptpOPMode == "OnDemand") {
				f.pptpOPMode.selectedIndex = 1;
				
			} else if (w.wBackupPptpOPMode == "KeepAlive") {
				f.pptpOPMode.selectedIndex = 0;
			}
		}
		if (w.wBackupPptpIdleTime != "")
			f.pptpIdleTime.value = w.wBackupPptpIdleTime;
	} else if (connectionType == "3G") {
		if (w.wBackup_pincode != "")
			f.wan_pincode.value = w.wBackup_pincode;
		if (w.wBackup_init_str1 != "")
			f.wan_init_str1.value = w.wBackup_init_str1;
		if (w.wBackup_init_str2 != "")
			f.wan_init_str2.value = w.wBackup_init_str2;
		if (w.wBackup_apn != "")
			f.wan_apn.value = w.wBackup_apn;
		if (w.wBackup_dial_str != "")
			f.wan_dial_str.value = w.wBackup_dial_str;
		if (w.wBackup_usr != "")
			f.wan_usr.value = w.wBackup_usr;
		if (w.wBackup_pwd != "")
			f.wan_pwd.value = w.wBackup_pwd;
		if (w.wBackup_auth == "0")
			f.wan_auth.options.selectedIndex = 0;
	} else if (connectionType == "Wimax" && yotaWebExist == 1) {	// Wimax
		if (w.wWimaxSerPro != "")
			setVle2Elmt(f.WimaxSerPro, w.wWimaxSerPro, 0);
		if (w.wWimaxSerProUsr != "")
			f.wimax_user.value = w.wWimaxSerProUsr; 
		if (w.wWimaxSerProPass != "")
			f.wimax_passwd.value = w.wWimaxSerProPass;		

		if (w.wWimax_cipher != "")
			setVle2Elmt(f.wimax_cipher, w.wWimax_cipher, 0);

		if (w.wLte_pin != "") {
			if(/^\d/.test(w.wLte_pin)) {
				var hpin = document.getElementById("tdlte_pin");
				hpin.removeChild(hpin.firstChild);
				var elte_pin = document.createElement("input");
				elte_pin.type = "password";
				elte_pin.name = "lte_pin";
				elte_pin.id = "lte_pin";
				elte_pin.maxLength = 15;
				hpin.appendChild(elte_pin);
			}
			document.getElementById("lte_pin").value = w.wLte_pin;
		}
		if (w.wLte_net_mode != "")
			f.lte_net_mode.value = w.wLte_net_mode;
	}

	connectionTypeSwitch();

	if (yotaWebExist == 1) {
		if (wimaxFlag == 1 || wimaxFlag == 2 || wimaxFlag == 3 || wimaxFlag ==6 || wimaxFlag == 9)
			SetVisible("trserpro", false);
	}
}

</script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>
<h1 id="wizTitle">Quick Start Wizard</h1>
<hr size="1" />
<br />

<form name="wanCfg" method="post" action="/goform/wizardSetup">
<h2 id="wizWanTitle" class="title">Internet Access - WAN 2</h2>
<table width="100%" height="280" cellspacing="1" cellpadding="2" class="config">
<tr>
  <td valign=top>
	<table align="center" width="95%" cellspacing="2" cellpadding="0">
	  <tr><td><br /></td></tr>
	  <tr><td>
	  	<!-- ================= Connection Type ================= -->
	  	<table id="conn_type" width="100%">
	  	 <tr>
	  	  <td class="head" id="wAccMode">Access Mode</td>
	  	  <td>
	  	    <select name="connectionType" size="1" onChange="connectionTypeSwitch();">
	  	    </select>
	  	  </td>
	  	 </tr>
	  	</table>
	  </td></tr>

	  <tr><td>
		<!-- ================= STATIC Mode ================= -->
		<table id="static" width="100%">
		<tr><td class="title" id="wStaticMode">Static IP</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
          <td colspan="2" class="title" id="wStaticIpNetSet">WAN IP Network Settings</td>
		</tr>
		<tr>
		  <td class="head" id="wStaticIp">IP Address</td>
  <td><input name="staticIp" maxlength=15 value="<% getCfgGeneral(1, "wan2_ipaddr", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wStaticNetmask">Subnet Mask</td>
  <td><input name="staticNetmask" maxlength=15 value="<% getCfgGeneral(1, "wan2_netmask", 0); %>">
		  </td>
		</tr>
		<tr>
		  <td class="head" id="wStaticGateway">Gateway IP Address</td>
  <td><input name="staticGateway" maxlength=15 value="<% getCfgGeneral(1, "wan2_gateway", 0); %>">
		  </td>
		</tr>
		<tr>
          <td colspan="2" class="title" id="wStaticDns">DNS Server IP Address</td>
		</tr>
		<tr>
		  <td colspan="2">
		    <table width="95%" align="center" cellspaing="1">
		      <tr>
		        <td class="head" id="wStaticPriDns">Primary IP Addres</td>
  <td><input name="staticPriDns" maxlength=15 value="<% getCfgGeneral(1, "wan2_primary_dns", 0); %>"></td>
		      </tr>
		      <tr>
		        <td class="head" id="wStaticSecDns">Secondary IP Address</td>
  <td><input name="staticSecDns" maxlength=15 value="<% getCfgGeneral(1, "wan2_secondary_dns", 0); %>"></td>
              </tr>
            </table>
          </td>
		</tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

	  <tr><td>
		<!-- ================= DHCP Mode ================= -->
		<table id="dhcp" width="100%">
		<tr><td class="title" id="wDhcpMode">DHCP Mode</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
		  <td class="head" id="wDhcpHost">Router Name</td>
		  <td><input type="text" name="hostname" maxlength="32" value="<% getCfgGeneral(1, "HostName", 0); %>"></td>
		</tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

	  <tr><td>
		<!-- ================= PPPOE Mode ================= -->
		<table id="pppoe" width="100%">
		<tr><td class="title" id="wPppoeMode">PPPoE Client Mode</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
		  <td class="head" id="wPppoeUser">Username</td>
		  <td><input name="pppoeUser" maxlength=63 value="<% getCfgGeneral(1, "wan2_pppoe_user", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPppoePassword">Password</td>
		  <td><input type="password" name="pppoePass" maxlength=32 value="<% getCfgPwd(1, "wan2_pppoe_pass"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPppoePass2">Confirm Password</td>
		  <td><input type="password" name="pppoePass2" maxlength=32 value="<% getCfgPwd(1, "wan2_pppoe_pass"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPppoeOPMode">Redial Policy</td>
		  <td>
		    <select name="pppoeOPMode" size="1" onChange="pppoeOPModeSwitch()">
		      <option value="KeepAlive" id="wPppoeKeepAlive">Always On</option>
		      <option value="OnDemand" id="wPppoeOnDemand">Connect On Demand</option>
		    </select>
		  </td>
		</tr>
		<tr id="pppoeIdleTimeoutRow">
          <td id="wPppoeIdle">Idle Timeout</td>
          <td>
            <input type="text" name="pppoeIdleTime" maxlength="3" size="2" value="5">
            <span id="wPppoeMin">minute(s)</span>
          </td>
        </tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

	  <tr><td>
		<!-- ================= L2TP Mode ================= -->
		<table id="l2tp" width="100%">
		<tr><td class="title" id="wL2tpMode">L2TP Client Mode</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
		  <td class="head" id="wL2tpServer">Server IP</td>
		  <td><input name="l2tpServer" maxlength="64" value="<% getCfgGeneral(1, "wan2_l2tp_server", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wL2tpUser">Username</td>
		  <td><input name="l2tpUser" maxlength="20" value="<% getCfgGeneral(1, "wan2_l2tp_user", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wL2tpPassword">Password</td>
		  <td><input type="password" name="l2tpPass" maxlength="32" value="<% getCfgPwd(1, "wan2_l2tp_pass"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wL2tpOPMode">Redial Policy</td>
		  <td>
		    <select name="l2tpOPMode" size="1" onChange="l2tpOPModeSwitch()">
		      <option value="KeepAlive" id="wL2tpKeepAlive">Always On</option>
		      <option value="OnDemand" id="wL2tpOnDemand">Connect On Demand</option>
		    </select>
		  </td>
		</tr>
		<tr id="l2tpIdleTimeoutRow">
          <td id="wL2tpIdle">Idle Timeout</td>
          <td>
            <input type="text" name="l2tpIdleTime" maxlength="3" size="2" value="5">
            <span id="wL2tpMin">minute(s)</span>
          </td>
        </tr>
		<tr>
		  <td colspan="2" class="title" id="wL2tpAddrMode">WAN IP Network Settings</td>
		</tr>
		<tr>
		  <td colspan="2">
		    <table width="95%" align="center" cellspaing="1">
		      <tr>
		        <td colspan=2><input type="radio" name="l2tpMode" value="1" onclick="chgL2tpMode()"><span id="wL2tpModeDhcp">Obtain an IP address automatically</span></td>
		      </tr>
		      <tr>
		        <td colspan=2><input type="radio" name="l2tpMode" value="0" onclick="chgL2tpMode()"><span id="wL2tpModeStatic">Specify an IP address</span></td>
		      </tr>
		      <tr>
		        <td class="head" id="wL2tpIp">IP Address</td>
		        <td><input name="l2tpIp" maxlength=15 value="<% getCfgGeneral(1, "wan2_l2tp_ip", 0); %>"></td>
		      </tr>
		      <tr>
		        <td class="head" id="wL2tpNetmask">Subnet Mask</td>
		        <td><input name="l2tpNetmask" maxlength=15 value="<% getCfgGeneral(1, "wan2_l2tp_netmask", 0); %>">
		        </td>
		      </tr>
		      <tr>
		        <td class="head" id="wL2tpGateway">Gateway IP Address</td>
		        <td><input name="l2tpGateway" maxlength=15 value="<% getCfgGeneral(1, "wan2_l2tp_gateway", 0); %>">
		        </td>
		      </tr>
		    </table>
		  </td>
		</tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

	  <tr><td>
		<!-- ================= PPTP Mode ================= -->
		<table id="pptp" width="100%">
		<tr><td class="title" id="wPptpMode">PPTP Client Mode</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
		  <td class="head" id="wPptpServer">Server IP</td>
		  <td><input name="pptpServer" maxlength="64" value="<% getCfgGeneral(1, "wan2_pptp_server", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPptpUser">Username</td>
		  <td><input name="pptpUser" maxlength="20" value="<% getCfgGeneral(1, "wan2_pptp_user", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPptpPassword">Password</td>
		  <td><input type="password" name="pptpPass" maxlength="32" value="<% getCfgPwd(1, "wan2_pptp_pass"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="wPptpOPMode">Redial Policy</td>
		  <td>
		    <select name="pptpOPMode" size="1" onChange="pptpOPModeSwitch()">
		      <option value="KeepAlive" id="wPptpKeepAlive">Always On</option>
		      <option value="OnDemand" id="wPptpOnDemand">Connect On Demand</option>
		    </select>
		  </td>
		</tr>
		<tr id="pptpIdleTimeoutRow">
          <td id="wPptpIdle">Idle Timeout</td>
          <td>
            <input type="text" name="pptpIdleTime" maxlength="3" size="2" value="5">
            <span id="wPptpMin">minute(s)</span>
          </td>
        </tr>
		<tr>
		  <td colspan="2" class="title" id="wPptpAddrMode">WAN IP Network Settings</td>
		</tr>
		<tr>
		  <td colspan="2">
		    <table width="95%" align="center" cellspaing="1">
		      <tr>
		        <td colspan=2><input type="radio" name="pptpMode" value="1" onclick="chgPptpMode()"><span id="wPptpModeDhcp">Obtain an IP address automatically</span></td>
		      </tr>
		      <tr>
		        <td colspan=2><input type="radio" name="pptpMode" value="0" onclick="chgPptpMode()"><span id="wPptpModeStatic">Specify an IP address</span></td>
		      </tr>
		      <tr>
		        <td class="head" id="wPptpIp">IP Address</td>
		        <td><input name="pptpIp" maxlength=15 value="<% getCfgGeneral(1, "wan2_pptp_ip", 0); %>"></td>
		      </tr>
		      <tr>
		        <td class="head" id="wPptpNetmask">Subnet Mask</td>
		        <td><input name="pptpNetmask" maxlength=15 value="<% getCfgGeneral(1, "wan2_pptp_netmask", 0); %>">
		        </td>
		      </tr>
		      <tr>
		        <td class="head" id="wPptpGateway">Gateway IP Address</td>
		        <td><input name="pptpGateway" maxlength=15 value="<% getCfgGeneral(1, "wan2_pptp_gateway", 0); %>">
		        </td>
		      </tr>
		    </table>
		  </td>
		</tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

	  <tr><td>
		<!-- =========== 3G Modular =========== -->
		<table id="3G" width="100%">
		<tr><td class="title" id="w3GMode">3G USB Modem</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
		<tr>
		  <td class="head" id="w3GPin">SIM PIN code</td>
		  <td colspan="2"><input type="password" name="wan_pincode" maxlength=15 value="<% getCfgPwd(1, "3gwan_pincode"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="w3GInitStr1">Modem Initial String1</td>
		  <td><input name="wan_init_str1" maxlength=47 value="<% getCfgGeneral(1, "3gwan_init_string1", 0); %>"></td>
		  <td>(<span id="wDefaultstr0">default</span>:AT&F)</td>
		</tr>
		<tr>
		  <td class="head" id="w3GInitStr2">Modem Initial String2</td>
		  <td><input name="wan_init_str2" maxlength=47 value="<% getCfgGeneral(1, "3gwan_init_string2", 0); %>"></td>
		  <td>(<span id="wDefaultstr1">default</span>:ATE0V1X1&D2&C1S0=0)</td>
		</tr>
		<tr>
		  <td class="head" id="w3GAPN">APN Name</td>
		  <td><input name="wan_apn" maxlength=31 value="<% getCfgGeneral(1, "3gwan_apn", 0); %>"></td>
		  <td>(<span id="wDefaultstr2">default</span>:internet)</td>
		</tr>
		<tr>
		  <td class="head" id="w3GDialStr">Modem Dial String</td>
		  <td><input name="wan_dial_str" maxlength=31 value="<% getCfgGeneral(1, "3gwan_dial_string", 0); %>"></td>
		  <td>(<span id="wDefaultstr3">default</span>:ATDT*99#)</td>
		</tr>
		<tr>
		  <td class="head" id="w3GPPPUser">PPP Username</td>
		  <td colspan="2"><input name="wan_usr" maxlength=47 value="<% getCfgGeneral(1, "3gwan_username", 0); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="w3GPPPPwd">PPP Password</td>
		  <td colspan="2"><input type="password" name="wan_pwd" maxlength=47 value="<% getCfgPwd(1, "3gwan_password"); %>"></td>
		</tr>
		<tr>
		  <td class="head" id="w3GPPPAuth">PPP Authentication</td>
		  <td colspan="2">
		    <select name="wan_auth">
    		  <option value="0" id="w3GAuthOnly">PAP only</option>
    		  <option value="1" id="w3GAuthBoth" selected="selected">PAP or CHAP</option>
            </select>
          </td>
		</tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>
      <tr><td>
        <!-- =========== 4G =========== -->
		<table id="wimax" width="100%">
		<tr><td class="title" id="wWimaxMode">4G USB Modem</td></tr>
		<tr><td>
		<table width="95%" align="center" cellspaing="1">
        <tr id="trserpro">
          <td id="wWimaxServPro">Service Provider</td>
          <td><select name="WimaxSerPro" size="1" onChange="onChgServPro();">
            <option value="0" id="wWimaxSerProNone">None</option>
            <option value="1"  style="display:none">Russia (YOTA)</option>
            <option value="2"  style="display:none">Nicaragua (YOTA)</option>
            <option value="3"  style="display:none">Lithuania (Mezon)</option>
            <option value="4">Taiwan (Global Mobile)</option>
            <option value="5">Taiwan (Tatung)</option>
            <option value="7">Taiwan (Vee TIME)</option>
            <option value="8">Taiwan (VMAX)</option>
            <option value="6"  style="display:none">Sweden</option>	
          </select></td>
        </tr>
        <tr class="WimaxSerTwGlob">
          <td id="wWimaxSerTwGlobUsr">Username</td>
          <td><input name="wimax_user" maxlength=32 size=32 value="<% getCfgGeneral(1, "wimax_user", 0); %>"></td>
        </tr>
        <tr class="WimaxSerTwGlob">
          <td id="wWimaxSerTwGlobPass">Password</td>
          <td><input type="password" name="wimax_passwd" maxlength=32 size=32 value="<% getCfgPwd(1, "wimax_passwd"); %>"></td>
        </tr>
        <tr class="WimaxSerTwGlob">
          <td id="wWimaxSerTwGlobCipher">Cipher Suite</td>
          <td><select name="wimax_cipher" size="1">
            <option value="0">RSA_RC4_128_MD5</option>
            <option value="1">RSA_AES_256_SHA</option>
            <option value="2">DHE_RSA_AES_256_SHA</option>
          </select></td>
        </tr>
        <tr id="trwimaxselrul">
          <td id="wWimaxSelRule">Base Station Select Rule</td>
          <td>
            <input type="radio" name="selrul" id="firstbs" value="3" /><label for="firstbs" id="wWimaxSelRuleFirstBS">First BS</label>&nbsp;
            <input type="radio" name="selrul" id="rssi" value="2" /><label for="rssi" id="wWimaxSelRuleRSSI">RSSI</label>&nbsp;
            <input type="radio" name="selrul" id="cinr" value="1" /><label for="cinr" id="wWimaxSelRuleCINR">CINR</label>&nbsp;
            <input type="radio" name="selrul" id="freq" value="0" /><label for="freq" id="wWimaxSelRuleFrequency">Frequency</label>
          </td>
        </tr>
        <tr id="tr4gpin">
          <td id="w4GPin">SIM PIN code</td>
          <td id="tdlte_pin"><input type="text" name="lte_pin" id="lte_pin" maxlength=15></td>
        </tr>
        <tr id="tr4gnmod">
          <td id="w4GNetworkMode">Network Mode</td>
          <td><select name="lte_net_mode" id="lte_net_mode">
            <option value="0">4G/3G/2G</option>
            <option value="1">4G Only</option>
            <option value="2">3G Only</option>
            <option value="3">2G Only</option>
          </select>
          (<span id="w4GNModDef">default</span>:4G/3G/2G)</td>
        </tr>
        <tr id="tr4gapn">
          <td id="w4GAPN">APN Name</td>
          <td><input name="lte_apn" maxlength=31 value="<% getCfgGeneral(1, "lte_apn", 0); %>"></td>
        </tr>
		</table>
		</td></tr>
		</table>
	  </td></tr>

      <tr><td>
        <table width=100%>
          <tr>
            <td class=title width=5% id="wNote">Note :</td><td id="wNote1">WAN2 is used for backup only</td>
          </tr>
        </table>
	  </td></tr>
	</table>
  </td>
</tr>
</table>

<br />
<table width="100%" border="0" cellpadding="2" cellspacing="1">
  <tr align="right">
    <td>
      <input type="button" name="btnBck" id="btnBck" value="&lt; Back" onclick="JavaScript:w.ntpBack=1;history.back();">&nbsp;&nbsp;
      <input type="button" name="btnNxt" id="btnNxt" value="Next &gt;" onclick="onClkBtnNxt();">&nbsp;&nbsp;
      <input type="button" name="btnFin" id="btnFin" value="Finish" disabled >&nbsp;&nbsp;
      <input type="button" name="btnCcl" id="btnCcl" value="Cancel" onClick="onClkBtnCcl()">
    </td>
  </tr>
</table>
</form>

</td></tr>
</table>

</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
