Butterlate.setTextDomain("msg");

var IP_PROTOCOL = "ip_protocol";
var IP_FMT = "IP";
var MAC_FMT = "MAC";

/* Initial an XMLHttpRquest object */
function initXMLHTTP()
{
    var req = false;
    if (window.XMLHttpRequest) {
        try {
            req = new XMLHttpRequest();
        } catch(e) {
            req = false;
        }
    } else if (window.ActiveXObject) {
        try {
            req = new ActiveXObject("Msxml2.XMLHTTP");
        } catch(e) {
            try {
                req = new ActiveXObject("Microsoft.XMLHTTP");
            } catch(e) {
                req = false;
            }
        }
    }
    return req;
}

function loadXMLDoc(method, file, callback, content)
{
    var req = initXMLHTTP();

    if (!req) {
        alert('Cannot create an XMLHTTP instance');
        return false;
    }

    req.open(method, file, true);
    req.onreadystatechange = function() {
        try {
            if (req.readyState == 4) {
                if (req.status && req.status == 200) {
                    callback(req);
                    req = null; // MSIE leak avoidance
                } else {
                    var status;
                    try {
                        status = req.statusText;
                    } catch(e) {
                        status = "Unknown error";
                    }
                    alert("There was a problem retrieving the dynamic data:\n" + status);
                    callback(req);
                    req = null; // MSIE leak avoidance
                }
            }
        } catch(e) {
            // If a page is currently being requested and the user clicks another link on
            // the web page, FireFox (2.0 at least - haven't tested with 1.5) will throw
            // an exception causing this piece of code to be called, whereas Internet
            // Explorer (7.0 at least - haven't tested with 6.0) doesn't. If the Web
            // page that requested the error calls SpomHandleError() then the main
            // page will get recalled. The best thing is therefore not to call the
            // callback function unless there's real data associated; hence the
            // commenting out of the callback() call below.
            // alert("Request error (file = " + file + ". e = " + e + "req = " + req + ")");
            // callback(req, ref);
            req = null; // MSIE leak avoidance
        }
    };
    req.send(content);
    return req;
}

function GiveAlert(Message, fld)
{
    if(fld) {
		if (fld.type != "hidden" && fld.disabled != true && fld.style.display != "none")
        	fld.focus();
        if(fld.select && typeof(fld.select) == "function")
            fld.select();
    }
    alert(Message);
    return false;
}

// Check if a number is a valid hex number
function IsHex(Value, AlertOn)
{
    var  AlertOn = (AlertOn == null) ? 0 : AlertOn;
    var ValueIsHex = Value.match(/^[0-9a-f]+$/i);

    if (!ValueIsHex && AlertOn) {
        alert ("Value " + Value + " is not a valid hex number");
    }

    return ValueIsHex;
}

function isInt (str)
{
    var i = parseInt (str);

    if (isNaN (i))
	return false;

    i = i . toString ();
    if (i != str)
	return false;

    return true;
}

// Check if a field value is a valid integer
// Uses GiveAlert in case of errors
//function isIntId(fld_id)
function isIntId(fld)
{
//    var fld = document.getElementById(fld_id);
    if (!fld)
		return GiveAlert("No such field: " + fld.name, fld);

    if (!isInt(fld.value)) {
		return GiveAlert("\"" + fld.value + "\" " + _("msg invalid int"), fld);
    }

    return true;
}

// Check if a field value is a valid integer and within a valid range
// Uses GiveAlert in case of errors
function isIntWithinRange(fld, MinVal, MaxVal, name_text)
{
	var minval  = (MinVal == null)?0:MinVal;
    var maxval  = (MaxVal == null)?65535:MaxVal;

    if (!fld)
		return GiveAlert("No such field: " + fld.name, fld);
	if(!name_text)
      name_text = fld.name;

	if(fld.value.length == 0) {
		return GiveAlert(_("msg int input"), fld);
	}

	// isNaN() works on a string, so don't parseInt(fld.value)
    // before calling this function, or isNaN() won't be able
    // to detect e.g. "1K", since parseInt() will parse this
    // string as '1' first.
    if (!isInt(fld.value)) {	// isNaN() is called in isInt()
		return GiveAlert("\"" + fld.value + "\" " + _("msg invalid int"), fld);
    }

	if(fld.value < minval || fld.value > maxval) {
        return GiveAlert(name_text + " " + _("msg invalid range") + " (" + minval + " ~ " + maxval + ")!", fld);
    } 
    return true;
}

// Input check for MAC address. Returns false if it isn't a valid MAC address else true
function IsMacAddress(Value,AlertOn)
{
    // Default value
    var  AlertOn = (AlertOn == null) ? 0 : AlertOn;

    // Split the max address up in 6 part ( Allowed format is 00-11-22-33-44-55 or 00:11:22:33:44:55 or 001122334455
	var sep = ["-", ":"];
	for(var i in sep) {
	    if (Value.indexOf(sep[i]) != -1 ) {
			var MACAddr = Value.split(sep[i]);

	        if(MACAddr.length == 6) {
	            for (var i = 0; i < MACAddr.length; i++) {
	                if (MACAddr[i].length != 2) {
	                    if (AlertOn ) {alert ("MAC address contains not 2 digits")};
	                    return false;
	                } else {
	                    if (!IsHex(MACAddr[i],AlertOn))
	                        return false;
	                }
	            }
	            return true;
	        } else {
			    if (AlertOn ) { alert ("MAC should have 6 digit groups")};
			    return false;
	        }
	    }
	}

	if (Value.length != 12 ) {
	    if (AlertOn ) { alert ("MAC address must be 12 characters long")};
	    return false;
	}

    if (!IsHex(Value,AlertOn))
        return false;

    return true;
}

function IsValidMacAddress(f)
{
    var ret;
    if(typeof(f) == "string")
        f = document.getElementById(f);
    if(!(ret = IsMacAddress(f.value, 1)))
        f.select();
    return ret;
}

// isIpStr()
// Function that checks that input value is a valid IP string (xxx.xxx.xxx.xxx).
// @fld_id:     is the name of the field. It's value is used as input in the
//              check. It's also used to set focus if an error occurs.
// @is_mask:    Set to true if the input must be a mask, i.e. all-ones on the left and all-zeros on the right of the boundary.
// @start_text: In case of an error, focus is set to @fld_id and one of the following strings is shown:
//              "The value of " + start_text + " is not a valid IP address.\nValid IP strings have the format 'xxx.xxx.xxx.xxx' where 'xxx' is a number between 0 and 255."
//              "The value of " + start_text + " is not a valid IP mask.\nValid IP masks have the format 'xxx.xxx.xxx.xxx' where 'xxx' is a number between 0 and 255."
// @allow_what. Used only if @is_mask is false. 'Enumeration' of which IP addresses (x.y.z.w) are allowed.
//      @allow_what    || Allow x > 223 | Allow x == 127 | Allow 0.x.x.x | Allow 0.0.0.0
//      ---------------||---------------|----------------|---------------|--------------
//      Undefined or 0 ||      No       |      No        |      No       |      Yes
//                   1 ||      No       |      No        |      No       |      No
//                   2 ||      Yes      |      Yes       |      Yes      |      Yes

// The main validation parts
function _isValidIpStr(val, is_mask, allow_what)
{
  var error = false;

  if(val.length == 0) {
    // User-input error
    error = true;
  } else {
    var myReg;
    var show_error = false;
    myReg = /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
    if(myReg.test(val)) {
      if(RegExp.$1 > 255 || RegExp.$2 > 255 || RegExp.$3 > 255 || RegExp.$4 > 255) {
        // At least one of ip1, ip2, ip3, or ip4 is not in interval 0-255.
        error = true;
      } else if(is_mask) {
        // Check that the mask is contiguous
        var ip_as_int = (RegExp.$1 << 24) | (RegExp.$2 << 16) | (RegExp.$3 << 8) | RegExp.$4;
        var zero_found = false, i;
        for(i = 31; i >= 0; i--) {
          if((ip_as_int & (1 << i)) == 0) {
            // Cleared bit was found.
            zero_found = 1;
          } else if(zero_found) {
            // Set bit was found and cleared bit was previously found => Error
            error = true;
            break;
          }
        }
      } else {
        if(allow_what == 0 || allow_what == 1) {
          // Disallow x > 223, x == 127, and 0.x.x.x
          if(RegExp.$1 == 127 || RegExp.$1 > 223) {
            // ip1 indicates loopback (127), a multicast address (224-239), or an experimental address (240-255).
            error = true;
          } else if(RegExp.$1 == 0 && (RegExp.$2 != 0 || RegExp.$3 != 0 || RegExp.$4 != 0)) {
            // Class 0 is not allowed
            error = true;
          } else  if(allow_what == 1 && RegExp.$1 == 0 && RegExp.$2 == 0 && RegExp.$3 == 0 && RegExp.$4 == 0) {
            // 0.0.0.0 is not allowed
            error = true;
          }
        }
      }
    } else {
      // Didn't match regexp
      error = true;
    }
  }

  return !error;
}

// Shorthand function
function _isValidIpAddress(val)
{
    return _isValidIpStr(val, false, 1);
}

function isIpStr(fld_id, is_mask, start_text, allow_what)
{
  if(!allow_what || allow_what < 0) {
    // In case allow_what is undefined
    allow_what = 0;
  } else if (allow_what > 2) {
    allow_what = 2;
  }

  var fld = document.getElementById(fld_id);
  if(!fld)
    // Programming error
    return GiveAlert("No such field: " + fld_id, fld);

  var isok = _isValidIpStr(fld.value, is_mask, allow_what);
  if(!isok) {
    if(is_mask) {
      GiveAlert("The value of " + start_text + " is not a valid IP mask.\n\n" +
                "A valid IP mask is a dotted decimal string ('x.y.z.w'), where\n" +
                "  1) x, y, z, and w are decimal numbers between 0 and 255,\n" +
                "  2) when converted to a 32-bit binary string and read from left to right,\n"+
                "     all bits following the first zero must also be zero.", fld);
    } else {
      if(allow_what == 0 || allow_what == 1) {
        GiveAlert("The value of " + start_text + " must be a valid IP address in dotted decimal notation ('x.y.z.w').\n\n" +
                  "The following restrictions apply:\n" +
                  "  1) x, y, z, and w must be decimal numbers between 0 and 255,\n" +
                  "  2) x must not be 0" + (allow_what == 0 ? " unless also y, z, and w are 0" : "") + ",\n" +
                  "  3) x must not be 127, and\n" +
                  "  4) x must not be greater than 223.", fld);
      } else {
         GiveAlert("The value of " + start_text + " must be a valid IP address in dotted decimal notation ('x.y.z.w'),\n" +
                   "where x, y, z, and w are decimal numbers between 0 and 255.", fld);
      }
    }
  } else {
    // Get rid of insignificant preceding zeros - if any.
    // Well, in fact, if a string is preceded by a zero, then it's perceived as an octal number (e.g. parseInt("010") == 8)!!
    fld.value = parseInt(RegExp.$1) + "." + parseInt(RegExp.$2) + "." + parseInt(RegExp.$3) + "." + parseInt(RegExp.$4);
  }

  return isok;
}

function isEmpty(errmsg, f)
{
    if(typeof(f) == "string")
        f = document.getElementById(f);
    if(f && f.value.length == 0)
        return !GiveAlert(errmsg, f);
}

function trimInput(f)
{
    if(typeof(f) == "string")
        f = document.getElementById(f);
    if(f) {
        var str = f.value;
        str = str.replace(/^\s+/, "");
        str = str.replace(/\s+$/, "");
        f.value = str;
    }
    return f;
}

function UpdateId(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.innerHTML = val;
    }
    return elm;
}

function UpdateIdValue(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.value = val;
        elm.defaultValue = val;
    }
    return elm;
}

function UpdateIdChecked(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.checked = val;
        if(val) {
            elm.setAttribute("checked", "checked");
            elm.setAttribute("defaultChecked", "checked");
        }
    }
    return elm;
}

function UpdateIdSetSelect(id, value)
{
    var elm = document.getElementById(id);
    if(elm && elm.options) {
        for (var i = 0; i < elm.options.length; i++) {
            var opt = elm.options[i];
            var sel = (opt.value == value);
            opt.selected = sel;
            opt.defaultSelected = sel;
            if (sel)
                elm.selectedIndex = i;
        }
    }
    return elm;
}

function searchArgs(search)
{
    var tups = search.substring(1).split('&');
    var args = new Array();
    for(var i = 0; i < tups.length; i++) {
        var tup = tups[i].split('=');
        if(tup.length == 2)
            args[tup[0]] = tup[1];
        else
            args[tup[0]] = 1;
    }
    return args;
}

function SetVisible(id, visible)
{
    var elm = document.getElementById(id);
    if (visible)
        elm.style.display = '';
    else
        elm.style.display = 'none';
}

function SetDisable(name, disable)
{
    var elm = document.getElementById(name);
    if(disable)
        elm.disabled = false;
    else
        elm.disabled = true;
}

function cpntCtrl( _ctrl, _frm, _fstElmt, _cnt)
{
	var ctrl = _ctrl, frm = _frm, fstElmt = _fstElmt, cnt = _cnt;
	var check;
	var tt = getIdxOfForm(fstElmt);

	/* if ctrl lose right of control */
//	if ( ctrl.disabled == true ) {
//		return;
//	}

	if ( ctrl == true ||  ctrl == false ) {
		check = ctrl;
		for ( var i = tt; i < cnt + tt; i++ ) {
			frm[i].disabled = !check;
		}
		return;
	}

	switch ( ctrl.type ) {
		case "radio":
		case "checkbox":
			check = ctrl.checked;
			for ( var i = tt; i < cnt + tt; i++ ) {
				frm[i].disabled = !check;
			}
			break;
	}
}

function getElmtById(idVal)
{
	return document.getElementById(idVal);
}

function getIdxOfForm( _elmt )
{
	var elmt = _elmt;
	if ( elmt.type )
	{
		for ( var i=0; i<elmt.form.length; i++ )
		{
			if(elmt.name!="" && elmt.form[i].name!=""){
				if( elmt.name == elmt.form[i].name) return i;
			}else{
				if( elmt == elmt.form[i]) return i;
			}
		}
	}
	return false;
}

function getIdxbyName(_form, _name )
{
	if (!_name || _name == "") return false;
	for (var i=0; i<_form.length; i++) {
		if (_form[i].name != "" && _form[i].name == _name) return i;
	}
	return false;
}

function setVle2Elmt( _elmt, _vle, _fmt )
{
	var elmt = _elmt;
	var vle = _vle;
	var fmt = _fmt;
	switch( elmt.type )
	{
		case "button":
			break;
		case "checkbox":
			if ( vle > 0 || true == vle || "true" == vle || "1" == vle || "on" == vle )
				elmt.checked = true;
			else
				elmt.checked = false;
			break;
		case "radio":
			for ( var i=0; i<elmt.form.length; i++ )
				if ( elmt.name == elmt.form[i].name && ( vle == elmt.form[i].value ) )
					elmt.form[i].checked = true;
			break;
		case "submit":
			break;
		case "text":
		case "hidden":
			if ( fmt == IP_FMT )
				spareIp( elmt, vle );
			else
				elmt.value = vle;
			break;			
		case "password":
			elmt.value = vle;
			break;
		case "select-one":
			for ( var i=0; i<elmt.options.length; i++ )
			{
				if ( elmt.options[i].value == vle )
				{
					elmt.selectedIndex = i;
					elmt.options[i].selected = true;
					return;
				}
			}
			elmt.selectedIndex  = 0;
			break;
		case "textarea":
			elmt.value=vle;
			break;
	}
	return;
}

function getVleFromElmt( _elmt, _fmt )
{
	var elmt = _elmt;
	var fmt = _fmt;

	switch( elmt.type )
	{
		case "button":
			break;
		case "checkbox":
			if ( elmt.checked == true )
				return "1";
			else
				return "0";
			break;
		case "radio":
			for ( var i=0; i<elmt.form.length; i++ )
				if ( elmt.name == elmt.form[i].name && (true == elmt.form[i].checked ) )
					return elmt.form[i].value;
			break;
		case "submit":
			break;
		case "text":
		case "hidden":
			if ( fmt == IP_FMT ){
				if ( mixIp( elmt ) != false ) return mixIp( elmt );
				else return "";
			}
			else if ( fmt == MAC_FMT ){
				if ( mixMac( elmt ) != false ) return mixMac( elmt );
				else return "";
			}
			else
				return elmt.value;
			break;			
		case "password":
			return elmt.value;
			break;
		case "select-one":
			for ( var i=0; i<elmt.options.length; i++ )
			{
				if ( elmt.options[i].selected == true )
				{
					//alert( "getVleFromElmt() => i:"+i+" value:"+elmt.options[i].value );
					return elmt.options[i].value;
				}
			}
			break;
	}
}

function showElmtByClass(_doc, _tag, _el)
{
	var doc = _doc;
	var tag = _tag;
	var el = _el;
	if (doc.getElementsByTagName) {
		var nodes = doc.getElementsByTagName(tag);
		var max = nodes.length;
		for (var i = 0; i < max; i++) {
			var node = nodes.item(i);
			if (node.className == el) { node.style.display = ""; }
		}
	}
}

function hideElmtByClass(_doc, _tag, _el)
{
	var doc = _doc;
	var tag = _tag;
	var el = _el;
	if (doc.getElementsByTagName) {
		var nodes = doc.getElementsByTagName(tag);
		var max = nodes.length;
		for (var i = 0; i < max; i++) {
			var node = nodes.item(i);
			if (node.className == el) { node.style.display = "none"; }
		}
	}
}

function showElmtById(_doc, _el)
{
	var doc = _doc;
	var el = _el;
	getElmtById(el).style.display = "";
}

function hideElmtById(_doc, _el)
{
	var doc = _doc;
	var el = _el;
	getElmtById(el).style.display = "none"; 
}

function strFormat(str, len)
{
	str = str.toString();
	var l = checkLength(str);
	for(var i=l; i<len; i++){
		str += "\u00a0";
	}
	return str;
}

function checkLength(strTemp)
{
	var i,sum;
	sum=0;
	for(i=0;i<strTemp.length;i++)
	{
		if ((strTemp.charCodeAt(i)>=0) && (strTemp.charCodeAt(i)<=255))
			sum=sum+1;
		else
			sum=sum+2;
	}
	return sum;
}

function ShellSort(_arr, _key, _type)
{
	var arr = _arr;
	var key = _key;
	var tp = _type;
	var increment = arr.length;
	do {
		increment = (increment/3|0) + 1;
		arr = ShellPass(arr, increment, key, tp);
	}
	while (increment > 1)
	return arr;
}

function ShellPass(_arr, _d, _key, _type)
{
	var arr = _arr;
	var d = _d;
	var key = _key;
	var tp = _type;
	var iTmp1, iTmp2, aryTemp, j;
	if(!tp){
	    for(var i=d; i<arr.length; i++) {
		    iTmp1 = strParser(arr[i][key]);
		    iTmp2 = strParser(arr[i-d][key]);
		    if(iTmp1 < iTmp2) {
			    aryTemp = arr[i];
			    j = i-d;
			    do {
				    arr[j+d] = arr[j];
				    j = j-d;
			    }
			    while (j>-1 && strParser(aryTemp[key]) < strParser(arr[j][key]));
			    arr[j+d] = aryTemp;
		    }//endif
	    }
	}else{
		for(var i=d; i<arr.length; i++) {
			iTmp1 = strParser(arr[i][key]);
			iTmp2 = strParser(arr[i-d][key]);
			if(iTmp1 > iTmp2) {
				aryTemp = arr[i];
				j = i-d;
				do {
					arr[j+d] = arr[j];
					j = j-d;
				}
				while (j>-1 && strParser(aryTemp[key]) > strParser(arr[j][key]));
				arr[j+d] = aryTemp;
			}//endif
		}
	}
	return arr;
}

function strParser(_str)
{
	var str = _str;
	str = str.replace(/\s{1,}/g, "");
	str = str.replace(/\(/g, "");
	str = str.replace(/\/\d+\)/g, "");
	str = str.replace(/\/\d+/g, "");
    str = str.replace(/>/g, "");
    str = str.replace(/_[-\w]+/g, "");
	if(isStrIp(str)){
		str = inet_addr(str);
	}else if(!isNaN(parseInt(str))){
		str = parseInt(str);
	}else if(str == "---"){
		str = -1;
	}else{
		str = -2;
	}
	return str;
}

function isEqualLan( _ip1, _mask1, _ip2 )
{
	var ip1 = _ip1;
	var mask1 = _mask1;
	var ip2 = _ip2;
	var uiIp1 = inet_addr( ip1 );
	var uiMsk1 = inet_addr( mask1 );
	var uiIp2 = inet_addr( ip2 );
	if( ((Math.floor(uiIp1/0x10000) & Math.floor(uiMsk1/0x10000)) == (Math.floor(uiIp2/0x10000) & Math.floor(uiMsk1/0x10000))) &&
		((Math.floor(uiIp1%0x10000) & Math.floor(uiMsk1%0x10000)) == (Math.floor(uiIp2%0x10000) & Math.floor(uiMsk1%0x10000))) )
		return true;
	else
		return false;
}

function inet_addr( _strIp )
{
	var strIp = _strIp;
	var aryIp = strIp.split(".");
	if( aryIp.length != 4 || aryIp[3] == "" ) {
		return false;
	} else {
		for( var i=0, uiIp=0; i<4; i++) {
			if( !(aryIp[i] <= 255 && aryIp[i] >= 0) ) {
				return false;
			}
			uiIp += aryIp[i]*raisePower(256, 3-i);
		}
	}
	return uiIp;
}

function isStrIp( _strIp )
{
	var strIp = _strIp;
	strIp += "";
	var aryIp = strIp.split(".");
	if( aryIp.length != 4 ) return false;
	else {
		for( var i=0, u32Ip=0; i<4; i++ )
		{
			if( !(aryIp[i] <= 255 && aryIp[i] >= 0) ) return false;
			u32Ip += parseInt(aryIp[i])*raisePower(256, 3-i);
		}
	}
	if ( u32Ip > 0 && u32Ip <= 0xffffffff ) return true;  
	else return false;
}

function raisePower( _x, _y )
{
	var x = _x;
	var y = _y;
	return Math.pow( x, y )
}

function atoi(str, num)
{
	i = 1;
	if (num != 1) {
		while (i != num && str.length != 0) {
			if (str.charAt(0) == '.') {
				i++;
			}
			str = str.substring(1);
		}
		if (i != num)
			return -1;
	}

	for (i=0; i<str.length; i++) {
		if (str.charAt(i) == '.') {
			str = str.substring(0, i);
			break;
		}
	}
	if (str.length == 0)
		return -1;
	return parseInt(str, 10);
}

function checkRange(str, num, min, max)
{
	d = atoi(str, num);
	if (d > max || d < min)
		return false;
	return true;
}

function checkAllNum(str)
{
	for (var i=0; i<str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
			continue;
		return false;
	}
	return true;
}

function isStrNum(str) {
   var b,c,d;	
   var strByte = str;
   strByte += "";
   if( strByte.length == 0){
   	return false;
   }
   for( b = 0; b <  strByte.length ; b++){
     c = parseInt( strByte.charAt(b),10 );
     if( isNaN(c) ){
    	return false;
     }
   }
   d = parseInt( strByte ,10 );
   if ( isNaN(d) ){
    	return false;
   } 
   return true;
}

function checkIpAddr(field, ismask)
{
	var errmsg;

	if (ismask)
		errmsg = _("msg ipmask invalid");
	else
		errmsg = _("msg ipaddr invalid");

	if (field.value == "") {
		if (ismask)
			return GiveAlert(_("msg ipmask input"), field);
		else
			return GiveAlert(_("msg ipaddr input"), field);
	}

	var address = field.value.match(/^[1-2]?\d{1,2}\.[1-2]?\d{1,2}\.[1-2]?\d{1,2}\.[1-2]?\d{1,2}$/);
	var digits, i;
	var bMask = 0;
	var watch = false;

	if (address == null) {
		return GiveAlert(errmsg, field);
	}
	digits = address[0].split(".");

	if (ismask) {
		for (i = 0; i < 4; i++) {
			if ((Number(digits[i]) > 255) || (Number(digits[i]) < 0)) {
				return GiveAlert(errmsg, field);
			}
			bMask = (bMask << 8) | Number(digits[i]);
		}
		bMask = bMask & 0x0FFFFFFFF;
		for (i = 0; i < 32; i++) {
			if ((bMask & 0x01) == 1)
				watch = true;
			else if (watch == true || i == 31)
				return GiveAlert(errmsg, field);
			bMask = bMask >> 1;
		}
	} else {
		for (i = 0; i < 4; i++) {
			if ((Number(digits[i]) > 255) || (Number(digits[i]) < 0) || (Number(digits[0]) > 223)) {
				return GiveAlert(errmsg, field);
			}
		}
	}

	return true;
}

function checkNet(field)
{
	if (field.value == "") {
		return GiveAlert(_("msg ipaddr input"), field);
	}

	var address = field.value.match(/^[1-2]?\d{1,2}\.[1-2]?\d{1,2}\.[1-2]?\d{1,2}\.[1-2]?\d{1,2}$/);
	var digits, i;

	if (address == null) {
		return GiveAlert(_("msg ipaddr invalid"), field);
	}
	digits = address[0].split(".");

	for (i = 0; i < 4; i++) {
		if ((Number(digits[i]) > 255) || (Number(digits[i]) < 0)) {
			return GiveAlert(_("msg ipaddr invalid"), field);
		}
	}

	return true;
}

function adjHex(_elmt, _vle)
{
	var elmt = _elmt;
	var vle = _vle;
	if (elmt != null && elmt.value != null) {
		if (!isNaN( parseInt(elmt.value, 16))) {
			if ((elmt.value.indexOf( "0" ) == 0 && elmt.value.length == 2 &&
				parseInt(elmt.value, 16) > 0 ) || elmt.value == "00" ) {
				elmt.value = "0"+parseInt(elmt.value, 16).toString(16).toUpperCase();
			} else {
				elmt.value = parseInt(elmt.value, 16).toString(16).toUpperCase();
			}
			if ((vle != 1) && (elmt.value.length == 2)) {
				elmt.form[getIdxOfForm( elmt )+1].focus();
				elmt.form[getIdxOfForm( elmt )+1].select();
			}
		} else {
			elmt.value = "";
		}
	}
}

function checkHex(str)
{
	var len = str.length;

	for (var i=0; i<str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
			(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ||
			(str.charAt(i) >= 'A' && str.charAt(i) <= 'F') ) {
				continue;
		} else
	        return false;
	}
    return true;
}

function dataDec2Bin( dec )  //Convert Dec to Bin
{
    var str = dec;
    bin = parseInt(str).toString(2);
    t = "";
    for( j=0; j<8; j++ ){
        if( j>=bin.length )t = t+"0";
    }
    bin = t+bin;
    return bin;
}

function dataBin2Dec( bin )  //Convert Bin to Dec
{
    var str = bin;
    var dec = 0;
    for(i=str.length-1,j=0; i>=0; i--,j++){
        t1 = str.charAt(i);
        if( t1!="0" && t1!="1" ){
            return -1;
        }
        t2 = Math.pow(2, j);
        t3 = parseInt(t1) * parseInt(t2);
        dec = parseInt(dec) + parseInt(t3);
    }
    return dec;
}

function isIPv6(str)  
{  
	if (str != "") {
		if (str.search(":") == -1) {
			return false;
		} else {
		    return str.match(/:/g).length<=7  
		    &&/::/.test(str)  
		    ?/^([\da-f]{1,4}(:|::)){1,6}[\da-f]{1,4}$/i.test(str)  
		    :/^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(str); 
		}
	} else {
		return true;
	} 
}  

function isEqualIPv6Lan( _ip1, _mask1, _ip2 )
{
	if (getSplitNum(_ip1,_mask1) == getSplitNum(_ip2,_mask1))
		return true;
	else 
		return false;
}  

function getSplitNum(ipv6, len)
{
	var aryip = Array(0);
	var tmp = ipv6.split("::");
		
	if (tmp.length == 1) {
		var tmp1 = ipv6.split(":");
		for (var i=0; i<tmp1.length; i++) {
			aryip.push(tmp1[i]);
		}
	} else {
		var tmp1 = tmp[0].split(":");
		var tmp2 = tmp[1].split(":");
		for (var i=0; i<8; i++) {
			if (i < tmp1.length) aryip.push(tmp1[i]);
			else if (i  < (8-tmp2.length)) aryip.push("0");
			else aryip.push(tmp2[i-(8-tmp2.length)]);			
		}
	}
	for (var i=0; i< aryip.length; i++)
		aryip[i] = parseInt("0x"+aryip[i]).toString(2);

	var str = "";	
	for (var i=0; i< aryip.length; i++) {
		var prefix = "";
		for (var j=0;j<(16-aryip[i].length);j++)
			prefix += "0";
		str += prefix + aryip[i];
	}
//	alert(str.substr(0,len));
	return str.substr(0,len);
}

function clearChildNodes(elem) {
    while (elem.childNodes.length > 0) {
        elem.removeChild(elem.firstChild);
    }
    return elem;
}

function addCell(tr, td, content)
{
    td.appendChild(content);    // Add content to cell
    tr.appendChild(td);         // Add cell to row
}

function CreateStyledElement(element, style, id)
{
    var elm = document.createElement(element);
    elm.id = elm.name = id;
    elm.setAttribute("class", style); // For FF
    elm.setAttribute("className", style); // For MSIE
    return elm;
}

function CreateTd(style)
{
    return CreateStyledElement("td", style);
}

function addTypedTextCell(tr, type, value, style, colspan)
{
    var cell = CreateStyledElement(type, style);
    if(colspan)
        cell.setAttribute("colSpan", colspan);
    addCell(tr, cell, document.createTextNode(value));
    return cell;
}

function addTextCell(tr, value, style, colspan)
{
    return addTypedTextCell(tr, "td", value, style, colspan);
}

function addTextHeaderCell(tr, value, style, colspan)
{
    return addTypedTextCell(tr, "th", value, style, colspan);
}

function addLabelTextCell(tr, value, style, id)
{
    var td = CreateTd(style);
    var label = document.createElement("label");
    label.setAttribute("for", id);
    addCell(td, label, document.createTextNode(value));
    tr.appendChild(td);
    return td;
}

function addCheckBoxCell(tr, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement("input");
    field.type = "checkbox";
    field.id = field.name = name;
    addCell(tr, td, field);
    if(value) {
        field.setAttribute("checked", true); // FF
        field.setAttribute("defaultChecked", true); // MSIE+W3C
    }
    return field;
}

function addSelectCell(tr, oT, oV, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addSelectCellCol(tr, oT, oV, value, style, name, colspan)
{
    var td = CreateTd(style);
    td.colSpan = colspan;
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addSelectCellHide(tr, oT, oV, value, style, name)
{
    var td = CreateTd(style);
    td.setAttribute('style', 'display:none');
    td.style.display ="none";
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addInputCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    addCell(tr, td, field);
    return field;
}

function addInputAreaCell(tr, value, style, name, col_size, row_size)
{
    var td = CreateTd(style);
    var field = document.createElement('textarea');
    field.id = field.name = name;
    field.setAttribute("rows", row_size);
    field.setAttribute("cols", col_size);
    field.value = value;
    field.defaultValue = value;
    addCell(tr, td, field);
    return field;
}

function addHiddenInputCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    field.type = 'hidden';
    addCell(tr, td, field);
    return field;
}

function addPasswordCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.type = 'password';
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    addCell(tr, td, field);
    return field;
}

function addImageCell(tr, style, src, text)
{
    var td = CreateTd(style);
    var field = document.createElement('img');
    field.src = src;
    field.border = 0;
    field.title = field.alt = text;
    addCell(tr, td, field);
    return field;
}

function addRadioCell(tr, value, style, name, id)
{
    var td = CreateTd(style);
//    var field=document.createElement(document.all?'<input name="'+name+'">':'input');
	var field=document.createElement('input');//for IE9 compatibility issue

    field.id = id;
    field.name = name;
    field.type = "radio";
    field.setAttribute("value",id);
    addCell(tr, td, field);
    if (value) {
        field.setAttribute("checked", "checked");
        field.setAttribute("defaultChecked", "checked"); // MSIE+W3C
    }
    return field;
}

function addLink(tr, style, url, text, target)
{
    // default vlaue
    var  target = (target == null) ? "" : target;


    var td = CreateStyledElement("td", style);
    var link = document.createElement("a");
    link.href = url;
    link.target = target;
    link.appendChild(document.createTextNode(text)); // Add Text
    td.appendChild(link);       // Add link to cell
    tr.appendChild(td);         // Add cell to row
}

function addHiddenParam(form, name, value)
{
    var field = document.createElement('input');
    field.type = 'hidden';
    field.id = field.name = name;
    field.value = value;
    form.appendChild(field);         // Add cell to row
    return field;
}

function addButtonCell(tr, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.type = "button";
    field.value = value;
    addCell(tr, td, field);
    return field;
}


function isInterger(object) //Judge is Interger
{
    vle = object.value;
    if(isNaN(vle)){
    	object.value = 0;
    }else{ 
    	if(vle.indexOf(".") != -1){
        	object.value=Math.floor(vle);
    	}
    }
}

function fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP)
{
	var fw_upgrade_notify	=_fw_upgrade_notify ;
	var aryInfo = _aryInfo ;
	var curt_ver = _curt_ver ;
	var lanIP = _lanIP;
	var flag;
	var msg = "A newer version of firmware is available.\n";
		msg += "Do you want to upgrade now?\n\n" ;
		msg += "Current version:" + curt_ver + "\n" ;
		msg += "Latest version:" + aryInfo[1];
		if(fw_upgrade_notify == 1 && aryInfo[0] == 1){
			if(confirm(msg)){
				flag = 1;
				$.post("/goform/setUpgradeNeed", { iUpgradeEn: "1" } );
				setTimeout("document.location='http://"+lanIP+"/adm/upload_firmware.asp?action=do';",1000);
			}else{
				flag = 0;
				$.post("/goform/setUpgradeNeed", { iUpgradeEn: "0"} );
			}	                                   
		}
}