/*
 * This is a reverse-engineered driver for mobile WiMAX (802.16e) devices
 * based on Samsung CMC-730 chip.
 * Copyright (C) 2008-2009 Alexander Gordeev <lasaine@lvk.cs.msu.su>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef _WIMAX_H
#define _WIMAX_H

#define WDS_NONE	0x000
#define WDS_CHIP	0x001
#define WDS_FIRMWARE	0x002
#define WDS_MAC		0x004
#define WDS_LINK_STATUS	0x008
#define WDS_RSSI	0x010
#define WDS_CINR	0x020
#define WDS_BSID	0x040
#define WDS_TXPWR	0x080
#define WDS_FREQ	0x100
#define WDS_STATE	0x200
#define WDS_PROTO_FLAGS	0x400
#define WDS_OTHER	0x800
#define WDS_SIGNATURE 0x1000
#define WDS_ANY		0xffff

#if CONFIG_USER_YOTA_4M_FW==1 || CONFIG_USER_YOTA_NEW_FW==1
#define COMSTAR_SAMSUNG_U200   1
#else
#define COMSTAR_SAMSUNG_U200   0
#endif

#define     SAMSUNG_LTE_SUPPORT     0
#define WIMAX_NUM_OF_TX_BULK_URB 30

#define MAX_NUM_OF_NETWORK 10
struct wimax_network
{
	unsigned int id;
	char name[30];
	int  ssi_dbm;
	int  ssi_level;
	int  frequency;
	int  cinr;
	int  preamble_index;
	int  bandwidth;
	unsigned char base_mac[6];
};

struct wimax_dev_status {
	unsigned int info_updated;
	unsigned char proto_flags;
	char chip[0x40];
	char firmware[0x40];
	unsigned char mac[6];
	int link_status;
	short rssi;
	float cinr;
	unsigned char bsid[6];
	unsigned short txpwr;
	unsigned int freq;
	int state;
    char usb_class;
    char usb_sub_class;
    int  num_of_interface;
	unsigned short dev_vid;
	unsigned short dev_pid;
	int modem_state;
};

#define	ISP_RUSSIA				1
#define	ISP_NICARAGUA			2
#define	ISP_LITHUANIA			3
#define	ISP_TAIWAN_G1			4
#define	ISP_TAIWAN_TATUNG		5
#define	ISP_SWEDEN_TELIA		6
#define	ISP_TAIWAN_VEE			7
#define	ISP_TAIWAN_VMAX			8
#define	ISP_SWEDEN_TELE2		9
#define	ISP_USA_CLEARWIRE		10
#define	ISP_USA_VERIZON			11
#define	ISP_MAX_VALUE			12

#define	RSA_RC4_128_MD5			0
#define	RSA_AES_256_SHA			1
#define	DHE_RSA_AES_256_SHA		2

/* set link_status */
void set_link_status(int link_status);

/* get/set state */
int get_state();
void set_state(int state);

/* write packet to the network interface */
int write_netif(const void *buf, int count);
void setup_id_user_pw(void);


#endif // _WIMAX_H

