#!/bin/sh

alert() {

	USERNAME=$(nvram_get 2860 ML_User)
	PASSWORD=$(nvram_get 2860 ML_PW)
	SERVER=$(nvram_get 2860 ML_SmtpServer)
	TO=$(nvram_get 2860 ML_To)
	FROM=$(nvram_get 2860 ML_From)
	
	SBJ="Mail Alert - User Login Messages From $Hostname"
	
	if [ "$WAY" == "" ]; then
		echo "$LOGINNAME login $Hostname on" `date` > /tmp/mail_body
	else
		echo "$LOGINNAME login $Hostname from $WAY on" `date` > /tmp/mail_body
	fi
		
	cat /tmp/mail_body | sendmail -w 30 -s "$SBJ" -H "$USERNAME:$PASSWORD@$SERVER" -f "$FROM" "$TO"
	
	rm /tmp/mail_body
}

LOGINNAME=$1
if [ "$LOGINNAME" == "" ]; then
	LOGINNAME="User"
fi

Hostname=$(nvram_get 2860 HostName)
if [ "$Hostname" == "" ]; then
  Hostname="VigorFly series"
fi

WAY=$2
EN=$(nvram_get 2860 ML_Enable)
FLAG=$(nvram_get 2860 ML_Flag)
if [ $EN == "1" ] && [ $FLAG == "1" ]; then
	alert;
else
	exit;
fi


