#!/bin/sh
#
#
# usage: multi_wan.sh [multi wanmode]
#

if [ "$1" = "" ]; then
	echo "usage : multi_wan.sh [multi wanmode]"
	exit 1
fi

if [ "$1" = "MGMT_WAN" ]; then
	VLAN_EN=`nvram_get 2860 VLAN_EN`
	MGMT_EN=$(nvram_get 2860 VLAN_MGMT | awk 'FS="[,]+" {print $1}')
	if [ "$VLAN_EN" != "1" -o "$MGMT_EN" != "1" ]; then
		echo "MGMT WAN not enable!!!!!"
		exit 1
	fi

	# stop all mgmt WAN setting
	if [ -f /var/run/mgmt_udhcpc.pid ]; then
		kill -9 `cat /var/run/mgmt_udhcpc.pid` > /dev/null 2>&1
	fi
	if [ -f /var/run/ppp7.pid ]; then
		kill -9 `cat /var/run/ppp7.pid` > /dev/null 2>&1
	fi

	#get MGMT WAN type
	mgmt_mode=`nvram_get 2860 MGMT_WAN_TYPE`

	#MGMT static/dhcp WAN default use eth2.7
	mgmt_wan_if=eth2.7	

	#clean routing information, don't need to clean ppp8 because interface is down
	ifconfig "eth2.7" 0.0.0.0 > /dev/null 2>&1

	#clean MGMT WAN table
	ip route flush table 24 > /dev/null 2>&1
	ip rule del table 24 > /dev/null 2>&1

	if [ "$mgmt_mode" = "STATIC" ]; then
		mgmt_ip=`nvram_get 2860 MGMT_WAN_IP`
		mgmt_nm=`nvram_get 2860 MGMT_WAN_MASK`
		mgmt_gw=`nvram_get 2860 MGMT_WAN_GW`
		mgmt_pd=`nvram_get 2860 MGMT_WAN_PDNS`
		mgmt_sd=`nvram_get 2860 MGMT_WAN_SDNS`
	
		#set MGMT WAN IP
		ifconfig $mgmt_wan_if $mgmt_ip netmask $mgmt_nm
		#set MGMT WAN policy route, i use table 24 as mgmt wan routing table
		ip route del default table 24
		ip route add default via "$mgmt_gw" dev "$mgmt_wan_if" table 24
		ip rule add from "$mgmt_ip"/"$mgmt_nm" table 24
		#set MGMT dns
		echo "nameserver $mgmt_pd" > /etc/mgmt_resolv.conf
		echo "nameserver $mgmt_sd" >> /etc/mgmt_resolv.conf
	
	elif [ "$mgmt_mode" = "DHCP" ]; then
		host=`nvram_get 2860 HostName`
		if [ "$host" != "" ]; then
			echo $host > /proc/sys/kernel/hostname
			#add dhcp option 121 (staticroutes), option 33
			udhcpc -i $mgmt_wan_if -s /sbin/udhcpc.sh -H $host -p /var/run/mgmt_udhcpc.pid &
		else
			echo draytek > /proc/sys/kernel/hostname
			#add dhcp option 121 (staticroutes), option 33
			udhcpc -i $mgmt_wan_if -s /sbin/udhcpc.sh -p /var/run/mgmt_udhcpc.pid &
		fi
	elif [ "$mgmt_mode" = "PPPOE" ]; then
		u=`nvram_get 2860 MGMT_WAN_PPPOEuser`
		pw=`nvram_get 2860 MGMT_WAN_PPPOEpass`
		pppoe_opmode=KeepAlive
		if [ "$pppoe_opmode" = "" ]; then
			echo "pppoecd $mgmt_wan_if -u $u -p $pw"
			pppoecd $mgmt_wan_if -u "$u" -p "$pw"
		else
			pppoe_optime=`nvram_get 2860 wan_pppoe_optime`
			config-pppoe.sh $u $pw $mgmt_wan_if $pppoe_opmode $pppoe_optime
		fi
	else
		echo "multi_wan.sh: unknown wan connection type: $wanmode"
		exit 1
	fi
	TR069_ACS_ITF=`nvram_get 2860 TR069ACSInterface`
	TR069_CPE_Enable=`nvram_get 2860 TR069CPEEnable`
	if [ "$TR069_ACS_ITF" = "1" -a "$TR069_CPE_Enable" = "1" ]; then
		killall -q tr069_client > /dev/null 2>&1
		tr069_client &
	fi
fi