#!/bin/sh
# This function only care about SMS send.

/sbin/global.sh

#SMS config format:
#send_sms.sh [idx]

#Get config file index
CFG_IDX=$1

if [ "$CFG_IDX" = "" -o "$CFG_IDX" = 0 ]
then
	echo "ERRROR: config index NULL !!!!"
	exit 1
fi

CFG=`nvram_get 2860 sms_cfg"$CFG_IDX"` 

# format [profile_name],[service_name],[username],[password],[number] 
if [ "$CFG" = "" ]
then
	echo "ERRROR: config NULL !!!!"
	exit 1
fi

CFG_SERV=$(echo "$CFG" | awk 'FS="[,]+" {print $2}')

retrieve_prog="/usr/bin/wget -O - ";

#request URL
case "$CFG_SERV" in
	"kotsms" )
		update_url="http://202.39.48.216/kotsmsapi-1.php?username=[USERNAME]&password=[PASSWORD]&dstaddr=[DEST]&smbody=[MSG]"
		;;
	"smscity" )
		update_url="http://api.smscity.com/gateway/sms.php?username=[USERNAME]&password=[PASSWORD]&destination=[DEST]&body=[MSG]&sender=smscity&reference=268431687"
		;;
	"bulksms" )
		update_url="http://bulksms.vsms.net:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"textmarketer" )
		update_url="http://www.textmarketer.biz/gateway/?username=[USERNAME]&password=[PASSWORD]&number=[DEST]&message=[MSG]&orig=Draytek&option="
		;;
	* )
		#default
		return 0
		;;
esac

CFG_USER=$(echo "$CFG" | awk 'FS="[,]+" {print $3}')
final_url=$(echo $update_url | sed s/"\[USERNAME\]"/"$CFG_USER"/g)

CFG_PASS=$(echo "$CFG" | awk 'FS="[,]+" {print $4}')
final_url=$(echo $final_url | sed s/"\[PASSWORD\]"/"$CFG_PASS"/g)

CFG_MSG=`nvram_get 2860 sms_msg"$CFG_IDX"`
#replace " " to "+"
CFG_MSG=$(echo $CFG_MSG | sed s/" "/"+"/g)
final_url=$(echo $final_url | sed s/"\[MSG\]"/"\"$CFG_MSG\""/g)

CFG_NUM=$(echo "$CFG" | awk 'FS="[,]+" {print $5}')
TMP_NUM=$(echo "$CFG_NUM" | awk 'FS="[;]+" {print $1}')
CNT=1
while [ "$TMP_NUM" != "" ]
do
	send_url=$(echo $final_url | sed s/"\[DEST\]"/"$TMP_NUM"/g)
	#send url
	#logger "$retrieve_prog $send_url "
	#echo "$retrieve_prog $send_url "
	update_output=$( $retrieve_prog "$send_url" )
	
	#get next $TMP_NUM 
	CNT=`expr $CNT + 1`
	TMP_NUM=$(echo "$CFG_NUM" | awk 'FS="[;]+" {print $'$CNT'}')
done

