#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

RESOLV_CONF="/etc/resolv.conf"
[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

case "$1" in
    deconfig)
        /sbin/ifconfig $interface 0.0.0.0
        ;;

    renew|bound)
        /sbin/ifconfig $interface $ip $BROADCAST $NETMASK

        if [ -n "$router" ] ; then
            echo "deleting routers"
            while route del default gw 0.0.0.0 dev $interface ; do
                :
            done

            metric=0
            for i in $router ; do
				WIJET_EXIST=`grep Vendor=1076 /proc/bus/usb/devices | grep ProdID=7f00`
				BM325_EXIST=`grep Vendor=12d1 /proc/bus/usb/devices | grep ProdID=3808`
				BECEEM_ASUS_EXIST=`grep Vendor=0b05 /proc/bus/usb/devices | grep ProdID=1780`
				BECEEM_JINGLE_EXIST=`grep Vendor=198f /proc/bus/usb/devices | grep ProdID=0220`
				if [ "$WIJET_EXIST" = "" -a "$BM325_EXIST" = "" -a  "$BECEEM_ASUS_EXIST" = ""  -a  "$BECEEM_JINGLE_EXIST" = "" ]; then
					metric=`expr $metric + 1`
					route add default gw $i dev $interface metric $metric

					# [G23802] for Wimax dongle using fixed ip
					if [ "$interface" = "wimax0" ]; then
						temp=`route -n | grep ^0.0.0.0 | grep $interface`
						if [ "$temp" = "" -a "$subnet" = "255.255.255.255" ]; then
							logger "Wimax dongle using fixed ip"
							route add default dev $interface
							route add default gw $i dev $interface metric $metric
							route del -net 0.0.0.0 netmask 0.0.0.0 dev $interface
						fi
					fi
				else
					# wimax0 ip : 111.235.210.87
					# route add -host 111.125.129.128 dev wimax0 metric 0
					# route add default gw 111.125.129.128
					# If we use command above directly, we'll get error message: Network is unreachable.
					echo "route add -host $i dev $interface metric $metric"
					route add -host $i dev $interface metric $metric
					echo "route add default gw $i"
					route add default gw $i
				fi
            done
        fi

        echo -n > $RESOLV_CONF
        [ -n "$domain" ] && echo search $domain >> $RESOLV_CONF
        for i in $dns ; do
            echo adding dns $i
            echo nameserver $i >> $RESOLV_CONF
        done
		
		#process dhcp option 121 (classless static route option)
		if [ -n "$staticroutes" ] ; then
		    DEST=""
			LOOP=0
			for i in $staticroutes ; do
			    if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
				    echo "adding route" $DEST "gw" $i
					route add -net $DEST gw $i dev $interface
					LOOP=0
				fi
			done
		fi
		
		#process dhcp option 33 (static route option)
		if [ -n "$routes" ] ; then
			DEST=""
			LOOP=0
			for i in $routes ; do
				if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
					echo "adding route" $DEST "gw" $i
					route add -host $DEST gw $i dev $interface
					LOOP=0
				fi
            done
		fi
		
		# notify goahead when the WAN IP has been acquired. --yy
		killall -SIGUSR2 goahead

		# restart igmpproxy daemon
		igmp=`nvram_get 2860 igmpEnabled`
		if [ "$igmp" = "1" ]; then
		config-igmpproxy.sh
		fi
		
		#clean icmp conntrack cache  by bruce hsu
		echo 0 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
		sleep 5
		echo 30 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
		
        ;;
esac

exit 0

