#!/bin/sh

CONF_DIR=/etc/l2tp
CONF_FILE=/etc/l2tp/l2tp.conf
L2TP_FILE=/etc/options.l2tp
ppp_inf="ppp2"

usage()
{
    echo "Usage :"
    echo "  vpn_l2tp.sh dial <user> <password> <serv_ip>"
    echo "  vpn_l2tp.sh drop"
    echo "  vpn_l2tp.sh show"
    echo "  vpn_l2tp.sh debug"
    echo "  vpn_l2tp.sh lan_droute <0/1>"
}

if [ "$1" = "dial" ]; then
  if [ ! -n "$4" ]; then
    echo "insufficient arguments!"
    echo "Usage: vpn_l2tp.sh dial <user> <password> <serv_ip>"
    exit 0
  fi

  #wanmode=`nvram_get 2860 wanConnectionMode`
  #if [ "$wanmode" = "L2TP" ]; then
  # echo "wan is l2tp !!!"
  # exit
  #fi
  
  # get server ip if using domain name, nancy
  l2tp_srv=$4
  temp=`echo $l2tp_srv | sed 's/[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}//g'`
  if [ "$temp" != "" ]; then
    # get the ip of the domain name
    l2tp_srv_temp=`ping -c 1 $l2tp_srv | grep PING | sed 's/^.*(//g' | sed 's/).*$//g'`
    if [ "$l2tp_srv_temp" != "" ]; then
      echo "L2TP server ($l2tp_srv) IP : $l2tp_srv_temp"
      #logger "L2TP server ($l2tp_srv) IP : $l2tp_srv_temp"
      l2tp_srv=$l2tp_srv_temp
    fi
  fi

  l2tp_user_name="$2"
  l2tp_password="$3"
  l2tp_serv_ip="$l2tp_srv"

  if [ ! -d $CONF_DIR ] ; then mkdir -p $CONF_DIR; fi

  echo "global
  load-handler \"sync-pppd.so\"
  load-handler \"cmd.so\"
  listen-port 1701
  section sync-pppd
  lac-pppd-opts \"file $L2TP_FILE\"
  section peer
  peer $l2tp_serv_ip
  port 1701
  lac-handler sync-pppd
  persist yes
  maxfail 32767
  holdoff 30
  hide-avps no
  section cmd" > $CONF_FILE


  echo "  noauth refuse-eap
  user \"$l2tp_user_name\"
  password \"$l2tp_password\"
  nomppe nomppc
  maxfail 0
  usepeerdns" > $L2TP_FILE
  echo "  persist" >> $L2TP_FILE
  echo "  ipcp-accept-remote ipcp-accept-local noipdefault
  ktune
  default-asyncmap nopcomp noaccomp
  novj nobsdcomp nodeflate
  lcp-echo-interval 10
  lcp-echo-failure 6
  unit 2 " >> $L2TP_FILE

  l2tpd
  sleep 1
  l2tp-control "start-session $l2tp_serv_ip"
  
elif [ "$1" = "drop" ]; then
  pid_path="/var/run/ppp2.pid"
  ppp2_pid=$(cat $pid_path)
  if [ "$ppp2_pid" != "" ]; then
    kill $ppp2_pid
  fi
  
  l2tpd_pid=$(ps | grep [l]2tpd | awk '{print $1}')
  if [ "$l2tpd_pid" != "" ]; then
    kill $l2tpd_pid
  fi
  
elif [ "$1" = "show" ]; then
  ppp_exist=$(ifconfig | grep $ppp_inf)
  if [ "$ppp_exist" != "" ]; then
    ifconfig $ppp_inf
  else
    echo "VPN l2tp isn't ready !!!"
  fi
elif [ "$1" = "debug" ]; then
  dbg_path="/tmp/l2tp.dbg"
  if [ -f $dbg_path ];then
    cat $dbg_path
  else
    echo "debug file isn't exist !!!"
  fi
elif [ "$1" = "lan_droute" ]; then
  ppp_exist=$(ifconfig | grep $ppp_inf)
  if [ "$ppp_exist" = "" ]; then
    echo "VPN l2tp isn't ready !!!"
    exit 0
  fi

  if [ "$2" = "1" ]; then
    local_ip=$(ifconfig $ppp_inf | grep "[i]net addr" | awk 'FS=":" {print $2}' | awk '{print $1}')
    ip route add table 1 default via $local_ip
    iptables -t mangle -A PREROUTING -i br0 -j MARK --set-mark 1
    ip rule add fwmark 1 table 1    
  elif [ "$2" = "0" ]; then
    ip route del table 1
    iptables -t mangle -D PREROUTING -i br0 -j MARK --set-mark 1
    ip rule del fwmark 1 table 1  
  fi
else
  usage
fi
