#!/bin/sh

# Copyright (C) 2009 Draytek
. /sbin/config.sh
. /sbin/global.sh

INIT_OPMODE=$opmode

#ping error count
PING_ERR=0
sleep 15
FB_CHK1=$(mii_mgr -g -p 17 -r 2 | grep "0243")
FB_CHK2=$(mii_mgr -g -p 17 -r 3 | grep "0c54")
if [ "$FB_CHK1" != "" -a  "$FB_CHK2" != "" ]; then
	MII_CMD="mii_mgr -g -p 17 -r 1"
else
	MII_CMD="mii_mgr -g -p 1 -r 1"
fi

#ARP / Ping detect function
#WanPing(WAN mode)	
WanPing()
{
	#wanDetectMode = 0  --> None
	#wanDetectMode = 1  --> ARP
	#wanDetectMode = 2  --> Ping
	PING_MODE=`nvram_get 2860 wanDetectMode`
	if [ "$PING_MODE" == 1 ]; then
		#ARP ping
		case $1 in
			"DHCP")
				W_GW=$(route -n | grep ^0.0.0.0 | awk '{print $2}')
				RLT=`arping -f -c 2 -w 2 -I $wan_if "$W_GW" | grep "reply from"`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "ARP Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "ARP Ping ok $PING_ERR"
				fi
				;;
			"STATIC")
				W_GW=`nvram_get 2860 wan_gateway`
				RLT=`arping -f -c 2 -w 2 -I $wan_if "$W_GW" | grep "reply from"`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "ARP Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "ARP Ping ok $PING_ERR"
				fi
				;;
			*)
				echo "WAN mode error $1"
				;;
		esac
	elif [ "$PING_MODE" == 2 ]; then 
		#Ping
		PING_IP=`nvram_get 2860 wanDetectPing`
		PING_TTL=`nvram_get 2860 wanDetectTTL`
		if [ "$PING_TTL" != "" ]; then
			SET_TTL="-t $PING_TTL"
		else
			SET_TTL=""
		fi
		case $1 in
			"DHCP" | "STATIC")
				RLT=`ping -c 2 -W 4 $SET_TTL $PING_IP -I $wan_if | grep from`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "Ping ok $PING_ERR"
				fi
				;;
			"PPPOE")
				RLT=`ping -c 2 -W 4 $SET_TTL $PING_IP -I ppp0 | grep from`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "Ping ok $PING_ERR"
				fi
				;;
			"Wimax")
				RLT=`ping -c 2 -W 4 $SET_TTL $PING_IP -I wimax0 | grep from`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "Ping ok $PING_ERR"
				fi
				;;
			"YotaKey")
				RLT=`ping -c 2 -W 4 $SET_TTL $PING_IP -I eth0 | grep from`
				if [ "$RLT" == "" ]; then
					PING_ERR=$(expr $PING_ERR + 1)
					#echo "Ping Fail $PING_ERR"
				else
					PING_ERR=0
					#echo "Ping ok $PING_ERR"
				fi
				;;
			*)
				echo "WAN mode error $1"
				;;
		esac
	elif [ "$PING_MODE" == 0 ]; then
		#echo "Disable Ping Detect"
		PING_ERR=0	
	#else
	#	echo "Ping Detect mode error"
	fi
}


#set wan web setting time=0
#	echo "0" > /var/network/wan_settime

#step1 sleep for awhile
    sleep 5

#step2 set wan_up and 3gwan_up =0
	echo "0" > /var/network/wan_up
	echo "0" > /var/network/3gwan_up

#step3 set wan_up_time and wan_util_up_time =0     #for wan up time detect
	echo "0" > /var/network/wan_up_time
	echo "0" > /var/network/wan_until_up_time

#step4 set 3gwan_up_time and 3gwan_util_up_time =0     #for 3gwan up time detect
	echo "0" > /var/network/3gwan_up_time
	echo "0" > /var/network/3gwan_until_up_time	

#step5 set wan up time 0
	echo "0 0" >> /var/3g/wan_record
	
DHCP_WAN_START=0
old_wan_up=0
echo "0" > /var/network/ppp_phy_link_connect

#for 3G connection
ERR_3G=0

#for WAN Status check
OLD_WAN_STATUS=0

#for MGMT WAN detect
echo "0" > /var/network/mgmt_wan_up
#set mgmt_wan_up_time and mgmt_wan_util_up_time =0     #for mgmt wan up time detect
echo "0" > /var/network/mgmt_wan_up_time
echo "0" > /var/network/mgmt_wan_until_up_time
	
#step4 loop check wan and 3gwan state
 while [ 1 ]
 do
	
	PROTO=$(nvram_get 2860 wanConnectionMode)
	ALWAYS_3G=$(nvram_get 2860 always3G)
	BK_3G=$(nvram_get 2860 3gwan_backup)
	# OperationMode == 3 --> Universal Repeater mode
	OP_MODE=$(nvram_get 2860 OperationMode)
	
	# G32124: modify $wan_if when operation mode was changed. --Sleer
	if [ "$INIT_OPMODE" != "" -a "$INIT_OPMODE" != "$OP_MODE" ]; then
		if [ "$OP_MODE" = "0" ]; then
			wan_if="br0"
		elif [ "$OP_MODE" = "1" ]; then
			if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
				wan_if="eth2.2"
			else
				wan_if="eth2.2"
			fi
		elif [ "$OP_MODE" = "2" ]; then
			wan_if="ra0"
		elif [ "$OP_MODE" = "3" ]; then
			wan_if="apcli0"
		fi
		INIT_OPMODE=$OP_MODE
	fi
	
	case $PROTO in
		"3G")
			#echo "3G wan mode"
			#check ppp0 interface
			W_INFO=$(ifconfig | grep "ppp0")
			if [ "$W_INFO" != "" ]; then
				#echo "ppp0 interface exist, 3G wan is up"
				echo "1" > /var/network/wan_up
				ERR_3G=0
			else
				#echo "ppp0 interface is not exist, 3G wan is down"
				echo "0" > /var/network/wan_up
				# if 3G wan is down, count 3G down time.
				ERR_3G=$(expr $ERR_3G + 1)
				if [ "$ERR_3G" -gt 30 ]; then
					logger "Try to restart 3G device again...."
					ERR_3G=0
					if [ "$1" != "force_3g" -a "$ALWAYS_3G" == 1 ]; then
						gpio u
					else
						echo "Do not reset 3G WAN!!!!"
					fi
				fi
			fi
			;;
		"DHCP")
			#echo "DHCP wan mode"
			#check phy link and eth2.2 wan ip address
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$($MII_CMD)
			TST=$($MII_CMD)
			TST=$($MII_CMD | awk '{print $4}')
			W_LINK=$(/bin/dray_util wan_det $TST)
			
			# Universal repeater mode don't have to check ethernet link
			if [ "$OP_MODE" == "3" ]; then
				W_LINK="1"
			fi
			
			if [ "$W_LINK" == 0 ]; then
				#echo "wan link down"
				echo "0" > /var/network/wan_up
				DHCP_WAN_START=0
				WADDR_INFO=$(ifconfig $wan_if | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#clean DHCP ip
					ifconfig $wan_if 0.0.0.0
				fi
				#echo "WAN link down!!!! "
			else
				# Add for G19795 : Remove WAN1 cable to another domain but DHCP client didn't reinitialize. -- Fanny
				PREV_LINK=$(cat /var/network/wan_up)
				UP_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
 
				# Check whether universal repeater mode is enabled
				if [ "$OP_MODE" != "3" ]; then
					if [ $UP_TIME -gt 35 -a "$PREV_LINK" = "0" -a "$DHCP_WAN_START" = "0" ]; then
						wan.sh
						DHCP_WAN_START=1
					fi
					#echo "WAN link up!!!! "
				fi
				WADDR_INFO=$(ifconfig $wan_if | grep "inet addr")

				if [ "$WADDR_INFO" != "" ]; then
					#echo "DHCP get ip, wan is up"
					WanPing $PROTO
					if [ "$PING_ERR" -ge 2 ]; then
						echo "0" > /var/network/wan_up
					else
						echo "1" > /var/network/wan_up
						NEW_WAN_STATUS=1
						if [ "$OLD_WAN_STATUS" != "$NEW_WAN_STATUS" ]; then
						    OLD_WAN_STATUS=$NEW_WAN_STATUS
						    /bin/dray_util chk_wan_status $OLD_WAN_STATUS
						fi
					fi
					#echo "YES WAN IP!!!! "
				else
					#echo "DHCP can't get ip, wan is down"
					echo "0" > /var/network/wan_up
					NEW_WAN_STATUS=2
					if [ "$OLD_WAN_STATUS" != "$NEW_WAN_STATUS" ]; then
					    OLD_WAN_STATUS=$NEW_WAN_STATUS 
					    /bin/dray_util chk_wan_status $OLD_WAN_STATUS
					fi
					#echo "NO WAN IP!!!! "
				fi
			fi
			;;
		"STATIC")
			#echo "Static wan mode"
			#check phy link and arp state
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$($MII_CMD)
			TST=$($MII_CMD)
			TST=$($MII_CMD | awk '{print $4}')
			W_LINK=$(/bin/dray_util wan_det $TST)
			# Universal repeater mode don't have to check ethernet link
			if [ "$OP_MODE" == "3" ]; then
				W_LINK="1"
			fi
			
			if [ "$W_LINK" == 0 ]; then
				#echo "wan link down"
				echo "0" > /var/network/wan_up
			else
				#echo "wan link up"
				WanPing $PROTO
				[ "$PING_ERR" -ge 2 ] && echo "0" > /var/network/wan_up || echo "1" > /var/network/wan_up
			fi
			;;
		"Wimax")
			W_INFO=$(ifconfig | grep "wimax0")
			if [ "$W_INFO" != "" ]; then
				W_INFO=$(ifconfig wimax0 | grep "inet addr")
				if [ "$W_INFO" != "" ]; then
					#echo "wan link up"
					temp=$(route -n | grep ^0.0.0.0 | grep "$wan_if")
					if [ "$temp" != "" ]; then
						route del default dev $wan_if
					fi
					WanPing $PROTO
					[ "$PING_ERR" -ge 2 ] && echo "0" > /var/network/wan_up || echo "1" > /var/network/wan_up
					
				else
					echo "0" > /var/network/wan_up
				fi
			else
				echo "0" > /var/network/wan_up
				# check whether we wake up Wimax driver
				temp=$(cat /var/network/wimaxUp)
				if [ "$temp" = "0" ]; then
					echo 1 > /var/network/wimaxUp
					wimax.sh up
				fi
			fi
			;;
		"YotaKey")
			W_INFO=$(ifconfig | grep "eth0")
			if [ "$W_INFO" != "" ]; then
				W_INFO=$(ifconfig eth0 | grep "inet addr")
				if [ "$W_INFO" != "" ]; then
					#echo "wan link up"
					WanPing $PROTO
					[ "$PING_ERR" -ge 2 ] && echo "0" > /var/network/wan_up || echo "1" > /var/network/wan_up					
				else
					echo "0" > /var/network/wan_up
				fi
			else
				echo "0" > /var/network/wan_up
			fi
			;;
		*)
			#echo "PPPoE / PPTP / L2TP wan mode"
			#check phy link and ppp0 interface
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$($MII_CMD)
			TST=$($MII_CMD)
			TST=$($MII_CMD | awk '{print $4}')
			W_LINK=`/bin/dray_util wan_det $TST`
			if [ "$W_LINK" == 0 ]; then
				#echo "wan link down"
				echo "0" > /var/network/ppp_phy_link_connect
				echo "0" > /var/network/wan_up
			else
				#echo "wan link up"
				echo "1" > /var/network/ppp_phy_link_connect
				W_INFO=$(ifconfig | grep "ppp0")
				if [ "$W_INFO" != "" ]; then
					#echo "ppp0 interface exist"
					W_IP=$(ifconfig ppp0 | grep "10.64.64.64")	
					if [ "$W_IP" != "" ]; then
						#echo "ppp0 don't get real ip, wan is down"
						echo "0" > /var/network/wan_up
				    else
						#echo "ppp0 get real ip, wan is up"
						if [ "$PROTO" == "PPPOE" ]; then
							WanPing $PROTO
							[ "$PING_ERR" -ge 2 ] && echo "0" > /var/network/wan_up || echo "1" > /var/network/wan_up
						else
							echo "1" > /var/network/wan_up
						fi
					fi
				else
					#echo "ppp0 interface is not exist, wan is down"
					echo "0" > /var/network/wan_up
				fi
			fi
		;;
	esac
	# add static route, nancy
	new_wan_up=`cat /var/network/wan_up`
	if [ "$new_wan_up" = "0" -o "$new_wan_up" = "1" ]; then
		if [ "$old_wan_up" = "0" -a "$new_wan_up" = "1" ]; then
			/sbin/static_route.sh $PROTO &
			/sbin/nat.sh dynamic &
			touch /var/do_up
		fi
		old_wan_up=$new_wan_up
	fi
	
	#check 3g backup state
	if [ "$BK_3G" == "1" ];then
		W_INFO=$(ifconfig | grep "ppp1")
		if [ "$W_INFO" != "" ]; then
			#echo "ppp1 interface exist, 3gwan is up"
			echo "1" > /var/network/3gwan_up
		else
			#echo "ppp1 interface is not exist, 3gwan is down"
			echo "0" > /var/network/3gwan_up
		fi
	else
		#echo "3gwan flag is not set."
		echo "0" > /var/network/3gwan_up
	fi
	
	#check mgmt wan state
	VLAN_EN=`nvram_get 2860 VLAN_EN`
	MGMT_EN=$(nvram_get 2860 VLAN_MGMT | awk 'FS="[,]+" {print $1}')
	if [ "$VLAN_EN" = "1" -a "$MGMT_EN" = "1" ]; then
		MGMT_PROTO=$(nvram_get 2860 MGMT_WAN_TYPE)
		#check MGMT WAN link state
		VTST=$($MII_CMD)
		VTST=$($MII_CMD)
		VTST=$($MII_CMD | awk '{print $4}')
		VW_LINK=$(/bin/dray_util wan_det $VTST)
		case $MGMT_PROTO in
			"STATIC")
				if [ "$VW_LINK" == 0 ]; then
					echo "0" > /var/network/mgmt_wan_up
				else
					echo "1" > /var/network/mgmt_wan_up
				fi
			;;
			"DHCP")
				if [ "$VW_LINK" == 0 ]; then
					echo "0" > /var/network/mgmt_wan_up
				else
					MGMT_INFO=$(ifconfig eth2.7 | grep "inet addr")
					if [ "$MGMT_INFO" != "" ]; then
						echo "1" > /var/network/mgmt_wan_up
					else
						echo "0" > /var/network/mgmt_wan_up
					fi
				fi
			;;
			"PPPOE")
				if [ "$VW_LINK" == 0 ]; then
					echo "0" > /var/network/mgmt_wan_up
				else
					MGMT_INFO=$(ifconfig | grep "ppp7")
					if [ "$MGMT_INFO" != "" ]; then
						#echo "ppp7 interface exist"
						echo "1" > /var/network/mgmt_wan_up
					else
						#echo "ppp7 interface is not exist, wan is down"
						echo "0" > /var/network/mgmt_wan_up
					fi
				fi
			;;
		esac
		#mgmt wan up time detect
		V_WAN_ST=$(cat /var/network/mgmt_wan_up)
		if [ $V_WAN_ST = "1" ]; then
			#mgmt wan is up, update wan up time
			V_NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
			V_OLD_TIME=$(cat /var/network/mgmt_wan_until_up_time)
			V_WAN_UP_TIME=$(expr $V_NEW_TIME - $V_OLD_TIME)
			echo "$V_WAN_UP_TIME" > /var/network/mgmt_wan_up_time
		else
			#wan is down, update wan until up time
			V_NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
			echo "$V_NEW_TIME" > /var/network/mgmt_wan_until_up_time
			echo "0" > /var/network/mgmt_wan_up_time
		fi
	fi
	
	#wan up time detect
	WAN_ST=$(cat /var/network/wan_up)
	if [ $WAN_ST = "1" ]; then
		#wan is up, update wan up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		OLD_TIME=$(cat /var/network/wan_until_up_time)
		WAN_UP_TIME=$(expr $NEW_TIME - $OLD_TIME)
		echo "$WAN_UP_TIME" > /var/network/wan_up_time
	else
		#wan is down, update wan until up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		echo "$NEW_TIME" > /var/network/wan_until_up_time
		echo "0" > /var/network/wan_up_time
	fi
	#echo "$(cat /var/network/wan_up_time)"
	
	#wan backup time detect
	BK_WAN_ST=$(cat /var/network/3gwan_up)
	if [ $BK_WAN_ST = "1" ]; then
		#wan is up, update wan up time
		BK_NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		BK_OLD_TIME=$(cat /var/network/3gwan_until_up_time)
		BK_WAN_UP_TIME=$(expr $BK_NEW_TIME - $BK_OLD_TIME)
		echo "$BK_WAN_UP_TIME" > /var/network/3gwan_up_time
	else
		#wan backup is down, update wan backup until up time
		BK_NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		echo "$BK_NEW_TIME" > /var/network/3gwan_until_up_time
		echo "0" > /var/network/3gwan_up_time
	fi

	# up.sh
	if [ -f /var/do_up ]; then
		/sbin/up.sh &
	fi
	
	#sleep 2 sec and wait
	sleep 2
 done
