#!/bin/sh
#

WAN_TYPE=`nvram_get 2860 wanConnectionMode`
if [ "$1" = "up" ]; then
	wimaxEnable=`cat /var/network/wimaxUp`
	status2=`test -f /var/network/wimaxStatus2 && cat /var/network/wimaxStatus2`
	if [ "$wimaxEnable" = "1" -a "$status2" = "1" ]; then
		interfaceExist=`ifconfig -a | grep wimax0`
		if [ "$interfaceExist" != "" ]; then
			ifconfig wimax0 up
			temp=`ps | grep "udhcpc" | grep "wimax0"`
			if [ "$temp" != "" ]; then
				exit 0
			fi
			sleep 1
			temp=`ps | grep "udhcpc" | grep "wimax0"`
			if [ "$temp" != "" ]; then
				exit 0
			fi
			while route del default ; do
       	         :
       	     	done
			if [ "$WAN_TYPE" = "Wimax" ]; then
				#wimax wan
				udhcpc -i wimax0 -s /sbin/udhcpc.sh -O staticroutes -p /var/run/udhcpc.pid &
			else
				#wimax backup wan
				udhcpc -i wimax0 -s /sbin/udhcpcbk.sh -O staticroutes -p /var/run/udhcpcbk.pid &
			fi
			logger "Wimax interface up"
		fi
	fi
elif [ "$1" = "down" ]; then
	interfaceExist=`ifconfig | grep wimax0`
	if [ "$interfaceExist" != "" ]; then
		temp=`ps | grep "udhcpc" | grep "wimax0" | awk '{print $1}'`
		if [ "$temp" != "" ]; then
			kill -SIGTERM $temp
		fi
		ifconfig wimax0 down
		logger "Wimax interface down"
	fi
elif [ "$1" = "reload" ]; then
	provider="$2"

	if [ "$provider" = "1" -o "$provider" = "2" -o "$provider" = "3" ]; then
		/bin/usb_app wimax
	elif [ "$provider" = "4" -o "$provider" = "5" -o "$provider" = "7" -o "$provider" = "8" ]; then
		/bin/usb_app wimax
	elif [ "$provider" = "6" ]; then
		/bin/gpio u
	fi
fi

