function QoS_Graph(title,width, height) {
	this.title = title;
	this.width = width || 400;
	this.height = height || 200;
	this.rows = null;
	this.build = _buildGraph;
	this.disable = false;
	return this;
}

function _rescaleGraph(g) {
	g.posMax = 0;
	if(g.disable) {
		g.posMax = 10;
		g.step = 5;
		g.vscale = g.width/g.posMax;
		g.hscale = Math.floor(g.height/30);
		return;
	}
	for(var i = 0; i < g.rows.length; i++) {
		if(parseInt(g.rows[i]) > parseInt(g.posMax))
			g.posMax = g.rows[i];
	}
	g.posMax = Math.ceil(g.posMax/10)*10;
	if(g.posMax == 0)
	{
		g.posMax = 10;
		g.step=5;
		g.disable = true;
	} else {
		g.step = Math.ceil(g.posMax/20)*5;
		if(g.step == 0) g.step = 5;
	}
	g.vscale = g.width/g.posMax;
	g.hscale = Math.floor(g.height/30);
}


function _buildRegGraph(g, doc) {
	var str = "";
	str += "<td WIDTH=50%><table bgcolor=#FFFFFF ALIGN=CENTER BORDER=0 CELLPADDING=0 CELLSPACING=0>\n";
	if(g.title) {
		str += "<tr>";
		str += "<td colspan=4><font face='Arial,Helvetica' size=-1>&nbsp;<b>"+g.title+"</b></font></td></tr>\n";
	}
	str += "<tr><td colspan=2></td>";
	str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*4)+"></td><td></td></tr>\n";
	if(!g.disable) {
		for(var i = 0; i < g.rows.length; i++) {
			str += "<tr>\n";
			str += "<td VALIGN=BOTTOM><font face='Arial,Helvetica' size=-1>&nbsp;"+g.Label[i]+"&nbsp;</font></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/clear.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*4)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*4)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/qos_"+i+".gif";
			str += " WIDTH="+parseInt(g.vscale*g.rows[i]);
			str += " HEIGHT="+parseInt(g.hscale*4)+">";
			str += "</td></tr><tr>\n";
			str += "<td VALIGN=BOTTOM></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/clear.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale)+"></td>";
			str += "<td></td></tr>";
		}
	} else {
		for(var i = 0; i < 5; i++) {
			str += "<tr>\n";
			str += "<td VALIGN=BOTTOM><font face='Arial,Helvetica' size=-1>"+g.Label[i]+"</font></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/clear.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*4)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*4)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/qos_"+i+".gif";
			str += " WIDTH=2";
			str += " HEIGHT="+parseInt(g.hscale*4)+">";
			str += "</td></tr><tr>\n";
			str += "<td VALIGN=BOTTOM></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/clear.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale)+"></td>";
			str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale)+"></td>";
			str += "<td></td></tr>";
		}
	}
	str += "<tr><td colspan=2></td>";
	str += "<td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH=2 HEIGHT="+Math.floor(g.hscale*2)+"></td><td></td></tr>\n";
	str += "<tr>";
	str += "<td BACKGROUND=/graphics/black.gif colspan=3 HEIGHT=2></td><td><IMG BORDER=0 SRC=/graphics/black.gif WIDTH="+parseInt(g.width+40)+" HEIGHT=2></td>";
	str += "</tr>";
	str += "<tr>";
	str += "<td colspan=3></td><td><table BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%><tr>";
	for(var i = 0; i < g.posMax; i = i+g.step) {
		str += "<td WIDTH="+parseInt(g.vscale*g.step)+" ALIGN=LEFT VALIGN=BOTTOM><font face='Arial,Helvetica' size=-2>"+i+"</font></td>";
	}
	str += "<td ALIGN=LEFT><font face='Arial,Helvetica' size=-2>"+g.posMax+" (Bps)</font></td>";
	str += "</tr></table></td>";
	str += "</tr>";
	str += "</table></td>";
	doc.write(str);
}

function _buildGraph(d) {
	doc = d || document;
	if(!this.rows || this.rows.length == 0)
		this.disable = true;
	_rescaleGraph(this);
	_buildRegGraph(this, doc);
	return;
}
