<!-- Copyright (c), Ralink Technology Corporation All Rights Reserved. -->
<html>
<head>
<title>QoS/Bandwidth Management Settings</title><% chkLoginUser(); %>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META http-equiv="Content-Type" content="text/html; charset=utf-8">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script language="JavaScript" type="text/javascript">
Butterlate.setTextDomain("internet");

var direction;
var aryQuality = ["", _("qos great"), _("qos good"), _("qos ok"), _("qos marginal"), _("qos poor")];
var aryGroupName = ["", "P2P", "VoIP", "Streaming video", "Streaming audio", "Chat", "Game", "Document retrieval",
				"Networking", "Mail", "File", "Printer", "Remote access", "Time synchronization", "Version control",
				"Monitoring", "Secure", "Obsolete", "IETF proposal standard", "IETF draft standard", "IETF standard",
				"Non-standards track RFC'd", "Other standard", "Open source", "Proprietary", "Malware"];
var arySpeed = ["", _("qos very fast"), _("qos fast"), _("qos not fast"), _("qos slow")];

var layer7_all = "<% getLayer7FiltersASP(); %>";
var layer7_data = "<% getLayer7FiltersData(); %>";
var layer7_filter_entries = new Array();
var layer7_filter_item = new Array();
var layer7_filename = new Array();
var layer7_name = new Array();
var layer7_intro = new Array();
var layer7_speed = new Array();
var layer7_quality = new Array();
var layer7_group = new Array();

layer7_filter_entries = layer7_all.split(";");
layer7_filter_data = layer7_data.split(";");
for(i=0; i<layer7_filter_entries.length; i++){
	layer7_filter_item = layer7_filter_entries[i].split("#");
	layer7_filter_data_item = layer7_filter_data[i].split(",");
	layer7_filename[i] = layer7_filter_item[0];
	layer7_name[i] = layer7_filter_item[1];
	layer7_intro[i] = layer7_filter_item[2];
	layer7_speed[i] = layer7_filter_data_item[1];
	layer7_quality[i] = layer7_filter_data_item[2];
	layer7_group[i] = layer7_filter_data_item[3];
}

/*
	Upload AF Group init
*/
var AF1ULName = "<% getCfgGeneral(1, "QoSAF1ULName", 1); %>";
var AF2ULName = "<% getCfgGeneral(1, "QoSAF2ULName", 1); %>";
var AF3ULName = "<% getCfgGeneral(1, "QoSAF3ULName", 1); %>";
var AF4ULName = "<% getCfgGeneral(1, "QoSAF4ULName", 1); %>";
var AF5ULName = "<% getCfgGeneral(1, "QoSAF5ULName", 1); %>";
var AF6ULName = "<% getCfgGeneral(1, "QoSAF6ULName", 1); %>";
AF1ULName = (AF1ULName == "") ? _("qos Low") : AF1ULName;
AF2ULName = (AF2ULName == "") ? _("qos High") : AF2ULName;
AF3ULName = (AF3ULName == "") ? "NoName3(UL)" : AF3ULName;
AF4ULName = (AF4ULName == "") ? "NoName4(UL)" : AF4ULName;
AF5ULName = (AF5ULName == "") ? _("qos Highest") : AF5ULName;
AF6ULName = (AF6ULName == "") ? _("qos Default") : AF6ULName;

/*
	Download AF Group init
*/
var AF1DLName = "<% getCfgGeneral(1, "QoSAF1DLName", 1); %>";
var AF2DLName = "<% getCfgGeneral(1, "QoSAF2DLName", 1); %>";
var AF3DLName = "<% getCfgGeneral(1, "QoSAF3DLName", 1); %>";
var AF4DLName = "<% getCfgGeneral(1, "QoSAF4DLName", 1); %>";
var AF5DLName = "<% getCfgGeneral(1, "QoSAF5DLName", 1); %>";
var AF6DLName = "<% getCfgGeneral(1, "QoSAF6DLName", 1); %>";
AF1DLName = (AF1DLName == "") ? _("qos Low") : AF1DLName;
AF2DLName = (AF2DLName == "") ? _("qos High") : AF2DLName;
AF3DLName = (AF3DLName == "") ? "NoName3(DL)" : AF3DLName;
AF4DLName = (AF4DLName == "") ? "NoName4(DL)" : AF4DLName;
AF5DLName = (AF5DLName == "") ? _("qos Highest") : AF5DLName;
AF6DLName = (AF6DLName == "") ? _("qos Default") : AF6DLName;

function style_display_on()
{
	if (window.ActiveXObject) { // IE
		return "block";
	}else if (window.XMLHttpRequest) { // Mozilla, Safari,...
		return "table-row";
	}
}

function hiddenAll()
{
	document.getElementById("portRangeTR1").style.visibility = "hidden";
	document.getElementById("portRangeTR1").style.display = "none";
	document.getElementById("portRangeTR2").style.visibility = "hidden";
	document.getElementById("portRangeTR2").style.display = "none";
	document.getElementById("appTR").style.visibility = "hidden";
	document.getElementById("appTR").style.display = "none";
}

function layer7Change()
{
	var idx = document.classifier.layer7.options.selectedIndex;
	document.getElementById("Layer7Intro").innerHTML = "<font color=blue>" + layer7_intro[idx] + "</font>";
	var img = "";
	var tmp = layer7_group[idx].split(" ");
	for (i=0; i<tmp.length; i++) {
		img += "<img alt=\"" + aryGroupName[tmp[i]] + "\" title=\"" + aryGroupName[tmp[i]] + "\" src=\"../layer7/" + tmp[i] + ".png\" border=0></img>&nbsp;";
	}
	document.getElementById("Layer7IntroGp").innerHTML = "<font color=red>" + _("qos group") + "</font> : " + img;
	document.getElementById("Layer7IntroSpd").innerHTML = "<font color=red>" + _("qos speed") + "</font> : " + arySpeed[layer7_speed[idx]];
	document.getElementById("Layer7IntroQ").innerHTML = "<font color=red>" + _("qos monitor accuracy") + "</font> : " + aryQuality[layer7_quality[idx]];
}

function protocolChange()
{
	hiddenAll();
	document.classifier.dFromPort.disabled = true;
	document.classifier.dToPort.disabled = true;
	document.classifier.sFromPort.disabled = true;
	document.classifier.sToPort.disabled = true;

	document.classifier.dFromPort.value = 
		document.classifier.dToPort.value = 
		document.classifier.sFromPort.value = 
		document.classifier.sToPort.value = "";

	if( document.classifier.protocol.options.selectedIndex == 0){
		window.resizeTo(600,500);
		return;
	}else if( document.classifier.protocol.options.selectedIndex == 1 ||
		document.classifier.protocol.options.selectedIndex == 2){
		window.resizeTo(600,500);
		document.classifier.dFromPort.disabled = false;
		document.classifier.dToPort.disabled = false;
		document.classifier.sFromPort.disabled = false;
		document.classifier.sToPort.disabled = false;

		document.getElementById("portRangeTR1").style.visibility = "visible";
		document.getElementById("portRangeTR1").style.display = style_display_on();
		document.getElementById("portRangeTR2").style.visibility = "visible";
		document.getElementById("portRangeTR2").style.display = style_display_on();
	}else if(document.classifier.protocol.options.selectedIndex == 3){
		window.resizeTo(600,500);
		return;
	}else if(document.classifier.protocol.options.selectedIndex == 4){
		window.resizeTo(600,700);
		document.getElementById("appTR").style.visibility = "visible";
		document.getElementById("appTR").style.display = style_display_on();
	}
}

function initTranslation()
{
	var e;


	e = document.getElementById("QoSClassifierPklNote");
	e.innerHTML = _("qos class pkl note");
	e = document.getElementById("QoSClassifierTitleStr");
	e.innerHTML = _("qos classifier title");
	e = document.getElementById("QoSClassifierNameStr");
	e.innerHTML = _("qos classifier name");
	e = document.getElementById("QoSClassifierDirStr");
	e.innerHTML = _("qos classifier dir");
	e = document.getElementById("QoSClassifierGroupStr");
	e.innerHTML = _("qos classifier group");
	e = document.getElementById("QoSClassifierMacStr");
	e.innerHTML = _("qos classifier mac");
/*	e = document.getElementById("QoSClassifierInIf");
	e.innerHTML = _("qos classifier ingress if");  */
	e = document.getElementById("QoSClassifierDIPStr");
	e.innerHTML = _("qos classifier dip");
	e = document.getElementById("QoSClassifierSIPStr");
	e.innerHTML = _("qos classifier sip");
	e = document.getElementById("QoSClassifierPktLenStr");
	e.innerHTML = _("qos classifier pktlen");

	e = document.getElementById("QoSClassifierDSCPStr");
	e.innerHTML = _("qos classifier dscp");
	e = document.getElementById("QoSClassifierProtoStr");
	e.innerHTML = _("qos classifier proto");
	e = document.getElementById("QoSClassifierDPortStr");
	e.innerHTML = _("qos classifier dport");
	e = document.getElementById("QoSClassifierSPortStr");
	e.innerHTML = _("qos classifier sport");
	e = document.getElementById("QoSClassifierL7Str");
	e.innerHTML = _("qos classifier l7");
	e = document.getElementById("QoSClassifierRemarkStr");
	e.innerHTML = _("qos classifier remark");
	e = document.getElementById("QoSClassifierAutoStr");
	e.innerHTML = _("qos classifier auto");
	e = document.getElementById("sQosNote");
	e.innerHTML = _("note head");
	e = document.getElementById("sQosNote1");
	e.innerHTML = _("qos classifier note");
	e = document.getElementById("QoSClassifierDirD");
	e.innerHTML = _("qos download");
	e = document.getElementById("QoSClassifierDirU");
	e.innerHTML = _("qos upload");
	e = document.getElementById("QoSClassifierDirBoth");
	e.innerHTML = _("qos both");

	e = document.getElementById("QoSClassifierNewStr")
	e.value = _("inet apply");
}
	
function initValue()
{
	initTranslation();

	//direction = (opener.document.forms[1].AddruleDir.value == 'DL') ? "Download" : "Upload";
	if(opener.dir == 'd')
		document.classifier.dir.options.selectedIndex = 1;
	else if (opener.dir == 'u')
		document.classifier.dir.options.selectedIndex = 0;
	else
		document.classifier.dir.options.selectedIndex = 2;


	hiddenAll();
}

function checkPortNum(num)
{
	if( num > 65535 || num < 0)
		return false;
	return true;
}

function checkInjection(str)
{
	var len = str.length;
	for (var i=0; i<str.length; i++) {
		if ( str.charAt(i) == '\r' || str.charAt(i) == '\n' || str.charAt(i) == ';' || str.charAt(i) == ','){
			return false;
		}else
			continue;
	}
	return true;
}

function atoi(str, num)
{
	i=1;
	if(num != 1 ){
		while (i != num && str.length != 0){
			if(str.charAt(0) == '.'){
				i++;
			}
			str = str.substring(1);
		}
	  	if(i != num )
			return -1;
	}
	
	for(i=0; i<str.length; i++){
		if(str.charAt(i) == '.'){
			str = str.substring(0, i);
			break;
		}
	}
	if(str.length == 0)
		return -1;
	return parseInt(str, 10);
}


function checkMac(str){
	var len = str.length;
	if(len!=17)
		return false;

	for (var i=0; i<str.length; i++) {
		if((i%3) == 2){
			if(str.charAt(i) == ':')
				continue;
		}else{
			if (    (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
					(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ||
					(str.charAt(i) >= 'A' && str.charAt(i) <= 'F') )
				continue;
		}
		return false;
	}
	return true;
}

function checkRange(str, num, min, max)
{
    d = atoi(str,num);
    if(d > max || d < min)
        return false;
    return true;
}

function isAllNumAndSlash(str)
{
	for (var i=0; i<str.length; i++){
		if( (str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.') || (str.charAt(i) == '/'))
			continue;
		return 0;
	}
	return 1;
}

function checkIpAddr(str)
{
	if(str == "")
		return false;

	if (isAllNumAndSlash(str) == 0)
		return false;

	var ip_pair = new Array();
	ip_pair = str.split("/");

	if(ip_pair.length > 2){
		return false;
	}

	if(ip_pair.length == 2){
		// sub mask
		if(!ip_pair[1].length)
			return false;
		if(!isNumOnly(ip_pair[1])){
			return false;
		}
		tmp = parseInt(ip_pair[1], 10);
		if(tmp < 0 || tmp > 32){
			return false;
		}
	}

    if( (!checkRange(ip_pair[0],1,0,255)) ||
		(!checkRange(ip_pair[0],2,0,255)) ||
		(!checkRange(ip_pair[0],3,0,255)) ||
		(!checkRange(ip_pair[0],4,0,254)) ){
		return false;
    }
	return true;
}


function checkForm()
{
	if(document.classifier.comment.value == ""){
		alert(_("qos name empty"));
		return false;
	}

	if(!checkInjection(document.classifier.comment.value)){
		alert(_("qos name invalid"));
		return false;
	}

	if(document.classifier.mac_address.value != ""){
		if(!checkMac(document.classifier.mac_address.value)){
			alert(_("qos mac invalid"));
			return false;
		}
	}

	if(document.classifier.dip_address.value != ""){
		if(! checkIpAddr(document.classifier.dip_address.value) ){
			alert(_("qos dest ip invalid"));
			return false;
		}
	}

	if(document.classifier.sip_address.value != ""){
		if(! checkIpAddr(document.classifier.sip_address.value) ){
			alert(_("qos src ip invalid"));
			return false;
		}
	}

	// packet length
	if(	(document.classifier.pktlenfrom.value != "" && document.classifier.pktlento.value == "" ) || 
		(document.classifier.pktlento.value != "" && document.classifier.pktlenfrom.value == "" ) ){
		alert(_("qos packet length error"));
		return false;
	}
	if( document.classifier.pktlenfrom.value != "" ){
		pktlenfrom = parseInt(document.classifier.pktlenfrom.value);
		pktlento = parseInt(document.classifier.pktlento.value);
		if(pktlenfrom > 2048 ||  pktlento > 2048){
			alert(_("qos packet length big"));
			return false;
		}
		if(pktlenfrom < 0 ||  pktlento < 0){
			alert(_("qos packet length small"));
			return false;
		}
		if(pktlento < pktlenfrom){
			alert(_("qos packet length invalid"));
			return false;
		}
	}



	if(	document.classifier.mac_address.value == "" && 
		document.classifier.dip_address.value == "" && 
		document.classifier.sip_address.value == "" &&
		document.classifier.pktlenfrom.value == "" && 
		document.classifier.dscp.value == "" && 
		document.classifier.protocol.value == "" &&
		document.classifier.layer7.value == ""){
		alert(_("qos classification empty"));
		return false;
	}

	if(document.classifier.procotol.value == "TCP" || document.classifier.procotol.value == "UDP"){
		if(document.classifier.dFromPort.value == "" && document.classifier.sFromPort.value == ""){
			alert(_("qos port number empty"));
			return false;
		}

		var dFromPort = parseInt(document.classifier.dFromPort.value);
		var dToPort = parseInt(document.classifier.dToPort.value);
		var sFromPort = parseInt(document.classifier.sFromPort.value);
		var sToPort = parseInt(document.classifier.sToPort.value);
		if(document.classifier.dFromPort.value != "" && !checkPortNum(dFromPort) ){
			alert(_("qos dest port rang invalid"));
			return false;
		}
		if(document.classifier.dToPort.value != "" && !checkPortNum(dToPort) ){
			alert(_("qos dest port rang invalid"));
			return false;
		}
		if(document.classifier.sFromPort.value != "" && !checkPortNum(sFromPort) ){
			alert(_("qos src port rang invalid"));
			return false;
		}
		if(document.classifier.sToPort.value != "" && !checkPortNum(sToPort) ){
			alert(_("qos src port rang invalid"));
			return false;
		}

		if(dToPort && (dToPort <= dFromPort)){
			alert(_("qos dest port rang invalid"));
			return false;
		}
		if(sToPort && (sToPort <= sFromPort)){
			alert(_("qos src port rang invalid"));
			return false;
		}
	}

//	if(opener.dir == 'd')
//		document.classifier.dir.value = "Download";
//	else
//		document.classifier.dir.value = "Upload";

	document.classifier.modify.disabled = true;
	document.classifier.submit();
}


</script>
</head>

<body onLoad="initValue()">
<table width="500">
<tr><td>

<h2 id=QoSClassifierTitleStr>Classifier Settings</h2>
<form method=post name="classifier" action="/goform/qosClassifier">

<table align=center width="100%" cellpadding="2" cellspacing="1" class="config">
	<tr><td width=30% id="QoSClassifierDirStr">Dir</td>
		<td><!--<input type="text" name="dir" id="dir" size="16" maxlength="32" readonly>-->
			<select name="dir"><option value="1" id="QoSClassifierDirU">Upload</option>
								<option value="2" id="QoSClassifierDirD">Download</option>
								<option value="3" id="QoSClassifierDirBoth">Download+Upload</option></select>
		</td>
		<td></td>
	</tr>
	<tr><td id="QoSClassifierNameStr">Name</td>
		<td><input type="text" name="comment" id="comment" size="16" maxlength="32"></td>
		<td></td>
	</tr>
	<tr><td id="QoSClassifierGroupStr">Group</td>
		<td><select name="af_index" id="af_index"  style="width:110px">
		<option value="5"> <script> document.write(direction == "Download" ? AF5DLName : AF5ULName) </script> </option>
		<option value="2"> <script> document.write(direction == "Download" ? AF2DLName : AF2ULName) </script> </option>
		<option value="6"> <script> document.write(direction == "Download" ? AF6DLName : AF6ULName) </script> </option>
		<option value="1"> <script> document.write(direction == "Download" ? AF1DLName : AF1ULName) </script> </option>
		</select>&nbsp;&nbsp;
	</td>
		<td></td>
	</tr>
	<tr style="display:none">
		<td id="QoSClassifierMacStr">Mac address</td>
		<td><input type="text" size="18" name="mac_address" id="mac_address"></td>
		<td></td>
	</tr>
    <!-- 
    <tr>
		<td colspan="2" id="QoSClassifierInIf">
		    Ingress interface
	    </td>
	    <td colspan="2">
		    <select name="ingress_if" id="ingress_if">
		    <option value="None">None</option>
		    <option value="TCP"></option>
		    <option value="UDP">UDP</option>
		    <option value="ICMP">ICMP</option>
		    <option value="Application">Application</option>
		    </select>&nbsp;&nbsp;
    
	    </td>
    </tr>
    -->
	<tr><td id="QoSClassifierDIPStr">Dest IP Address</td>
		<td><input type="text" size="16" name="dip_address" id="dip_address">
		<!-- we dont support ip range in kernel 2.4.30 
		-<input type="text" size="16" name="dip_address2">
		-->
	</td>
		<td></td>
	</tr>
	<tr><td id="QoSClassifierSIPStr">Source IP Address</td>
		<td>
  		<input type="text" size="16" name="sip_address" id="sip_address">
		<!-- we dont support ip range in kernel 2.4.30 
		-<input type="text" size="16" name="sip_address2">
		-->
	</td>
		<td></td>
	</tr>
	<tr><td id="QoSClassifierPktLenStr">Packet Length</td>
		<td><input type="text" size="4" name="pktlenfrom" id="pktlenfrom"> -
			<input type="text" size="4" name="pktlento" id="pktlento">
	</td>
		<td nowrap id="QoSClassifierPklNote">(ex: 0-128 for small packets)</td>
	</tr>
	<tr><td id="QoSClassifierDSCPStr">DSCP</td>
		<td><select name="dscp" id="dscp" style="width:110px">
		    <option value=""></option>
		    <option value="BE">BE (Default)</option>
		    <option value="AF11">AF11</option>
		    <option value="AF12">AF12</option>
		    <option value="AF13">AF13</option>
		    <option value="AF21">AF21</option>
		    <option value="AF22">AF22</option>
		    <option value="AF23">AF23</option>
		    <option value="AF31">AF31</option>
		    <option value="AF32">AF32</option>
		    <option value="AF33">AF33</option>
		    <option value="AF41">AF41</option>
		    <option value="AF42">AF42</option>
		    <option value="AF43">AF43</option>
		    <option value="EF">EF</option>
		    </select>&nbsp;&nbsp;
	    </td>
		<td></td>
    </tr>
	<tr><td id="QoSClassifierProtoStr">Protocol</td>
		<td><select onChange="protocolChange()" name="protocol" id="procotol" style="width:110px">
		<option value=""></option>
		<option value="TCP">TCP</option>
		<option value="UDP">UDP</option>
		<option value="ICMP">ICMP</option>
		<option value="Application">Application</option>
		</select>&nbsp;&nbsp;
	</td>
		<td></td>
    </tr>
    <tr id="portRangeTR1" style="visibility: hidden;">
		<td id="QoSClassifierDPortStr">Dest. Port Range</td>
		<td><input type="text" size="5" name="dFromPort" id="dFromPort">-
		<input type="text" size="5" name="dToPort" id="dToPort">
	</td>
		<td></td>
    </tr>
    <tr id="portRangeTR2" style="visibility: hidden;">
		<td id="QoSClassifierSPortStr">Src Port Range</td>
		<td><input type="text" size="5" name="sFromPort" id="sFromPort">-
		<input type="text" size="5" name="sToPort" id="sToPort">
	</td>
		<td></td>
    </tr>
    <tr id="appTR" style="visibility: hidden;">
		<td id="QoSClassifierL7Str" valign=top>Application</td>
		<td colspan=2><select name="layer7" id="layer7" size="8" onChange="layer7Change()" style="font-family:Courier New;">
		<script type="text/javascript">
			str = "";
			for(i=0; i<layer7_filename.length; i++){
				if (i== 0)
					str += "<option value=\""+layer7_filename[i]+"\">"+strFormat(layer7_name[i], 40)+"</option>";
				else
					str += "<option value=\""+layer7_filename[i]+"\">"+layer7_name[i]+"</option>";
			}
			document.write(str);
		</script>
		</select>&nbsp;&nbsp;<br>
		<span id="Layer7Intro"></span><br>
		<span id="Layer7IntroGp"></span><br>
		<span id="Layer7IntroSpd"></span><br>
		<span id="Layer7IntroQ"></span>
	</td>
	</tr>
	<tr><td colspan=3>&nbsp;&nbsp;</td></tr>
</table>

<table width="100%" class="config" cellpadding="2" cellspacing="1" style="display:none">
	<tr><td colspan="2" id="QoSClassifierRemarkStr">Remark DSCP as:</td>
	<td colspan="2">
		<select name="remark_dscp" id="remark_dscp">
		<option value="N/A">Not change</option>
		<option value="Auto" id="QoSClassifierAutoStr">Auto</option>
		<option value="BE">BE (000000)</option>
		<option value="AF11">AF11</option>
		<option value="AF12">AF12</option>
		<option value="AF13">AF13</option>
		<option value="AF21">AF21</option>
		<option value="AF22">AF22</option>
		<option value="AF23">AF23</option>
		<option value="AF31">AF31</option>
		<option value="AF32">AF32</option>
		<option value="AF33">AF33</option>
		<option value="AF41">AF41</option>
		<option value="AF42">AF42</option>
		<option value="AF43">AF43</option>
		<option value="EF">EF (101110)</option>
		</select>&nbsp;&nbsp;
	</td>
</tr>
</table>

<table width="100%" cellpadding="2" cellspacing="1">
	<tr><td class=red><b id="sQosNote">Note:</b></td>
		<td id="sQosNote1" class=blue>Please change Protocol as Application for APP Qos function.</td>
	</tr>
</table><br />

<table width="100%" cellpadding="2" cellspacing="1">
	<tr align="center"><td>
		<input type="button" class="btnw" name="modify" value="new" id="QoSClassifierNewStr" onClick="checkForm()"><!--
		<input type=hidden name="af_index" id="af_index" value="">-->
		<input type=hidden name="dp_index" id="dp_index" value="1">
	</td></tr>
</table>
</form>

</td></tr>
</table>

</body>
</html>
