<html>
<head>
<title>WAN General Setup</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>

<h1 id="v6Title"></h1>
<hr size="1" />
<br />

<form method=post name="frm" action="/goform/set_ipv6_wan" onSubmit="return CheckValue()">
<h2 id="v6WanIpConfig" class="title">WAN IPv6 Configuration</h2>

<table width="100%" cellpadding="2" cellspacing="1" class="config">
 <tr>
  <td class="head" id="v6ConnectionType">Connection Type</td>
  <td>
    <select name="wanMode" size="1" onchange="onChgMode();">
      <option value="0" id="mode_local">Link Local Only</option>
      <option value="1" id="mode_static">Static IPv6</option>
      <option value="2" id="mode_tspc">TSPC</option>
      <option value="3" id="mode_dhcp6c">DHCPv6 Client</option>
      <option value="4" id="mode_ppp">PPP</option>
      <option value="5" id="mode_6to4">6to4</option>
    </select>
  </td>
 </tr>
 <tr id="ppp" style="display:none">
  <td colspan="2">
    <b>Note : </b> IPv4 WAN setting should be <b>PPPoE</b> client with "Always On".
  </td>
 </tr>
</table>

<!-- ================= Link Local Mode ================= -->
<div id="local" style="display:none">
<h2 id="v6LocalMode">Link Local Only</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tr>
  <td class="head" id="v6LocalIp">IPv6 Address</td>
  <td><% getWanLinkIpv6(); %></td>
</tr>
<tr>
  <td class="head" id="v6LocalPrefixLen">Prefix Length</td>
  <td><% getWanLinkPrefixLen(); %></td>
</tr>
</table>
</div>

<!-- ================= Static Mode ================= -->
<div id="static" style="display:none">
<h2 id="v6StaticMode">Static IPv6 Settings</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tr>
  <td class="head" id="v6StaticIp">IPv6 Address</td>
  <td><input name="staticIp" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_wan_ip", 0); %>"></td>
</tr>
<tr>
  <td class="head" id="v6StaticPrefixLen">Prefix Length</td>
  <td><input name="staticPrefixLen" maxlength="3" size="3" value="<% getCfgGeneral(1, "v6_wan_prefixlen", 0); %>">
  </td>
</tr>
<tr>
  <td class="head" id="v6StaticGateway">Default Gateway</td>
  <td><input name="staticGateway" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_wan_gateway", 0); %>">
  </td>
</tr>
<tr>
  <td class="head" id="v6StaticPriDns">Primary DNS Server</td>
  <td><input name="staticPriDns" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_primary_dns", 0); %>"></td>
</tr>
<tr>
  <td class="head" id="v6StaticSecDns">Secondary DNS Server</td>
  <td><input name="staticSecDns" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_secondary_dns", 0); %>"></td>
</tr>
</table>
<table width="100%" cellpadding="2" cellspacing="1" style="display:none">
<tr align="left">
  <td><b id="v6StaticNote">Note : </b><span id="v6StaticNote1">Static IPv6 is only applied to WAN1 Static IP Mode.</span>
  </td>
</tr>
</table>
</div>

<!-- ================= TSPC Mode ================= -->
<div id="tspc" style="display:none">
<h2 id="v6TspcMode">TSPC Settings</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tr>
  <td class="head" id="v6TspcUser">Username</td>
  <td><input name="tspcUser" maxlength="31"></td>
</tr>
<tr>
  <td class="head" id="v6TspcPass">Password</td>
  <td><input type="password" name="tspcPass" maxlength="31" value="<% getCfgPwd(1, "v6_tspc_pass"); %>"></td>
</tr>
<tr>
  <td class="head" id="v6TspcPass2">Confirm Password</td>
  <td><input type="password" name="tspcPass2" maxlength="31" value="<% getCfgPwd(1, "v6_tspc_pass"); %>"></td>
</tr>
<tr>
  <td class="head" id="v6TspcServer">Tunnel Broker</td>
  <td><input name="tspcServer" maxlength="63">
  </td>
</tr>
<tr>
  <td class="head" id="v6TspcTunnelMode">Tunnel Mode</td>
  <td>
    <select name="tspcMode" size="1">
      <option value="0" id="mode_tunnel">IPv6-in-IPv4 Tunnel</option>
      <option value="1" id="mode_native">IPv6-in-IPv4 (Native)</option>
      <option value="2" id="mode_nat">IPv6-in-IPv4 (NAT Traversal)</option>
    </select>
  </td>
</tr>
<tr>
  <td class="head" id="v6TspcDelay">Auto-Reconnect Delay</td>
  <td><input name="tspcDelay" maxlength="8">&nbsp;<span id="v6TspcDelaySec">seconds</span></td>
</tr>
<tr>
  <td class="head" id="v6TspcKeepAlive">Keepalive</td>
  <td><input type="checkbox" name="tspcKeepAlive"></td>
</tr>
<tr>
  <td class="head" id="v6TspcKeepInt">Keepalive Interval</td>
  <td><input name="tspcKeepInt" maxlength="8">&nbsp;<span id="v6TspcKeepIntSec">seconds</span></td>
</tr>
<tr>
  <td class="head" id="v6TspcPrefixLen">Prefix Length</td>
  <td><input name="tspcPrefixLen" maxlength="3" size="3"></td>
</tr>
<tr>
  <td class="head" id="v6TspcInterface">Interface</td>
  <td><% getLanIfTspc(); %></td>
</tr>
</table>
</div>
<!-- ================= DHCP6C Mode ================= -->
<div id="dhcp6" style="display:none">
<h2 id="dhcpmode">DHCPv6 Client Settings</h2>
	<table width="100%" cellpadding="2" cellspacing="1" class="config">
	<tr>
		<td class=head id=Identity_Association>Identity Association</td>
		<td>
			<input type="radio" name="iOptIA" value="0">&nbsp;<span id=Prefix_Delegation>Prefix Delegation</span>
			<input type="radio" name="iOptIA" value="1">&nbsp;<span id=Non_temporary_Address>Non-temporary Address</span>
		</td>
	</tr>
	<tr>
		<td class=head id=Identity_Association_ID>IAID (Identity Association ID)</td>
		<td><input type="text" name=sIAID maxlength=11></td>
	</tr>
	</table>
</div>
<!-- ================= 6to4 Mode ================= -->
<div id="6to4" style="display:none">
<h2 id="v6to4Set">6to4 Settings</h2>
	<table width="100%" cellpadding="2" cellspacing="1" class="config">
	<tr>
		<td class=head id="v6to4RelayRouter">6to4 Relay Router</td>
		<td><input type="text" name=s6to4_relay maxlength=16 value="<% getCfgGeneral(1, "6to4_relay", 1); %>">
		    &nbsp;(<span id="v6Default">default</span>: 192.88.99.1)
		</td>
	</tr>
	</table>
</div>
<br>
<table width="100%" cellpadding="2" cellspacing="1">
<tr align="center">
  <td>
    <input type=submit class="btnw" value="OK" id="iApply">&nbsp;&nbsp;
    <input type=reset  class="btnw" value="Cancel" id="iCancel" onClick="window.location.reload()">
  </td>
</tr>
</table>
</form>

</td></tr>
</table>
</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("ipv6");

var f = document.frm;

function CheckValue()
{
	var wan_mode = getVleFromElmt(f.wanMode, 0);
	if (wan_mode == 1) {	// static
		var static_ip = getVleFromElmt(f.staticIp, 0);
		var static_prefixlen = getVleFromElmt(f.staticPrefixLen, 0);
		var static_gateway = getVleFromElmt(f.staticGateway, 0);
		var static_pri_dns = getVleFromElmt(f.staticPriDns, 0);
		var static_sec_dns = getVleFromElmt(f.staticSecDns, 0);

		if (static_ip == "" || !isIPv6(static_ip)) {
			alert(_("ipv6 addr invalid"));
			return false;
		}
		if (!isInt(static_prefixlen) || static_prefixlen < 0 || static_prefixlen > 128) {
			alert(_("ipv6 prefix len wrong"));
			return false;
		}
		if (!isIPv6(static_gateway) || (static_gateway == static_ip)) {
			alert(_("ipv6 gw addr invalid"));
			return false;
		}
		if (!isIPv6(static_pri_dns)) {
			alert(_("ipv6 pri dns addr invalid"));
			return false;
		}
		if (!isIPv6(static_sec_dns)) {
			alert(_("ipv6 snd dns addr invalid"));
			return false;
		}

	} else if (wan_mode == 2) {	// tspc
		var tspc_user = getVleFromElmt(f.tspcUser, 0);
		var tspc_pass = getVleFromElmt(f.tspcPass, 0);
		var tspc_pass2 = getVleFromElmt(f.tspcPass2, 0);
		var tspc_server = getVleFromElmt(f.tspcServer, 0);
		var tspc_delay = getVleFromElmt(f.tspcDelay, 0);
		var tspc_keep_int = getVleFromElmt(f.tspcKeepInt, 0);
		var tspc_prefixlen = getVleFromElmt(f.tspcPrefixLen, 0);

		// check tspc_user

		if (tspc_pass != tspc_pass2) {
			alert(_("pwd not match"));
			return false;
		}
		// check tspc_pass

		// check tspc_server

		if (!isInt(tspc_delay) || tspc_delay < 0) {
			alert(_("tspc_delay invalid"));
			return false;
		}
		if (!isInt(tspc_keep_int) || tspc_keep_int < 1) {
			alert(_("keepalive interval invalid"));
			return false;
		}
		if (!isInt(tspc_prefixlen) || tspc_prefixlen < 0 || tspc_prefixlen > 128) {
			alert(_("ipv6 prefix len wrong"));
			return false;
		}
	} else if (wan_mode == 3) { // dhcp6c
		var sIAID = f.sIAID.value;
		if(isNaN(sIAID)||sIAID<0||sIAID>4294967295){
			alert(_("ipv6 IAID wrong"));
			return false;
		}
	} else if (wan_mode == 4) { // ppp
		var wan_IPv4_mode = '<% getCfgGeneral(1, "wanConnectionMode", 1); %>';
		var wan_IPv4_PPPoE_opmode  = '<% getCfgGeneral(1, "wan_pppoe_opmode", 1); %>';
		if(wan_IPv4_mode != "PPPOE"|| wan_IPv4_PPPoE_opmode != "KeepAlive"){
			alert(_("pppoe wrong"));
			return false;
		}
	} else if (wan_mode == 5) { // 6to4
		if (f.s6to4_relay.value != "" && !checkIpAddr(f.s6to4_relay, false))
			return false;
	}
	return true;
}

function initTranslation()
{
	var e = document.getElementById("v6Title");
	e.innerHTML = _("parent ipv6")+" >> "+_("ipv6 wan title");

	e = document.getElementById("v6WanIpConfig");
	e.innerHTML = _("ipv6 wan ip config");
	e = document.getElementById("v6ConnectionType");
	e.innerHTML = _("ipv6 wan conn type");
	e = document.getElementById("mode_local");
	e.innerHTML = _("ipv6 wan local");
	e = document.getElementById("mode_static");
	e.innerHTML = _("ipv6 wan static");
	e = document.getElementById("mode_tspc");
	e.innerHTML = _("ipv6 wan tspc");
	e = document.getElementById("mode_dhcp6c");
	e.innerHTML = _("ipv6 wan dhcp6c");
	e = document.getElementById("mode_ppp");
	e.innerHTML = _("ipv6 wan ppp");
	e = document.getElementById("mode_6to4");
	e.innerHTML = _("ipv6 wan 6to4");

	e = document.getElementById("v6LocalMode");
	e.innerHTML = _("ipv6 wan local");
	e = document.getElementById("v6LocalIp");
	e.innerHTML = _("ipv6 addr");
	e = document.getElementById("v6LocalPrefixLen");
	e.innerHTML = _("ipv6 prefixlen");

	e = document.getElementById("v6StaticMode");
	e.innerHTML = _("ipv6 wan static setting");
	e = document.getElementById("v6StaticIp");
	e.innerHTML = _("ipv6 addr");
	e = document.getElementById("v6StaticPrefixLen");
	e.innerHTML = _("ipv6 prefixlen");
	e = document.getElementById("v6StaticGateway");
	e.innerHTML = _("ipv6 gateway");
	e = document.getElementById("v6StaticPriDns");
	e.innerHTML = _("ipv6 pri dns");
	e = document.getElementById("v6StaticSecDns");
	e.innerHTML = _("ipv6 sec dns");
	e = document.getElementById("v6StaticNote");
	e.innerHTML = _("ipv6 note");
	e = document.getElementById("v6StaticNote1");
	e.innerHTML = _("ipv6 wan static note");

	e = document.getElementById("v6TspcMode");
	e.innerHTML = _("ipv6 wan tspc setting");
	e = document.getElementById("v6TspcUser");
	e.innerHTML = _("ipv6 user");
	e = document.getElementById("v6TspcPass");
	e.innerHTML = _("ipv6 pass");
	e = document.getElementById("v6TspcPass2");
	e.innerHTML = _("ipv6 pass confirm");
	e = document.getElementById("v6TspcServer");
	e.innerHTML = _("ipv6 wan tspc server");
	e = document.getElementById("v6TspcTunnelMode");
	e.innerHTML = _("ipv6 wan tspc mode");
	e = document.getElementById("mode_tunnel");
	e.innerHTML = _("ipv6 wan tspc tunnel");
	e = document.getElementById("mode_native");
	e.innerHTML = _("ipv6 wan tspc native");
	e = document.getElementById("mode_nat");
	e.innerHTML = _("ipv6 wan tspc nat");
	e = document.getElementById("v6TspcDelay");
	e.innerHTML = _("ipv6 wan tspc delay");
	e = document.getElementById("v6TspcDelaySec");
	e.innerHTML = _("ipv6 seconds");
	e = document.getElementById("v6TspcKeepAlive");
	e.innerHTML = _("ipv6 wan tspc keepalive");
	e = document.getElementById("v6TspcKeepInt");
	e.innerHTML = _("ipv6 wan tspc keepalive int");
	e = document.getElementById("v6TspcKeepIntSec");
	e.innerHTML = _("ipv6 seconds");
	e = document.getElementById("v6TspcPrefixLen");
	e.innerHTML = _("ipv6 prefixlen");
	e = document.getElementById("v6TspcInterface");
	e.innerHTML = _("ipv6 interface");
	e = document.getElementById("dhcpmode");
	e.innerHTML = _("ipv6 dhcp client");
	e = document.getElementById("Identity_Association");
	e.innerHTML = _("ipv6 dhcp ia");

	e = document.getElementById("Prefix_Delegation" );
	e.innerHTML = _("Prefix_Delegation");
	e = document.getElementById("Non_temporary_Address" );
	e.innerHTML = _("Non_temporary_Address");
	e = document.getElementById("Identity_Association_ID");
	e.innerHTML = _("Identity_Association_ID");
	e = document.getElementById("v6to4Set");
	e.innerHTML = _("ipv6 6to4 setting");
	e = document.getElementById("v6to4RelayRouter");
	e.innerHTML = _("ipv6 6to4 relay");
	e = document.getElementById("v6Default");
	e.innerHTML = _("ipv6 default");

	e = document.getElementById("iApply");
	e.value = _("ipv6 apply");
	e = document.getElementById("iCancel");
	e.value = _("ipv6 cancel");
}

function initValue()
{
	initTranslation();

	var wan_mode = "<% getCfgGeneral(1, "v6_wan_mode", 1); %>";
	var tspc_str = "<% getCfgGeneral(1, "v6_tspc", 1); %>";
	var random_iaid = "<% getDhcpIAID(); %>";

	if (wan_mode.length == 0)
		wan_mode = "0";
	setVle2Elmt(f.wanMode, wan_mode, 0);

	if (tspc_str.length == 0)
		tspc_str = ",broker.freenet6.net,0,30,1,30,56";
	var tspc = tspc_str.split(",");
	if (tspc.length == 7) {
		setVle2Elmt(f.tspcUser, tspc[0], 0);
		setVle2Elmt(f.tspcServer, tspc[1], 0);
		setVle2Elmt(f.tspcMode, tspc[2], 0);
		setVle2Elmt(f.tspcDelay, tspc[3], 0);
		setVle2Elmt(f.tspcKeepAlive, tspc[4], 0);
		setVle2Elmt(f.tspcKeepInt, tspc[5], 0);
		setVle2Elmt(f.tspcPrefixLen, tspc[6], 0);
	}
	var iOptIA = "<% getCfgGeneral(1, "v6_wan_dhcp_id_assoc", 1); %>";
	if(iOptIA == 'na'){
		setVle2Elmt(f.iOptIA[0], 1, 0);
	}else{
		setVle2Elmt(f.iOptIA[0], 0, 0);
	}
	if ('<% getCfgGeneral(1, "v6_wan_dhcp_iaid", 1); %>' == '0' 
		|| '<% getCfgGeneral(1, "v6_wan_dhcp_iaid", 1); %>' == '')
		setVle2Elmt(f.sIAID, random_iaid, 0);
	else
		setVle2Elmt(f.sIAID, '<% getCfgGeneral(1, "v6_wan_dhcp_iaid", 1); %>', 0); 
		
	onChgMode();
}

function onChgMode()
{
	var wan_mode = getVleFromElmt(f.wanMode, 0);

	SetVisible("local", false);
	SetVisible("static", false);
	SetVisible("tspc", false);
	SetVisible("dhcp6", false);
	SetVisible("ppp", false);
	SetVisible("6to4", false);
	if (wan_mode == 0) {
		SetVisible("local", true);
	} else if (wan_mode == 1) {
		SetVisible("static", true);
	} else if (wan_mode == 2){
		SetVisible("tspc", true);
	} else if (wan_mode == 3){
		SetVisible("dhcp6", true);
	} else if (wan_mode == 4){
		SetVisible("ppp", true);
	} else if (wan_mode == 5){
		SetVisible("6to4", true);
	}
}
</script>
