#!/bin/sh

#sleep for awhile (wait for nvram_daemon ready)
sleep 3

# insert USB related module
usbmod_exist=`mount | grep dwc_otg | wc -l`

if [ $usbmod_exist == 0 ]; then
insmod -q lm
insmod -q dwc_otg
fi

#insmod usbserial and option
m_usb=`lsmod | grep usbserial` 
m_opt=`lsmod | grep option`
if [ -z "$m_usb" ]; then
	insmod -q usbserial
fi

#insmod hso
#m_hso=`lsmod | grep hso` 
#if [ -z "$m_hso" ]; then
#	insmod -q hso
#fi

#step1 make /var/natwork
[ -d /var/network ]
if [ $? != "0" ]; then
    mkdir /var/network
fi

#step2 make dir /var/3g
#we put 3G device infomation here,
#1. wan_dev   2. wan_3gdev
[ -d /var/3g ]
if [ $? != "0" ]; then
    mkdir /var/3g
fi

#step3 set initial value
echo "/dev/ttyUSB0" > /var/3g/wan_dev
echo "" > /var/3g/wan_3gdev
echo "0" > /var/3g/sche_lock

#we stop to use option module
#if [ -z $m_opt ]; then
#insmod -q option
#fi

#step4 insert watch dog or dray test module
TST_MODE=`nvram_get 2860 test_mode`
if [ "$TST_MODE" == "1" ]; then
	TST_FIRST=`nvram_get 2860 test_first`
	if [ "$TST_FIRST" != "1" -a "$TST_FIRST" != "2" ]; then
		nvram_set 2860 test_first 1
		insmod -q dray_burn_in_test
		#set LED 
		gpio l 9 2 2 4000 0 4000	#ACT LED
		gpio l 12 2 2 4000 0 4000	#USB LED
	else
		if [ "$TST_FIRST" == "1" ]; then
			nvram_set 2860 test_first 2
		fi
		insmod -q dray_burn_in_test
		#set LED FAIL 
		gpio l 9 0 4000 0 1 4000	#ACT LED dark
		gpio l 12 2 2 4000 0 4000	#USB LED	
	fi
else
	insmod -q rt_timer
	gpio l 9 8 8 4000 0 4000	#ACT LED
fi

#check if usb device is connecting, if yes, do mode switch 
exec 3<&0
exec 0<'/proc/bus/usb/devices'
i=0
while read line
do
	#echo "line $i: " $line
#	first='Vendor='
#	last=' '
#	substr=$(echo "$line"|sed -n "s/^[^$first]*\($first[^$last]*$last\).*/\1/p")
#	if [ -n "$substr" ]; then
#		vendor=$(expr substr "$substr" 8 12)
#		echo "substr=$substr, substr2=$vendor"
#	fi
	
	line=$(echo $line|grep "^P:")
	if [ -n "$line" ]; then
		#echo "line=$line"
		vendor=$(echo "$line"|awk '{print $2}')
		product=$(echo "$line"|awk '{print $3}')
		rev=$(echo "$line"|awk '{print $5}')
		#echo "v=$vendor, p=$product, r=$rev"
		vendor=$(expr substr "$vendor" 8 12)
		product=$(expr substr "$product" 8 12)
		#we always set VersionID to 0, because this value usually is 0 
		#although root hub is this platform is 2.06
		param="$vendor/$product/0"
		echo $param

        # NOTE: vendor ID and Product ID must be in lower case!!!!
        # Wimax initialization is now at : wan_ru.sh
		if [ "$vendor" == "04e8" -o "$vendor" == "04e9" ]; then
			echo "Samsung Wimax"
		elif [ $vendor == "1076" -a "$product" == "7f40" ]; then
			echo "Wijet wimax storage mode device detected......."
		elif [ $vendor == "198f" -a "$product" == "bccd" ]; then
			echo "Jingle wimax storage mode device detected......."
		elif [ $vendor == "0b05" -a "$product" == "bccd" ]; then
			echo "Global 1 wimax storage mode device detected......."
		elif [ $vendor == "12d1" -a "$product" == "3809" ]; then
			echo "BM325 wimax storage mode device detected......."
		elif [ $vendor == "1076" -a "$product" == "7708" ]; then
			echo "YOTA KEY......."
			#ifconfig eth0 up
		elif [ $param != "0000/0000/0" ]; then
			echo "Bingo........."
			#pre-check for ZTE device
			if [ $param == "19d2/2000/0" ]; then
				ZTE_CHK=`cat /proc/bus/usb/devices | grep "SerialNumber=P671M8VDF_MS"`
				if [ "$ZTE_CHK" != "" ];then
					echo "Get ZTE K3520-Z"
					echo "/dev/ttyUSB2" > /var/3g/wan_dev
				else
					echo "Get ZTE device"
					echo "/dev/ttyUSB3" > /var/3g/wan_dev
				fi
			fi
			EXT_CMD_3G=`nvram_get 2860 extend_3gcmd`
			EXT_STORID_3G=`nvram_get 2860 extend_stor_3gid`
			#echo "EXT_STORID_3G: $EXT_STORID_3G"
			#echo "PRODUCT: $param"
			#draytek_hsdpa arguments: vendorID/productID/0 deviceIf(0:undefined, 1~4:ttyUSB0~ttyUSB3) [MessageContent]
			#deviceIf: the first interrupted interface that found from struct usb_device
			if [ "$EXT_CMD_3G" != "" -a "$EXT_STORID_3G" = "$param" ]; then
				/bin/draytek_hsdpa $param 0 $EXT_CMD_3G
			else
				/bin/draytek_hsdpa $param 0
			fi
			#draytek_hsdpa $param 0
		fi
	fi
done

#turn on/off usb led
/sbin/usb_led_ctrl.sh

#make dir for 3G connect
[ -d /var/lock ]
if [ $? != "0" ]; then
        mkdir /var/lock
fi
