#!/bin/sh
#
# $Id: ddns.sh,v 1.1 2007-09-24 09:34:52 winfred Exp $
#
# usage: ddns.sh
#

enable=`nvram_get 2860 DDNSEnable`
srv=`nvram_get 2860 DDNSProvider`
ddns=`nvram_get 2860 DDNS`
u=`nvram_get 2860 DDNSAccount`
pw=`nvram_get 2860 DDNSPassword`
check=`nvram_get 2860 DDNSCheckPeriod`
update=`nvram_get 2860 DDNSUpdatePeriod`

killall -q inadyn

if [ "$enable" != "1" ]; then
	exit 0
fi
if [ "$srv" = "" -o "$srv" = "none" ]; then
	exit 0
fi
if [ "$ddns" = "" -o "$u" = "" -o "$pw" = "" ]; then
	exit 0
fi

# debug
echo "srv=$srv"
echo "ddns=$ddns"
echo "u=$u"
echo "pw=$pw"

echo "inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv"

extra_conf=""
check_p=`echo $check | awk '{FS=";"}{print $1}'`
if [ "$check_p" != "" ]; then
	extra_conf="$extra_conf --update_period_sec $check_p"
fi
update_p=`echo $update | awk '{FS=";"}{print $1}'`
if [ "$update_p" != "" ]; then
	extra_conf="$extra_conf --forced_update_period $update_p"
fi

if [ "$srv" = "dyndns.org" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system dyndns@$srv $extra_conf &
elif [ "$srv" = "freedns.afraid.org" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "zoneedit.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "no-ip.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "3322.org" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "vigorddns.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "huagai.net" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "changeip.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "dtdns.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
elif [ "$srv" = "twodns.com" ]; then
	inadyn -u $u -p $pw -a $ddns --dyndns_system default@$srv $extra_conf &
else
	echo "$0: unknown DDNS provider: $srv"
	exit 1
fi

