#!/bin/sh
# Draytek
. /sbin/global.sh

WAN_MODE=`nvram_get 2860 wanConnectionMode`
if [ "$WAN_MODE" != "PPPOE" ]; then
	echo "WAN mode not PPPOE: $WAN_MODE!!!"
	exit 0
fi

# igmpproxy with dual access
killall -q igmpproxy
igmp=`nvram_get 2860 igmpEnabled`
if [ "$igmp" = "1" ]; then
    iptv_mode=`nvram_get 2860 iptv_mode`
	if [ "$iptv_mode" = 1 ]; then
		#static IP mode
		iptv_ip=`nvram_get 2860 iptv_ip`
		iptv_mask=`nvram_get 2860 iptv_mask`
		if [ "$iptv_ip" != "" -a "$iptv_mask" != "" ]; then
			ifconfig "$wan_if" "$iptv_ip" netmask "$iptv_mask"
			iptables  -t nat -D POSTROUTING -s "$iptv_ip"/"$iptv_mask" -o "$wan_if" -j MASQUERADE > /dev/null 2>&1
			iptables  -t nat -A POSTROUTING -s "$iptv_ip"/"$iptv_mask" -o "$wan_if" -j MASQUERADE
			config-igmpproxy.sh $wan_if
		fi	
	elif [ "$iptv_mode" = 2 ]; then
		killall -q -SIGTERM udhcpc
		udhcpc -i $wan_if -s /sbin/udhcpc.sh -p /var/run/udhcpc_nogw.pid &
	else
		#normal mode
		if [ "$wan_ifname" = "ppp0" ]; then
			config-igmpproxy.sh $wan_if
		else
			config-igmpproxy.sh $wan_ifname
		fi
	fi
fi
