#!/bin/sh
domain=$1
iface=$2
exe_nslookup=$3

ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"
cp /etc/resolv.conf /etc/resolv.conf.bk	# backup DNS config

# for voip wan
[ -f /etc/voip_resolv.conf ] && {
	dnsip="${dnsip:-$(cat /etc/voip_resolv.conf 2>/dev/null | grep -o "$ip_regex" -m 1)}"
	cp /etc/voip_resolv.conf /etc/resolv.conf	#overwrite DNS config
	### add route
	[ -n "$dnsip" ] && {
		ip rule del to $dnsip/32 table 23 2>/dev/null
		ip rule add to $dnsip/32 table 23 2>/dev/null
	}
}

if [ "$exe_nslookup" != "no" ]; then
	registered_ip=$(echo $(nslookup "$domain" "${dnsip:+$dnsip}" 2>/dev/null) | grep -o "Name:.*" | grep -o "$ip_regex")
	echo "$registered_ip"
	cp /etc/resolv.conf.bk /etc/resolv.conf	# restore DNS config
fi