#!/bin/sh
#
# usage: internet_wan.sh
# if we press WAN button, we only have to set WAN, NAT and firewall  
#

. /sbin/config.sh
. /sbin/global.sh

#vpn-passthru.sh


# stop all
iptables --flush
iptables --flush -t nat
iptables --flush -t mangle

#
# init ip address to all interfaces for different OperationMode:
#   1 = Gateway Mode
#   3 = AP Client
#

if [ "$opmode" = "1" ]; then	
	wan.sh
	#lan.sh
	nat.sh
elif [ "$opmode" = "3" ]; then
	wan.sh
	#lan.sh
	nat.sh
else
	echo "unknown OperationMode: $opmode"
	exit 1
fi

# in order to use broadcast IP address in L2 management daemon
if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
	route add -host 255.255.255.255 dev $wan_if
else
	route add -host 255.255.255.255 dev $lan_if
fi
