#!/bin/sh
#
#
. /sbin/global.sh


add_iprouting() {
	
	eval `ipcalc -b -n $ip_2 $nm_2`
	classc=${NETWORK%.*}
	host_start=${NETWORK##*.}
	host_end=${BROADCAST##*.}
	i=$(expr $host_start + 1)
	echo "$classc , $host_start , $host_end"
	while [ $i -lt $host_end ]; do
		#echo "arp -i $wan_if -Ds $classc.$i $wan_if pub"
		arp -i $wan_if -Ds $classc.$i $wan_if pub
		i=$(expr $i + 1)
	done
}

delete_iprouting() {

	eval `ipcalc -b -n $ip_2 $nm_2`
	classc=${NETWORK%.*}
	host_start=${NETWORK##*.}
	host_end=${BROADCAST##*.}
	i=$(expr $host_start + 1)
	echo "$classc , $host_start , $host_end"
	while [ $i -lt $host_end ]; do
		#echo "arp -i $wan_if -d $classc.$i pub"
		arp -i $wan_if -d $classc.$i pub
		i=$(expr $i + 1)
	done
}


# Add proxy arp for 2nd subnet
lan2enabled=`nvram_get 2860 Lan2Enabled`
if [ "$lan2enabled" = "1" ]; then
	ip_2=`nvram_get 2860 lan2_ipaddr`
	nm_2=`nvram_get 2860 lan2_netmask`
else
	echo "2nd subnet not enable..."
fi

if [ "$1" == "add" ]; then
	add_iprouting
elif  [ "$1" == "del" ]; then
	delete_iprouting
fi
