#!/bin/sh
# vigorfly200 ipv6 remote management 

. /sbin/global.sh

IPTABLES=ip6tables

rm6_init(){
	local http_en
	local http_port
	local https_en
	local https_port
	local icmp_en
	local tel_en
	local tel_port
	local wan_v6_ip
	
	http_en=`nvram_get 2860 RemoteManagement6`
	http_port=`nvram_get 2860 ManagementPort`
	https_en=`nvram_get 2860 RemoteManagementHttps6`
	https_port=`nvram_get 2860 ManagementHttpsPort`
	icmp_en=`nvram_get 2860 WANPingFilter6`
	tel_en=`nvram_get 2860 RemoteTelnet6`
	tel_port=`nvram_get 2860 TelnetPort`
	
	#flush INPUT table
	$IPTABLES -F INPUT
	
	#Set default ACCEPT
	ip6tables --policy INPUT ACCEPT	
	
	#HTTP
	if [ "$http_en" != "1" ];then
		if [ "$http_port" = "" ];then
			http_port=80
		fi
		ip6tables -A INPUT -i $wan_if -p tcp --dport $http_port -j DROP
	fi
	#HTTPS
	if [ "$https_en" != "1" ];then
		if [ "$https_port" = "" ];then
			https_port=443
		fi
		ip6tables -A INPUT -i $wan_if -p tcp --dport $https_port -j DROP
	fi
	#ICMP
	if [ "$icmp_en" != "1" ];then
		ip6tables -A INPUT -i $wan_if -p icmpv6 --icmpv6-type echo-request -j DROP
	fi
	#TELNET
	if [ "$tel_en" != "1" ];then
		if [ "$tel_port" = "" ];then
			tel_port=23
		fi
		ip6tables -A INPUT -i $wan_if -p tcp --dport $tel_port -j DROP
	fi
	
}

rm6_stop() {
	$IPTABLES -F INPUT
}

if [ "$1" == "start" ]; then
	#ipv6 Management start
	echo "IPv6 Management Start!!!!"
	rm6_init
elif [ "$1" == "stop" ]; then
	#ipv6 Management stop
	echo "IPv6 Management Stop!!!!"
	rm6_stop
else
	echo "IPv6 Management"
	echo "command: /sbin/remote_mgr6.sh [start/stop]"
fi

