#!/bin/sh
# Draytek
# 
# Add RoutingRules entries into routing table accroding to wan mode.
# 

if [ "$1" = "" ]; then
	echo "usage : static_route.sh [wanmode]/[action]"
	exit 1
fi

if [ "$1" = "WAN" ]; then
	target=`nvram_get 2860 wanConnectionMode`
else
	target=$1
fi

rules=`nvram_get 2860 RoutingRules | sed 's/;/\n/g'`
for temp in $rules; do
	i=0
	dest=""
	netmask=""
	gateway=""
	type=""
	interface=""
	wan_mode=""
	entry=`echo $temp | sed 's/,/ /g'`
	for temp2 in $entry; do
		if [ "$i" = "0" ]; then
			dest=$temp2
		elif [ "$i" = "1" ]; then
			netmask=$temp2
		elif [ "$i" = "2" ]; then
			if [ "$temp2" != "0.0.0.0" ]; then
				gateway="gw $temp2"
			fi
		elif [ "$i" = "3" ]; then
			type=$temp2
		elif [ "$i" = "4" ]; then
			interface=$temp2
		elif [ "$i" = "5" ]; then
			wan_mode=$temp2
			break
		fi
		i=$(expr $i + 1)
	done

		if [ "$type" = "WAN" -a "$wan_mode" != "" ]; then
			if [ "$wan_mode" = "$target" ]; then
				# Add static route with specified wan mode
				if [ "$netmask" = "255.255.255.255" ]; then
					route add -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route add -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			elif [ "$2" = "backup" ]; then
				# For backup WAN, remove static route with other wan mode
				if [ "$netmask" = "255.255.255.255" ]; then
					route del -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route del -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			fi
		elif [ "$type" = "VoIP_WAN" ]; then
			if [ "$1" = "Add" -a "$2" = "VoIP" ]; then
				if [ "$netmask" = "255.255.255.255" ]; then
					route add -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route add -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			elif [ "$1" = "Del" -a "$2" = "VoIP" ]; then
				if [ "$netmask" = "255.255.255.255" ]; then
					route del -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route del -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			fi
		elif [ "$type" = "Management_WAN" ]; then
			if [ "$1" = "Add" -a "$2" = "Mgmt" ]; then
				if [ "$netmask" = "255.255.255.255" ]; then
					route add -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route add -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			elif [ "$1" = "Del" -a "$2" = "Mgmt" ]; then
				if [ "$netmask" = "255.255.255.255" ]; then
					route del -host $dest $gateway dev $interface > /dev/null 2>&1
					#echo "route del -host $dest $gateway dev $interface > /dev/null 2>&1"
				else
					route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
					#echo "route del -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
				fi
			fi
		fi

done

