#!/bin/sh

usage()
{
    echo "Usage :"
    echo "  tun_set.sh <tunnel_ip> <remote_ip> <remote_subnet> "
    echo "  tun_set.sh enable"
    echo "  tun_set.sh disable"
    echo "  tun_set.sh show"
    echo "  tun_set.sh config"
}

dev_name="gtun0"

show() {
    echo "tunnel addr :" 
    ip addr show dev $dev_name
    echo""
    echo "route :" 
    route -n
}

config() {
    #echo "gre tunnel config :" 
    echo -n "enable: " 
    nvram_get 2860 gre_enable
     echo -n "tunnel ip: " 
    nvram_get 2860 gre_tunnel_ip
    echo -n "remote ip: " 
    nvram_get 2860 gre_remote_ip
    echo -n "remote subnet: " 
    nvram_get 2860 gre_remote_subnet
}

if [ "$1" = "enable" ]; then
    nvram_set 2860 gre_enable 1
    exit 1
elif [ "$1" = "disable" ]; then
    nvram_set 2860 gre_enable 0
    tun=$(ifconfig | grep $dev_name)
    if [ "$tun" != "" ]; then
      ip tunnel del $dev_name
    fi
    exit 1
elif [ "$1" = "show" ]; then
    show
    exit 1
elif [ "$1" = "config" ]; then
    config
    exit 1	
elif [ "$3" = "" ]; then
    usage
    exit 1	
fi

#nvram_set 2860 gre_enable 1
nvram_set 2860 gre_tunnel_ip $1
nvram_set 2860 gre_remote_ip $2
nvram_set 2860 gre_remote_subnet $3
