#!/bin/sh
# Draytek
#
# Do these things when wan or backup wan is up.
#

wan_up=`test -f /var/network/wan_up && cat /var/network/wan_up`
wan2_up=`test -f /var/network/wan2_up && cat /var/network/wan2_up`
wan3g_up=`test -f /var/network/3gwan_up && cat /var/network/3gwan_up`
v6_wan_mode=`nvram_get v6_wan_mode`

if [ "$wan_up" = "0" -a "$wan2_up" = "0" -a "$wan3g_up" = "0" ]; then
	echo "up.sh : wan is not up"
	rm -f /var/do_up
	exit 0
fi

# get wan interface
wan_ifname=`route -n | grep ^0.0.0.0 | awk '{print $8}'`
if [ "$wan_ifname" = "" ]; then
	echo "up.sh : no default route"
	rm -f /var/do_up
	exit 0
fi

. /sbin/global.sh

echo "up.sh ($wan_ifname)"

# dhcp relay
if [ -x /sbin/dhcprelay.sh ]; then
    /sbin/dhcprelay.sh
fi

# ddns
if [ -x /sbin/ddns.sh ]; then
	/sbin/ddns.sh
fi

#ntp
if [ -x /sbin/ntp.sh ]; then
	/sbin/ntp.sh
fi

# igmpproxy with dual access
killall -q igmpproxy
igmp=`nvram_get 2860 igmpEnabled`
if [ "$igmp" = "1" ]; then
    iptv_mode=`nvram_get 2860 iptv_mode`
	if [ "$iptv_mode" = 1 ]; then
		#static IP mode
		iptv_ip=`nvram_get 2860 iptv_ip`
		iptv_mask=`nvram_get 2860 iptv_mask`
		if [ "$iptv_ip" != "" -a "$iptv_mask" != "" ]; then
			ifconfig "$wan_if" "$iptv_ip" netmask "$iptv_mask"
			iptables  -t nat -D POSTROUTING -s "$iptv_ip"/"$iptv_mask" -o "$wan_if" -j MASQUERADE > /dev/null 2>&1
			iptables  -t nat -A POSTROUTING -s "$iptv_ip"/"$iptv_mask" -o "$wan_if" -j MASQUERADE
			config-igmpproxy.sh $wan_if
		fi
	elif [ "$iptv_mode" = 2 ]; then
		if [ -f /var/run/udhcpc_nogw.pid ]; then
			temp=`cat /var/run/udhcpc_nogw.pid`
			kill -SIGTERM $temp
		fi
		udhcpc -i $wan_if -s /sbin/udhcpc.sh -p /var/run/udhcpc_nogw.pid &
	else
		#normal mode
		config-igmpproxy.sh $wan_if
	fi
fi

# upnp
killall -q upnpd
if [ "$opmode" = "0" -o "$opmode" = "1" ]; then
	upnp=`nvram_get 2860 upnpEnabled`
	if [ "$upnp" = "1" ]; then
		ip=`nvram_get 2860 lan_ipaddr`
		route add -net 239.0.0.0 netmask 255.0.0.0 dev $lan_if
		upnp_xml.sh $ip
		upnpd -f $wan_ifname $lan_if &
	fi
fi

# pppoe-relay
killall -q pppoe-relay
pppr=`nvram_get 2860 pppoeREnabled`
if [ "$pppr" = "1" ]; then
	pppoe-relay -S $wan_if -B $lan_if
fi

# check wcf server ip
killall activate.cgi > /dev/null 2>&1
wcf_en=`nvram_get 2860 wcf_enable`
if [ "$wcf_en" = "1" ]; then
	/etc_ro/web/cgi-bin/activate.cgi chk_lic &
fi

# IPv6 6to4
if [ -x /sbin/6to4.sh -a "$v6_wan_mode" = "5" ]; then
  /sbin/6to4.sh start
fi

rm -f /var/do_up

