#!/bin/sh
#

WAN_TYPE=`nvram_get 2860 wanConnectionMode`
if [ "$1" = "up" ]; then
	wimaxEnable=`cat /var/network/wimaxUp`
	status2=`test -f /var/network/wimaxStatus2 && cat /var/network/wimaxStatus2`
	if [ "$wimaxEnable" = "1" -a "$status2" = "1" ]; then
		interfaceExist=`ifconfig -a | grep wimax0`
		if [ "$interfaceExist" != "" ]; then
			ifconfig wimax0 up
			#LTE bridge mode
			LTE_BRI=`nvram_get 2860 lte_bridge`
			if [ "$LTE_BRI" = "1" ]; then
				logger "LTE bridge mode is enabled"
				brctl addbr br1
				brctl addif br1 eth2.2
				brctl addif br1 wimax0
				ifconfig br1 up
				exit 0
			fi
			temp=`ps | grep "udhcpc" | grep "wimax0"`
			if [ "$temp" != "" ]; then
				exit 0
			fi
			sleep 1
			temp=`ps | grep "udhcpc" | grep "wimax0"`
			if [ "$temp" != "" ]; then
				exit 0
			fi
			while route del default ; do
       	         :
       	     	done
			if [ "$WAN_TYPE" = "Wimax" ]; then
				#wimax wan
				udhcpc -i wimax0 -s /sbin/udhcpc.sh -O staticroutes -p /var/run/udhcpc.pid &
			else
				#wimax backup wan
				udhcpc -i wimax0 -s /sbin/udhcpcbk.sh -O staticroutes -p /var/run/udhcpcbk.pid &
			fi
			logger "Wimax interface up"
		fi
	fi
elif [ "$1" = "down" ]; then
	interfaceExist=`ifconfig | grep wimax0`
	if [ "$interfaceExist" != "" ]; then
		temp=`ps | grep "udhcpc" | grep "wimax0" | awk '{print $1}'`
		if [ "$temp" != "" ]; then
			kill -SIGTERM $temp
		fi
		#LTE bridge mode
		LTE_BRI=`nvram_get 2860 lte_bridge`
		if [ "$LTE_BRI" = "1" ]; then	
			ifconfig br1 down
			brctl delif br1 wimax0
			brctl delif br1 eth2.2
		fi
			ifconfig wimax0 down
		logger "Wimax interface down"
	fi
elif [ "$1" = "reload" ]; then
	provider=`nvram_get 2860 wimax_service_provider`

	if [ "$provider" = "1" -o "$provider" = "2" -o "$provider" = "3" -o "$provider" = "10" ]; then
		/bin/usb_app wimax
	elif [ "$provider" = "4" -o "$provider" = "5" -o "$provider" = "7" -o "$provider" = "8" ]; then
		/bin/usb_app wimax
	elif [ "$provider" = "6" -o "$provider" = "9" -o "$provider" = "11" ]; then
		/bin/gpio u
	fi
fi

