#!/bin/sh

if [ -z $1 -o -z $2 -o -z $3 ]; then
	echo "usage : make_default_conf.sh <base_file> <diff_file> <output_file>"
	exit 0
fi
if [ ! -f $1 -o ! -f $2 ]; then
	echo "usage : make_default_conf.sh <base_file> <diff_file> <output_file>"
	exit 0
fi

cp $1 $3

temp=$(cat $2)
for line in $temp
do
	name=$(echo $line | cut -d '=' -f 1)
	if [ ! -z $name ]; then
		match=$(grep -m 1 -e ^$name= $3)
		if [ -z $match ]; then
			echo $line >> $3
		else
			sed -i "s/^$match$/$line/g" $3
		fi
	fi
done

