#!/bin/sh

echo Status: 200 OK
echo Content-type: text/html
echo

. /tmp/envir.sh

if [ "$REMOTE_USER" != "$Administrator" ]
then
	echo "Permission denied"
	exit
fi

test2=`echo $CLIENT_FILENAME | grep "uImage$"`
test3=`echo $CLIENT_FILENAME | grep "userland.img$"`
test4=`echo $CLIENT_FILENAME | grep "var$"`
test5=`echo $CLIENT_FILENAME | grep "DCS-6915_[A-Z][0-9]_V[0-9].[0-9][0-9].[0-9][0-9]$"`
test6=`echo $CLIENT_FILENAME | grep "mcu.bin$"`		# NH073 only
test7=`echo $CLIENT_FILENAME | grep "switch.bin$"`	# NH720/820/SDPTZ only
test8=`echo $CLIENT_FILENAME | grep "main.bin$"`	# NH720/820/SDPTZ only
test9=`echo $CLIENT_FILENAME | grep "module.bin$"`	# NH720/820 only
test10=`echo $CLIENT_FILENAME | grep "module.img$"`	# SDPTZ only

FILE_SIZE=`ls -la $FILENAME`
FILE_SIZE=`echo $FILE_SIZE | cut -d \  -f 5`


flag="0"

if [ "$test2" != "" ] 					#uImage
then
	key="a5s_uImage_new"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=0/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -k "$key" -r -o "/tmp/uImage" 1> /dev/null 2> /dev/null
		sync
	fi

elif [ "$test3" != "" ] 				#userland 
then
	key="a5s_userland_new"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=1/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/userland.img
		sync
	fi
	
elif [ "$test4" != "" ]					#var
then
	key="a5s_var"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null
	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=2/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -k "$key" -r -o "/tmp/temp" 1> /dev/null 2> /dev/null
		tar -xf /tmp/temp -C /tmp
		rm /tmp/temp
		mv /tmp/camtype /tmp/var
		sync
	else
		rm $FILENAME
	fi

elif [ "$test5" != "" ]					#uImage_userland
then
	key="a5s_uImage_userland_new"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null
	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=3/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/uImage_userland
		sync	
	else
		key="a5s_DoasIsay"
		/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null
		if [ "$?" = 0 ] ; then
			sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=8/' /etc/sysconfig/variable.conf
			# remove key
			/usr/sbin/checkFile -i "$FILENAME" -s 4
			mv $FILENAME /tmp/cmd_file
			# get cmd file size
			dd if=/tmp/cmd_file of=/tmp/cmdsize bs=100 count=1 1> /dev/null 2> /dev/null
			/usr/sbin/checkFile -i /tmp/cmd_file -s 100
			# get cmd file
			CMDSize=`grep < /tmp/cmdsize "CMDSize" | cut -d \= -f 2`
			dd if=/tmp/cmd_file of=/tmp/upgradecmd.sh bs=$CMDSize count=1 1> /dev/null 2> /dev/null
			# remove cmd file from bin
			/usr/sbin/checkFile -i /tmp/cmd_file -s $CMDSize
			mv /tmp/cmd_file /tmp/uImage_userland
		
			CheckOK1=`grep "#!/bin/sh" /tmp/upgradecmd.sh`	
			CheckOK2=`grep "#upgrading completed" /tmp/upgradecmd.sh`	
			if [ "$CheckOK1" != "" -a "$CheckOK2" != "" ] ; then	
				flag="1"
			fi
		fi
	fi

elif [ "$test6" != "" ] 				#mcu_bin
then
	key="a5s_mcu"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=4/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/mcu.bin
		sync
	fi

elif [ "$test7" != "" ] 				#switch_bin
then
	key="a5s_switch"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=4/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/switch.bin
		sync
	else
		/root/ambarellaVideoServer  1> /dev/null 2> /dev/null &	
	fi

elif [ "$test8" != "" ] 				#main_bin
then
	key="a5s_main"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=5/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/main.bin
		sync
	else
		/root/ambarellaVideoServer  1> /dev/null 2> /dev/null &	
	fi

elif [ "$test9" != "" ] 				#module_bin
then
	key="a5s_module"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=6/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/module.bin
		sync
	else
		key="a5s_module_param"
		/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

		if [ "$?" = 0 ] ; then
			flag="1"
			sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=7/' /etc/sysconfig/variable.conf
			/usr/sbin/checkFile -i "$FILENAME" -s 4
			mv $FILENAME /tmp/module.bin
			sync
		else
			/root/ambarellaVideoServer  1> /dev/null 2> /dev/null &	
		fi
	fi
elif [ "$test10" != "" ] 				#module_img	SDPTZ
then
	key="a5s_module"
	/usr/sbin/checkFile -i "$FILENAME" -k "$key" 1> /dev/null 2> /dev/null

	if [ "$?" = 0 ] ; then
		flag="1"
		sed -i '/Variable.Upgradefirmware/s/Upgradefirmware=./Upgradefirmware=7/' /etc/sysconfig/variable.conf
		/usr/sbin/checkFile -i "$FILENAME" -s 4
		mv $FILENAME /tmp/module.img
		sync
	else		
		/root/ambarellaVideoServer  1> /dev/null 2> /dev/null &	
	fi
fi

if [ "$flag" = "1" ]
then
cat << EOM
<html>
	<head></head>
	<script language="javascript">
	function load_page(){
		window.parent.centerframe.To_Step(3);
	}
	</script>
	<body onload="load_page()"></body>
<html>
EOM
else
		rm $FILENAME
		/usr/sbin/startstreamserver.sh 1> /dev/null 2> /dev/null
		/usr/sbin/sd_protect 1> /dev/null 2> /dev/null &
cat << EOM
<html>
	<head></head>
	<script language="javascript">
	function load_page(){
		window.parent.centerframe.upload_faile();
		window.parent.centerframe.To_Step(0);
	}
	</script>
	<body onload="load_page();"></body>
<html>
EOM
fi





