#!/bin/sh
INTERFACE=/mtd1/interfaces
echo "DM_post_proccess"
#killall -9 pppd
#killall -9 miniupnpd
#killall -9 inadyn
#killall -9 updatedd

TEST_DHCP=`grep < $INTERFACE "iface eth0 inet static"`
GETUPNPWORK=`grep "^root.Network.UPnP.Enabled" /mtd1/conf/network.conf | cut -d \= -f 2`
GETUPNPWORKPORTFOWARD=`grep "^root.Network.UPnP.NATTraversal.Enabled" /mtd1/conf/network.conf | cut -d \= -f 2`

if [ "$TEST_DHCP" != "" ]   #static IP
then
	sh /usr/sbin/network_set.sh dhcp 0
#	sed -i '6,8d' $INTERFACE
	IP=`grep < $INTERFACE "address"`
	GATEWAY=`grep < $INTERFACE "gateway"`
	NETMASK=`grep < $INTERFACE "netmask"`
#	DNS1=`grep < /etc/resolv.conf "nameserver" | sed -n '1p' | cut -d\  -f 2`
	IP=${IP##* }
	GATEWAY=${GATEWAY##* }
	NETMASK=${NETMASK##* }
	BCAST=`/bin/ipcalc $IP -m $NETMASK -b | grep BROADCAST | cut -d \= -f 2`
	echo $IP
	sh /usr/sbin/network_set.sh ip $IP
	sh /usr/sbin/network_set.sh gateway $GATEWAY
#	sh /usr/sbin/network_set.sh subnetmask $NETMASK
#	sh /usr/sbin/network_set.sh dns1 $DNS1

#	DNS2=`grep "root.Network.DNSServer2=" < /mtd1/conf/network.conf | cut -d \= -f 2`
#	sh /usr/sbin/network_set.sh dns2 $DNS2

	#Broadcast
	sed -i '/Network.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
	sed -i '/Network.eth0.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
	
#	sed -i '6c' /etc/network/interfaces
	
#	sed -i '7c' /etc/network/interfaces
	
#	sed -i '8c' /etc/network/interfaces
	
get_ip=`/sbin/ifconfig eth0 | grep 'inet addr' | sed 's/^.*addr://g' | sed 's/Bcast.*$//g'`
sh /usr/sbin/network_set.sh ip $get_ip
get_mask=`/sbin/ifconfig eth0 | grep 'inet addr' | sed 's/^.*Mask://g'`
sh /usr/sbin/network_set.sh subnetmask $get_mask

	sync
else			#DHCP

	cp /etc/network/interfaces.default $INTERFACE
	CONFIG_FILE="/mtd1/conf/network.conf"
	
	IP=`grep "^root.Network.IPAddress" < $CONFIG_FILE | cut -d \= -f 2`
	NETMASK=`grep "^root.Network.SubnetMask" < $CONFIG_FILE | cut -d \= -f 2`
	GATEWAY=`grep "^root.Network.Routing.DefaultRouter" < $CONFIG_FILE | cut -d \= -f 2`
#	BCAST=`ipcalc $IP -m $MASK -b | grep BROADCAST | cut -d \= -f 2` 

	#IP
	sed -i '/address/caddress '$IP'' $INTERFACE
	#NETMASK
	sed -i '/netmask/cnetmask '$NETMASK'' $INTERFACE
	#GATEWAY
	sed -i '/gateway/cgateway '$GATEWAY'' $INTERFACE
	#BROADCAST
	sed -i '/broadcast/cbroadcast '$BCAST $INTERFACE
	sync

	/usr/sbin/to_dhcp.sh 1

	sh /usr/sbin/network_set.sh dhcp 1
fi
killall -9 appweb
#/usr/sbin/onvifServer 1> /dev/null 2> /dev/null &

if [ "$GETUPNPWORK" = "yes" -a "$GETUPNPWORKPORTFOWARD" = "no" ] ; then
	/usr/sbin/miniupnpd -f /etc/upnp/miniupnpd.conf 1> /dev/null 2> /dev/null
elif [ "$GETUPNPWORK" = "1" -a "$GETUPNPWORKPORTFOWARD" = "1" ] ; then
	/usr/sbin/miniupnpd -f /etc/upnp/miniupnpd.conf -n 1> /dev/null 2> /dev/null
fi

READDDNSSTATUS=`grep "root.DDNS.Enabled=" /etc/sysconfig/ddns.conf | cut -d \= -f2`

if [ "$READDDNSSTATUS" = "yes" ]
then

	READDDNSPROVIDERCOMP=`grep "root.DDNS.Provider=" /etc/sysconfig/ddns.conf | cut -d \= -f2`
	READDDNSHOST=`grep "root.DDNS.Hostname=" /etc/sysconfig/ddns.conf | cut -d \= -f2`
	READDDNSUSERNAMEEMAIL=`grep "root.DDNS.Login=" /etc/sysconfig/ddns.conf | cut -d \= -f2`
	READDDNSPASSWORDKEY=`grep "root.DDNS.Password=" /etc/sysconfig/ddns.conf | cut -d \= -f2`

	if [ "$READDDNSPROVIDERCOMP" = "1" ]
	then
		echo "dyndns dynamic"
		/usr/sbin/inadyn --dyndns_system dyndns@dyndns.org -u $READDDNSUSERNAMEEMAIL -p $READDDNSPASSWORDKEY -a $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "2" ]
	then
		echo "dyndns custom"
		/usr/sbin/inadyn --dyndns_system custom@dyndns.org -u $READDDNSUSERNAMEEMAIL -p $READDDNSPASSWORDKEY -a $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "3" ]
	then
		echo "No-IP"
		/usr/sbin/updatedd -Y noip $READDDNSUSERNAMEEMAIL:$READDDNSPASSWORDKEY $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "4" ]
	then
		echo "ChangeIP"
		/usr/sbin/updatedd -Y changeip $READDDNSUSERNAMEEMAIL:$READDDNSPASSWORDKEY $READDDNSHOST &
	fi
fi

killall -9 appWeb

