#!bin/sh

INTERFACE=/mtd1/interfaces

CHOICE=$1
VALUE=$2

case $CHOICE in
dhcp)
	if [ $VALUE = 1 ]
	then
		sed -i '/Network.BootProto/s/BootProto=.*/BootProto=dhcp/' /mtd1/conf/network.conf
	elif [ $VALUE = 2 ]
	then
		sed -i '/Network.BootProto/s/BootProto=.*/BootProto=pppoe/' /mtd1/conf/network.conf
	else
		sed -i '/Network.BootProto/s/BootProto=.*/BootProto=none/' /mtd1/conf/network.conf
	fi

	;;
ip)
		sed -i '/address/caddress '$VALUE'' $INTERFACE
		sed -i '/Network.IPAddress/s/IPAddress=.*/IPAddress='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Network.eth0.IPAddress/s/IPAddress=.*/IPAddress='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Host IP =/s/Host IP = .*/Host IP = '$VALUE'/' /tmp/access.log
	;;
port)
		INPUT1=47cListen
		INPUT2=$VALUE
		sed -i "$INPUT1 $INPUT2" /etc/appWeb/appweb.conf
		echo "$VALUE" > /etc/Port
		sed -i '/Network.Port/s/Port=.*/Port='$VALUE'/' /mtd1/conf/network.conf
	;;
rtspport)
		sed -i '/RTSP.Port/s/Port=.*/Port='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/rtspport/s/rtspport=.*/rtspport='$VALUE'/' /home/nessy2/StreamingServer/StreamServer.conf
	;;
jpegoverhttpport)
		sed -i '/HTTP.MjpegPort/s/MjpegPort=.*/MjpegPort='$VALUE'/' /mtd1/conf/network.conf
		sed -i "s/^port=.*/port=$VALUE/g" /home/nessy2/StreamingServer/StreamServer.conf
	;;
httpsport)
		sed -i '/HTTPS.Port/s/Port=.*/Port='$VALUE'/' /etc/sysconfig/https.conf
		INPUT1=52cListen
		INPUT2=$VALUE
		sed -i "$INPUT1 $INPUT2" /etc/appWeb/appWeb.conf
		INPUT1=311c\<VirtualHost
		INPUT2="*:"
		INPUT3=$VALUE
		INPUT4=">"
		sed -i "$INPUT1 $INPUT2$INPUT3$INPUT4" /etc/appWeb/appWeb.conf		
	;;	
subnetmask)
		sed -i '/netmask/cnetmask '$VALUE'' $INTERFACE
		sed -i '/Network.SubnetMask/s/SubnetMask=.*/SubnetMask='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Network.eth0.SubnetMask/s/SubnetMask=.*/SubnetMask='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Subnet Mask =/s/Subnet Mask .*/Subnet Mask = '$VALUE'/' /tmp/access.log
	;;
gateway)
		sed -i '/gateway/cgateway '$VALUE'' $INTERFACE
		sed -i '/Network.DefaultRouter/s/DefaultRouter=.*/DefaultRouter='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Network.Routing.DefaultRouter/s/DefaultRouter=.*/DefaultRouter='$VALUE'/' /mtd1/conf/network.conf
		sed -i '/Gateway =/s/Gateway = .*/Gateway = '$VALUE'/' /tmp/access.log
	;;
dns2)
		DNS2=`grep "^root.Network.DNSServer2=" /mtd1/conf/network.conf | cut -d \= -f 2`
		echo "nameserver $VALUE" > /etc/resolv.conf
		echo "nameserver $DNS2" >> /etc/resolv.conf

		sed -i '/Network.DNSServer2/s/DNSServer2=.*/DNSServer2='$VALUE'/' /mtd1/conf/network.conf
	;;
dns1)
		DNS1=`grep "^root.Network.DNSServer1=" /mtd1/conf/network.conf | cut -d \= -f 2`
		echo "nameserver $DNS1" > /etc/resolv.conf
		echo "nameserver $VALUE" >> /etc/resolv.conf

		sed -i '/Network.DNSServer1/s/DNSServer1=.*/DNSServer1='$VALUE'/' /mtd1/conf/network.conf
	;;
pppoeusername)
		PPP_PASSWORD=`grep "^root.Network.PPPoE.Password=" /mtd1/conf/network.conf | cut -d \= -f 2`
		sed -i '/Network.PPPoE.UserName/s/UserName=.*/UserName='"$VALUE"'/' /mtd1/conf/network.conf
		sed -i '3c'$VALUE' \* '$PPP_PASSWORD /etc/ppp/pap-secrets
		sed -i '3c'$VALUE' \* '$PPP_PASSWORD /etc/ppp/chap-secrets		
		sed -i '/name/s/name.*/name \"'"$VALUE"'\"/' /etc/ppp/peers/your_provider
	;;
pppoepassword)
		PPP_USERNAME=`grep "^root.Network.PPPoE.UserName=" /mtd1/conf/network.conf | cut -d \= -f 2`
		sed -i '/Network.PPPoE.Password/s/Password=.*/Password='"$VALUE"'/' /mtd1/conf/network.conf
		sed -i '3c'$PPP_USERNAME' \* '$VALUE /etc/ppp/pap-secrets
		sed -i '3c'$PPP_USERNAME' \* '$VALUE /etc/ppp/chap-secrets		
	;;
rtsp_jpeg_accessname)
		sed -i '/jpeg_url/s/jpeg_url=.*/jpeg_url='$VALUE'/' /home/nessy2/StreamingServer/StreamServer.conf
	;;
rtsp_h264_accessname)
		sed -i '/h264_url/s/h264_url=.*/h264_url='$VALUE'/' /home/nessy2/StreamingServer/StreamServer.conf
	;;
rtsp_h264_2_accessname)
		sed -i '/h264_2_url/s/h264_2_url=.*/h264_2_url='$VALUE'/' /home/nessy2/StreamingServer/StreamServer.conf
	;;
rtsp_h264_3_accessname)
		sed -i '/h264_3_url/s/h264_3_url=.*/h264_3_url='$VALUE'/' /home/nessy2/StreamingServer/StreamServer.conf
	;;
	
			
esac
sync
