#!/bin/sh

option=$1


#edited /etc/network.conf	used when someone use device search to changed IP Cam setting to DHCP
				#or someone use API to changed IP protocol


if [ "$option" = 0 ] ; then	#static IP
	
	IP=`grep "^root.Network.eth0.IPAddress=" < /etc/sysconfig/network.conf | cut -d \= -f2`
	MASK=`grep "^root.Network.eth0.SubnetMask=" < /etc/sysconfig/network.conf | cut -d \= -f2`
	GATEWAY=`grep "^root.Network.Routing.DefaultRouter=" < /etc/sysconfig/network.conf | cut -d \= -f2`
	DNS1=`grep "^root.Network.DNSServer1=" < /etc/sysconfig/network.conf | cut -d \= -f2`
	DNS2=`grep "^root.Network.DNSServer2=" < /etc/sysconfig/network.conf | cut -d \= -f2`	
	BCAST=`ipcalc $IP -m $MASK -b | grep BROADCAST | cut -d \= -f 2` 

	echo "nameserver $DNS1" > /etc/resolv.conf
	echo "nameserver $DNS2" >> /etc/resolv.conf


else	#DHCP
	DNS1=`grep "^nameserver" < /etc/resolv.conf | head -n 1 | cut -d \  -f2`
	DNS2=`grep "^nameserver" < /etc/resolv.conf | head -n 2 | tail -n 1 | cut -d \  -f 2`

	IFCONFIG=`ifconfig eth0`
	IP=`echo $IFCONFIG | cut -d \: -f 8`
	IP=`echo $IP | cut -d \  -f 1`
	BCAST=`echo $IFCONFIG | cut -d \: -f 9 | cut -d \  -f 1`
	MASK=`echo $IFCONFIG | cut -d \: -f 10`
	MASK=`echo $MASK | cut -d \  -f 1`

	ROUTE=`route -n | grep "^0.0.0.0"`
	GATEWAY=`echo $ROUTE | cut -d \  -f 2`
fi
sed -i '/Host IP =/s/Host IP = .*/Host IP = '$IP'/' /tmp/access.log
sed -i '/Network.IPAddress/s/IPAddress=.*/IPAddress='$IP'/' /etc/sysconfig/network.conf
sed -i '/Network.eth0.IPAddress/s/IPAddress=.*/IPAddress='$IP'/' /etc/sysconfig/network.conf
sed -i '/Network.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /etc/sysconfig/network.conf
sed -i '/Network.eth0.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /etc/sysconfig/network.conf
sed -i '/Network.SubnetMask/s/SubnetMask=.*/SubnetMask='$MASK'/' /etc/sysconfig/network.conf
sed -i '/Subnet Mask =/s/Subnet Mask .*/Subnet Mask = '$MASK'/' /tmp/access.log
sed -i '/Network.DefaultRouter/s/DefaultRouter=.*/DefaultRouter='$GATEWAY'/' /etc/sysconfig/network.conf
sed -i '/Network.Routing.DefaultRouter/s/DefaultRouter=.*/DefaultRouter='$GATEWAY'/' /etc/sysconfig/network.conf
sed -i '/Network.DNSServer1/s/DNSServer1=.*/DNSServer1='$DNS1'/' /etc/sysconfig/network.conf
sed -i '/Network.DNSServer2/s/DNSServer2=.*/DNSServer2='$DNS2'/' /etc/sysconfig/network.conf
sync
