/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateChooserDialog
extends Dialog {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private static Point sLastSize;
    private boolean mCompleted;
    private final Map<Archive, Archive> mNewToOldArchiveMap;
    private boolean mLicenseAcceptAll;
    private boolean mInternalLicenseRadioUpdate;
    private HashSet<Archive> mAccepted = new HashSet();
    private HashSet<Archive> mRejected = new HashSet();
    private ArrayList<Archive> mResult = new ArrayList();
    private Shell mDialogShell;
    private SashForm mSashForm;
    private Composite mPackageRootComposite;
    private Button mCancelButton;
    private Button mInstallButton;
    private TableViewer mTableViewPackage;
    private Table mTablePackage;
    private TableColumn mTableColum;
    private StyledText mPackageText;
    private Button mLicenseRadioAccept;
    private Button mLicenseRadioReject;
    private Button mLicenseRadioAcceptAll;
    private Group mPackageTextGroup;
    private final UpdaterData mUpdaterData;
    private Group mTableGroup;

    public UpdateChooserDialog(Shell parentShell, UpdaterData updaterData, Map<Archive, Archive> newToOldUpdates) {
        super(parentShell, 65536);
        this.mUpdaterData = updaterData;
        this.mNewToOldArchiveMap = new TreeMap<Archive, Archive>(new Comparator<Archive>(){

            @Override
            public int compare(Archive a1, Archive a2) {
                String desc1 = a1.getParentPackage().getShortDescription();
                String desc2 = a2.getParentPackage().getShortDescription();
                return desc1.compareTo(desc2);
            }
        });
        this.mNewToOldArchiveMap.putAll(newToOldUpdates);
    }

    public Collection<Archive> getResult() {
        return this.mResult;
    }

    public void open() {
        this.createContents();
        this.positionShell();
        this.mDialogShell.open();
        this.mDialogShell.layout();
        this.postCreate();
        Display display = this.getParent().getDisplay();
        while (!this.mDialogShell.isDisposed() && !this.mCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.close();
        }
    }

    private void createContents() {
        this.mDialogShell = new Shell(this.getParent(), 3312);
        this.mDialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                UpdateChooserDialog.this.onShellClosed(e);
            }
        });
        this.mDialogShell.setLayout((Layout)new GridLayout(3, false));
        this.mDialogShell.setSize(600, 400);
        this.mDialogShell.setText("Choose Packages to Install");
        this.mSashForm = new SashForm((Composite)this.mDialogShell, 0);
        this.mSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTableGroup = new Group((Composite)this.mSashForm, 0);
        this.mTableGroup.setText("Packages");
        this.mTableGroup.setLayout((Layout)new GridLayout(1, false));
        this.mTableViewPackage = new TableViewer((Composite)this.mTableGroup, 2564);
        this.mTablePackage = this.mTableViewPackage.getTable();
        this.mTablePackage.setHeaderVisible(false);
        this.mTablePackage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mTablePackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageDoubleClick();
            }
        });
        this.mTableColum = new TableColumn(this.mTablePackage, 0);
        this.mTableColum.setWidth(100);
        this.mTableColum.setText("Packages");
        this.mPackageRootComposite = new Composite((Composite)this.mSashForm, 0);
        this.mPackageRootComposite.setLayout((Layout)new GridLayout(4, false));
        this.mPackageRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mPackageTextGroup = new Group(this.mPackageRootComposite, 0);
        this.mPackageTextGroup.setText("Package Description && License");
        this.mPackageTextGroup.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.mPackageTextGroup.setLayout((Layout)new GridLayout(1, false));
        this.mPackageText = new StyledText((Composite)this.mPackageTextGroup, 586);
        this.mPackageText.setBackground(this.getParent().getDisplay().getSystemColor(22));
        this.mPackageText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLicenseRadioAccept = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAccept.setText("Accept");
        this.mLicenseRadioAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mLicenseRadioReject = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioReject.setText("Reject");
        this.mLicenseRadioReject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        Label placeholder = new Label(this.mPackageRootComposite, 0);
        placeholder.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mLicenseRadioAcceptAll = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAcceptAll.setText("Accept All");
        this.mLicenseRadioAcceptAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mSashForm.setWeights(new int[]{200, 300});
        placeholder = new Label((Composite)this.mDialogShell, 0);
        placeholder.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        if (SdkConstants.currentPlatform() == 3) {
            this.mCancelButton = new Button((Composite)this.mDialogShell, 8);
        }
        this.mInstallButton = new Button((Composite)this.mDialogShell, 8);
        this.mInstallButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mInstallButton.setText("Install Accepted");
        this.mInstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onInstallSelected();
            }
        });
        if (this.mCancelButton == null) {
            this.mCancelButton = new Button((Composite)this.mDialogShell, 8);
        }
        this.mCancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onCancelSelected();
            }
        });
    }

    private void postCreate() {
        this.setWindowImage();
        for (Archive a : this.mNewToOldArchiveMap.keySet()) {
            String license = a.getParentPackage().getLicense();
            if (license != null) {
                if ((license = license.trim()).length() != 0) continue;
                this.mAccepted.add(a);
                continue;
            }
            this.mAccepted.add(a);
        }
        this.mTableViewPackage.setLabelProvider((IBaseLabelProvider)new NewArchivesLabelProvider());
        this.mTableViewPackage.setContentProvider((IContentProvider)new NewArchivesContentProvider());
        this.mTableViewPackage.setInput(this.mNewToOldArchiveMap);
        this.adjustColumnsWidth();
        this.mTablePackage.select(0);
        this.onPackageSelected();
    }

    private void setWindowImage() {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imgFactory = this.mUpdaterData.getImageFactory()) != null) {
            this.mDialogShell.setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = UpdateChooserDialog.this.mTablePackage.getClientArea();
                UpdateChooserDialog.this.mTableColum.setWidth(r.width);
            }
        };
        this.mTablePackage.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    private void onShellClosed(ShellEvent e) {
        sLastSize = this.mDialogShell.getSize();
    }

    private void positionShell() {
        Shell child = this.mDialogShell;
        Shell parent = this.getParent();
        if (child != null && parent != null) {
            Rectangle parentArea = parent.getClientArea();
            Point parentLoc = parent.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = sLastSize != null ? sLastSize : child.getSize();
            int cw = childSize.x;
            int ch = childSize.y;
            int x = px + (pw - cw) / 2;
            int y = py + (ph - ch) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < MIN_Y) {
                y = MIN_Y;
            }
            child.setLocation(x, y);
            child.setSize(cw, ch);
        }
    }

    private void onInstallSelected() {
        this.mResult.addAll(this.mAccepted);
        this.mCompleted = true;
    }

    private void onCancelSelected() {
        this.mCompleted = true;
    }

    private void onPackageSelected() {
        Archive a = this.getSelectedArchive();
        this.displayInformation(a);
        this.updateLicenceRadios(a);
    }

    private Archive getSelectedArchive() {
        Object elem;
        ISelection sel = this.mTableViewPackage.getSelection();
        if (sel instanceof IStructuredSelection && (elem = ((IStructuredSelection)sel).getFirstElement()) instanceof Archive) {
            return (Archive)elem;
        }
        return null;
    }

    private void displayInformation(Archive a) {
        if (a == null) {
            this.mPackageText.setText("Please select a package.");
            return;
        }
        this.mPackageText.setText("");
        this.addSectionTitle("Package Description\n");
        this.addText(a.getParentPackage().getLongDescription(), "\n\n");
        Archive aold = this.mNewToOldArchiveMap.get(a);
        if (aold != null) {
            this.addText(String.format("This update will replace revision %1$s with revision %2$s.\n\n", aold.getParentPackage().getRevision(), a.getParentPackage().getRevision()));
        }
        this.addSectionTitle("Archive Description\n");
        this.addText(a.getLongDescription(), "\n\n");
        String license = a.getParentPackage().getLicense();
        if (license != null) {
            this.addSectionTitle("License\n");
            this.addText(license.trim(), "\n");
        }
    }

    private void addText(String ... string) {
        for (String s : string) {
            this.mPackageText.append(s);
        }
    }

    private void addSectionTitle(String string) {
        String s = this.mPackageText.getText();
        int start = s == null ? 0 : s.length();
        this.mPackageText.append(string);
        StyleRange sr = new StyleRange();
        sr.start = start;
        sr.length = string.length();
        sr.fontStyle = 1;
        sr.underline = true;
        this.mPackageText.setStyleRange(sr);
    }

    private void updateLicenceRadios(Archive a) {
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        if (this.mLicenseAcceptAll) {
            this.mLicenseRadioAcceptAll.setSelection(true);
            this.mLicenseRadioAccept.setSelection(false);
            this.mLicenseRadioReject.setSelection(false);
        } else {
            this.mLicenseRadioAcceptAll.setSelection(false);
            this.mLicenseRadioAccept.setSelection(this.mAccepted.contains(a));
            this.mLicenseRadioReject.setSelection(this.mRejected.contains(a));
        }
        this.mInstallButton.setEnabled(this.mAccepted.size() > 0);
        this.mInternalLicenseRadioUpdate = false;
    }

    private void onLicenseRadioSelected() {
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        Archive a = this.getSelectedArchive();
        boolean needUpdate = true;
        if (!this.mLicenseAcceptAll && this.mLicenseRadioAcceptAll.getSelection()) {
            this.mLicenseAcceptAll = true;
            this.mAccepted.addAll(this.mNewToOldArchiveMap.keySet());
            this.mRejected.clear();
        } else if (this.mLicenseRadioAccept.getSelection()) {
            this.mLicenseAcceptAll = false;
            this.mAccepted.add(a);
            this.mRejected.remove(a);
        } else if (this.mLicenseRadioReject.getSelection()) {
            this.mLicenseAcceptAll = false;
            this.mAccepted.remove(a);
            this.mRejected.add(a);
        } else {
            needUpdate = false;
        }
        this.mInternalLicenseRadioUpdate = false;
        if (needUpdate) {
            if (this.mLicenseAcceptAll) {
                this.mTableViewPackage.refresh();
            } else {
                this.mTableViewPackage.refresh((Object)a);
            }
            this.updateLicenceRadios(a);
        }
    }

    private void onPackageDoubleClick() {
        Archive a = this.getSelectedArchive();
        if (this.mAccepted.contains(a)) {
            this.mAccepted.remove(a);
            this.mRejected.add(a);
        } else {
            this.mAccepted.add(a);
            this.mRejected.remove(a);
        }
        this.mLicenseAcceptAll = false;
        this.mTableViewPackage.refresh((Object)a);
        this.updateLicenceRadios(a);
    }

    private class NewArchivesContentProvider
    implements IStructuredContentProvider {
        private NewArchivesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return UpdateChooserDialog.this.mNewToOldArchiveMap.keySet().toArray();
        }
    }

    private class NewArchivesLabelProvider
    extends LabelProvider {
        private NewArchivesLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageFactory imgFactory = UpdateChooserDialog.this.mUpdaterData.getImageFactory();
            if (imgFactory != null) {
                if (UpdateChooserDialog.this.mAccepted.contains(element)) {
                    return imgFactory.getImageByName("accept_icon16.png");
                }
                if (UpdateChooserDialog.this.mRejected.contains(element)) {
                    return imgFactory.getImageByName("reject_icon16.png");
                }
                return imgFactory.getImageByName("unknown_icon16.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Archive) {
                return ((Archive)element).getParentPackage().getShortDescription();
            }
            return super.getText(element);
        }
    }
}

