/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkbuilder.internal;

import com.android.apkbuilder.ApkBuilder;
import com.android.jarutils.DebugKeyProvider;
import com.android.jarutils.JavaResourceFilter;
import com.android.jarutils.SignedJarBuilder;
import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApkBuilderImpl {
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);
    private static final Pattern PATTERN_NATIVELIB_EXT = Pattern.compile("^.+\\.so$", 2);
    private static final String NATIVE_LIB_ROOT = "lib/";
    private JavaResourceFilter mResourceFilter = new JavaResourceFilter();
    private boolean mVerbose = false;
    private boolean mSignedPackage = true;
    private String mStoreType = null;

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setSignedPackage(boolean signedPackage) {
        this.mSignedPackage = signedPackage;
    }

    public void run(String[] args) throws ApkBuilder.WrongOptionException, FileNotFoundException, ApkBuilder.ApkCreationException {
        if (args.length < 1) {
            throw new ApkBuilder.WrongOptionException("No options specified");
        }
        File outFile = this.getOutFile(args[0]);
        ArrayList<FileInputStream> zipArchives = new ArrayList<FileInputStream>();
        ArrayList<File> archiveFiles = new ArrayList<File>();
        ArrayList<ApkFile> javaResources = new ArrayList<ApkFile>();
        ArrayList<FileInputStream> resourcesJars = new ArrayList<FileInputStream>();
        ArrayList<ApkFile> nativeLibraries = new ArrayList<ApkFile>();
        int index = 1;
        do {
            String argument;
            if ("-v".equals(argument = args[index++])) {
                this.mVerbose = true;
                continue;
            }
            if ("-u".equals(argument)) {
                this.mSignedPackage = false;
                continue;
            }
            if ("-z".equals(argument)) {
                if (index == args.length) {
                    throw new ApkBuilder.WrongOptionException("Missing value for -z");
                }
                try {
                    FileInputStream input = new FileInputStream(args[index++]);
                    zipArchives.add(input);
                }
                catch (FileNotFoundException e) {
                    throw new ApkBuilder.ApkCreationException("-z file is not found");
                }
            } else {
                if ("-f".equals(argument)) {
                    if (index == args.length) {
                        throw new ApkBuilder.WrongOptionException("Missing value for -f");
                    }
                    archiveFiles.add(ApkBuilderImpl.getInputFile(args[index++]));
                    continue;
                }
                if ("-rf".equals(argument)) {
                    if (index == args.length) {
                        throw new ApkBuilder.WrongOptionException("Missing value for -rf");
                    }
                    ApkBuilderImpl.processSourceFolderForResource(args[index++], javaResources);
                    continue;
                }
                if ("-rj".equals(argument)) {
                    if (index == args.length) {
                        throw new ApkBuilder.WrongOptionException("Missing value for -rj");
                    }
                    ApkBuilderImpl.processJarFolder(args[index++], resourcesJars);
                    continue;
                }
                if ("-nf".equals(argument)) {
                    if (index == args.length) {
                        throw new ApkBuilder.WrongOptionException("Missing value for -nf");
                    }
                    String parameter = args[index++];
                    File f = new File(parameter);
                    int offset = parameter.length();
                    if (!parameter.endsWith(File.separator)) {
                        ++offset;
                    }
                    ApkBuilderImpl.processNativeFolder(offset, f, nativeLibraries);
                    continue;
                }
                if ("-storetype".equals(argument)) {
                    if (index == args.length) {
                        throw new ApkBuilder.WrongOptionException("Missing value for -storetype");
                    }
                    this.mStoreType = args[index++];
                    continue;
                }
                throw new ApkBuilder.WrongOptionException("Unknown argument: " + argument);
            }
        } while (index < args.length);
        this.createPackage(outFile, zipArchives, archiveFiles, javaResources, resourcesJars, nativeLibraries);
    }

    private File getOutFile(String filepath) throws ApkBuilder.ApkCreationException {
        File f = new File(filepath);
        if (f.isDirectory()) {
            throw new ApkBuilder.ApkCreationException(filepath + " is a directory!");
        }
        if (f.exists()) {
            if (!f.canWrite()) {
                throw new ApkBuilder.ApkCreationException("Cannot write " + filepath);
            }
        } else {
            try {
                if (!f.createNewFile()) {
                    throw new ApkBuilder.ApkCreationException("Failed to create " + filepath);
                }
            }
            catch (IOException e) {
                throw new ApkBuilder.ApkCreationException("Failed to create '" + filepath + "' : " + e.getMessage());
            }
        }
        return f;
    }

    public static File getInputFile(String filepath) throws ApkBuilder.ApkCreationException {
        File f = new File(filepath);
        if (f.isDirectory()) {
            throw new ApkBuilder.ApkCreationException(filepath + " is a directory!");
        }
        if (f.exists()) {
            if (!f.canRead()) {
                throw new ApkBuilder.ApkCreationException("Cannot read " + filepath);
            }
        } else {
            throw new ApkBuilder.ApkCreationException(filepath + " does not exists!");
        }
        return f;
    }

    public static void processSourceFolderForResource(String folderPath, ArrayList<ApkFile> javaResources) throws ApkBuilder.ApkCreationException {
        File folder = new File(folderPath);
        if (folder.isDirectory()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                ApkBuilderImpl.processFileForResource(file, null, javaResources);
            }
        } else {
            if (folder.exists()) {
                throw new ApkBuilder.ApkCreationException(folderPath + " is not a folder!");
            }
            throw new ApkBuilder.ApkCreationException(folderPath + " does not exist!");
        }
    }

    public static void processJarFolder(String parameter, Collection<FileInputStream> resourcesJars) throws FileNotFoundException {
        File f = new File(parameter);
        if (f.isDirectory()) {
            String[] files;
            for (String file : files = f.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return PATTERN_JAR_EXT.matcher(name).matches();
                }
            })) {
                String path = f.getAbsolutePath() + File.separator + file;
                FileInputStream input = new FileInputStream(path);
                resourcesJars.add(input);
            }
        } else {
            FileInputStream input = new FileInputStream(parameter);
            resourcesJars.add(input);
        }
    }

    private static void processFileForResource(File file, String path, Collection<ApkFile> javaResources) {
        if (file.isDirectory()) {
            if (JavaResourceFilter.checkFolderForPackaging((String)file.getName())) {
                File[] files;
                path = path == null ? file.getName() : path + "/" + file.getName();
                for (File contentFile : files = file.listFiles()) {
                    ApkBuilderImpl.processFileForResource(contentFile, path, javaResources);
                }
            }
        } else if (JavaResourceFilter.checkFileForPackaging((String)file.getName())) {
            path = path == null ? file.getName() : path + "/" + file.getName();
            javaResources.add(new ApkFile(file, path));
        }
    }

    public static void processNativeFolder(int offset, File f, Collection<ApkFile> nativeLibraries) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    ApkBuilderImpl.processNativeFolder(offset, child, nativeLibraries);
                }
            }
        } else if (f.isFile() && PATTERN_NATIVELIB_EXT.matcher(f.getName()).matches()) {
            String path = NATIVE_LIB_ROOT + f.getAbsolutePath().substring(offset).replace('\\', '/');
            nativeLibraries.add(new ApkFile(f, path));
        }
    }

    public void createPackage(File outFile, Iterable<? extends FileInputStream> zipArchives, Iterable<? extends File> files, Iterable<? extends ApkFile> javaResources, Iterable<? extends FileInputStream> resourcesJars, Iterable<? extends ApkFile> nativeLibraries) throws ApkBuilder.ApkCreationException {
        try {
            SignedJarBuilder builder;
            if (this.mSignedPackage) {
                System.err.println(String.format("Using keystore: %s", DebugKeyProvider.getDefaultKeyStoreOsPath()));
                DebugKeyProvider keyProvider = new DebugKeyProvider(null, this.mStoreType, null);
                PrivateKey privateKey = keyProvider.getDebugKey();
                X509Certificate certificate = (X509Certificate)keyProvider.getCertificate();
                if (privateKey == null) {
                    throw new ApkBuilder.ApkCreationException("Unable to get debug signature key");
                }
                if (certificate != null && certificate.getNotAfter().compareTo(new Date()) < 0) {
                    throw new ApkBuilder.ApkCreationException("Debug Certificate expired on " + DateFormat.getInstance().format(certificate.getNotAfter()));
                }
                builder = new SignedJarBuilder((OutputStream)new FileOutputStream(outFile.getAbsolutePath(), false), privateKey, certificate);
            } else {
                builder = new SignedJarBuilder((OutputStream)new FileOutputStream(outFile.getAbsolutePath(), false), null, null);
            }
            for (FileInputStream fileInputStream : zipArchives) {
                builder.writeZip((InputStream)fileInputStream, null);
            }
            for (File file : files) {
                builder.writeFile(file, file.getName());
                if (!this.mVerbose) continue;
                System.err.println(String.format("%1$s => %2$s", file.getAbsolutePath(), file.getName()));
            }
            for (ApkFile apkFile : javaResources) {
                builder.writeFile(apkFile.file, apkFile.archivePath);
                if (!this.mVerbose) continue;
                System.err.println(String.format("%1$s => %2$s", apkFile.file.getAbsolutePath(), apkFile.archivePath));
            }
            for (FileInputStream fileInputStream : resourcesJars) {
                builder.writeZip((InputStream)fileInputStream, (SignedJarBuilder.IZipEntryFilter)this.mResourceFilter);
            }
            for (ApkFile apkFile : nativeLibraries) {
                builder.writeFile(apkFile.file, apkFile.archivePath);
                if (!this.mVerbose) continue;
                System.err.println(String.format("%1$s => %2$s", apkFile.file.getAbsolutePath(), apkFile.archivePath));
            }
            builder.close();
        }
        catch (DebugKeyProvider.KeytoolException e) {
            if (e.getJavaHome() == null) {
                throw new ApkBuilder.ApkCreationException(e.getMessage() + "\nJAVA_HOME seems undefined, setting it will help locating keytool automatically\n" + "You can also manually execute the following command\n:" + e.getCommandLine());
            }
            throw new ApkBuilder.ApkCreationException(e.getMessage() + "\nJAVA_HOME is set to: " + e.getJavaHome() + "\nUpdate it if necessary, or manually execute the following command:\n" + e.getCommandLine());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw new ApkBuilder.ApkCreationException(e);
        }
        catch (Exception e) {
            throw new ApkBuilder.ApkCreationException(e);
        }
    }

    public static final class ApkFile {
        String archivePath;
        File file;

        ApkFile(File file, String path) {
            this.file = file;
            this.archivePath = path;
        }
    }
}

