/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager;

import com.android.sdklib.ISdkLog;
import java.util.HashMap;
import java.util.Map;

public class CommandLineProcessor {
    public static final String GLOBAL_FLAG_VERB = "@@internal@@";
    public static final String NO_VERB_OBJECT = "";
    public static final String KEY_HELP = "help";
    public static final String KEY_VERBOSE = "verbose";
    public static final String KEY_SILENT = "silent";
    private String mVerbRequested;
    private String mDirectObjectRequested;
    private final String[][] mActions;
    private static final int ACTION_VERB_INDEX = 0;
    private static final int ACTION_OBJECT_INDEX = 1;
    private static final int ACTION_DESC_INDEX = 2;
    private static final int ACTION_ALT_OBJECT_INDEX = 3;
    private final HashMap<String, Arg> mArguments = new HashMap();
    private final ISdkLog mLog;

    public CommandLineProcessor(ISdkLog logger, String[][] actions) {
        this.mLog = logger;
        this.mActions = actions;
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "v", KEY_VERBOSE, "Verbose mode: errors, warnings and informational messages are printed.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "s", KEY_SILENT, "Silent mode: only errors are printed out.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "h", KEY_HELP, "This help.", false);
    }

    public boolean acceptLackOfVerb() {
        return false;
    }

    public boolean isVerbose() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_VERBOSE);
    }

    public boolean isSilent() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_SILENT);
    }

    public boolean isHelpRequested() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_HELP);
    }

    public String getVerb() {
        return this.mVerbRequested;
    }

    public String getDirectObject() {
        return this.mDirectObjectRequested;
    }

    public Object getValue(String verb, String directObject, String longFlagName) {
        if (verb != null && directObject != null) {
            String key = verb + "/" + directObject + "/" + longFlagName;
            Arg arg = this.mArguments.get(key);
            return arg.getCurrentValue();
        }
        Object lastDefault = null;
        for (Arg arg : this.mArguments.values()) {
            if (!arg.getLongArg().equals(longFlagName) || verb != null && !arg.getVerb().equals(verb) || directObject != null && !arg.getDirectObject().equals(directObject)) continue;
            if (arg.isInCommandLine()) {
                return arg.getCurrentValue();
            }
            if (arg.getCurrentValue() == null) continue;
            lastDefault = arg.getCurrentValue();
        }
        return lastDefault;
    }

    protected void setValue(String verb, String directObject, String longFlagName, Object value) {
        String key = verb + "/" + directObject + "/" + longFlagName;
        Arg arg = this.mArguments.get(key);
        arg.setCurrentValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseArgs(String[] args) {
        block26: {
            needsHelp = null;
            verb = null;
            directObject = null;
            try {
                n = args.length;
                i = 0;
lbl7:
                // 2 sources

                while (i < n) {
                    arg = null;
                    a = args[i];
                    if (a.startsWith("--")) {
                        arg = this.findLongArg(verb, directObject, a.substring(2));
                    } else if (a.startsWith("-")) {
                        arg = this.findShortArg(verb, directObject, a.substring(1));
                    }
                    if (arg != null) ** GOTO lbl-1000
                    if (!a.startsWith("-")) ** GOTO lbl-1000
                    if (verb == null || directObject == null) {
                        needsHelp = String.format("Flag '%1$s' is not a valid global flag. Did you mean to specify it after the verb/object name?", new Object[]{a});
                        if (needsHelp == null) return;
                        this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                        return;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl82
            }
            catch (Throwable var13_22) {
                if (needsHelp == null) throw var13_22;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                throw var13_22;
            }
lbl-1000:
            // 1 sources

            {
                needsHelp = String.format("Flag '%1$s' is not valid for '%2$s %3$s'.", new Object[]{a, verb, directObject});
                if (needsHelp == null) return;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                return;
            }
lbl-1000:
            // 1 sources

            {
                if (verb != null) ** GOTO lbl-1000
                for (String[] actionDesc : this.mActions) {
                    if (!actionDesc[0].equals(a)) continue;
                    verb = a;
                    break;
                }
                if (verb == null) {
                    needsHelp = String.format("Expected verb after global parameters but found '%1$s' instead.", new Object[]{a});
                    if (needsHelp == null) return;
                    this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                    return;
                }
                ** GOTO lbl-1000
            }
lbl-1000:
            // 1 sources

            {
                if (directObject == null) {
                    for (String[] actionDesc : this.mActions) {
                        if (!actionDesc[0].equals(verb)) continue;
                        if (actionDesc[1].equals(a)) {
                            directObject = a;
                            break;
                        }
                        if (actionDesc.length <= 3 || !actionDesc[3].equals(a)) continue;
                        directObject = actionDesc[1];
                        break;
                    }
                    if (directObject == null) {
                        needsHelp = String.format("Expected verb after global parameters but found '%1$s' instead.", new Object[]{a});
                        if (needsHelp == null) return;
                        this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                        return;
                    }
                }
                ** GOTO lbl-1000
            }
lbl-1000:
            // 1 sources

            {
                if (arg == null) ** GOTO lbl-1000
                arg.setInCommandLine(true);
                error = null;
                if (!arg.getMode().needsExtra()) ** GOTO lbl69
                if (++i < n) ** GOTO lbl-1000
                needsHelp = String.format("Missing argument for flag %1$s.", new Object[]{a});
                if (needsHelp == null) return;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                return;
            }
lbl-1000:
            // 1 sources

            {
                error = arg.getMode().process(arg, args[i]);
                ** GOTO lbl-1000
lbl69:
                // 1 sources

                error = arg.getMode().process(arg, null);
                if (!this.isHelpRequested()) ** GOTO lbl-1000
                this.printHelpAndExit(null, new Object[0]);
                if (needsHelp == null) return;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                return;
            }
lbl-1000:
            // 2 sources

            {
                if (error == null) ** GOTO lbl-1000
                needsHelp = String.format("Invalid usage for flag %1$s: %2$s.", new Object[]{a, error});
                if (needsHelp == null) return;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                return;
            }
lbl-1000:
            // 4 sources

            {
                ++i;
                ** GOTO lbl7
lbl82:
                // 1 sources

                if (needsHelp != null) break block26;
                if (verb == null && !this.acceptLackOfVerb()) {
                    needsHelp = "Missing verb name.";
                    break block26;
                }
                if (verb == null) break block26;
                if (directObject != null) ** GOTO lbl-1000
                for (String[] actionDesc : this.mActions) {
                    if (!actionDesc[0].equals(verb) || !actionDesc[1].equals("")) continue;
                    directObject = "";
                    break;
                }
                if (directObject != null) ** GOTO lbl-1000
                needsHelp = String.format("Missing object name for verb '%1$s'.", new Object[]{verb});
                if (needsHelp == null) return;
                this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
                return;
            }
lbl-1000:
            // 2 sources

            {
                missing = null;
                plural = false;
                for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
                    arg = entry.getValue();
                    if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject) || !arg.isMandatory() || arg.getCurrentValue() != null) continue;
                    if (missing == null) {
                        missing = "--" + arg.getLongArg();
                        continue;
                    }
                    missing = missing + ", --" + arg.getLongArg();
                    plural = true;
                }
                if (missing != null) {
                    needsHelp = String.format("The %1$s %2$s must be defined for action '%3$s %4$s'", new Object[]{plural != false ? "parameters" : "parameter", missing, verb, directObject});
                }
                this.mVerbRequested = verb;
                this.mDirectObjectRequested = directObject;
            }
        }
        if (needsHelp == null) return;
        this.printHelpAndExitForAction(verb, directObject, needsHelp, new Object[0]);
    }

    protected Arg findLongArg(String verb, String directObject, String longName) {
        if (verb == null) {
            verb = GLOBAL_FLAG_VERB;
        }
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        String key = verb + "/" + directObject + "/" + longName;
        return this.mArguments.get(key);
    }

    protected Arg findShortArg(String verb, String directObject, String shortName) {
        if (verb == null) {
            verb = GLOBAL_FLAG_VERB;
        }
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            Arg arg = entry.getValue();
            if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject) || !shortName.equals(arg.getShortArg())) continue;
            return arg;
        }
        return null;
    }

    public void printHelpAndExit(String errorFormat, Object ... args) {
        this.printHelpAndExitForAction(null, null, errorFormat, args);
    }

    public void printHelpAndExitForAction(String verb, String directObject, String errorFormat, Object ... args) {
        if (errorFormat != null) {
            this.stderr(errorFormat, args);
        }
        this.stdout("\nUsage:\n  android [global options] action [action options]\n\nGlobal options:", new Object[0]);
        this.listOptions(GLOBAL_FLAG_VERB, NO_VERB_OBJECT);
        if (verb == null || directObject == null) {
            this.stdout("\nValid actions are composed of a verb and an optional direct object:", new Object[0]);
            for (String[] action : this.mActions) {
                this.stdout("- %1$6s %2$-7s: %3$s", action[0], action[1], action[2]);
            }
        }
        for (String[] action : this.mActions) {
            if (verb != null && !verb.equals(action[0]) || directObject != null && !directObject.equals(action[1])) continue;
            this.stdout("\nAction \"%1$s %2$s\":", action[0], action[1]);
            this.stdout("  %1$s", action[2]);
            this.stdout("Options:", new Object[0]);
            this.listOptions(action[0], action[1]);
        }
        this.exit();
    }

    protected void listOptions(String verb, String directObject) {
        int numOptions = 0;
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            Arg arg = entry.getValue();
            if (!arg.getVerb().equals(verb) || !arg.getDirectObject().equals(directObject)) continue;
            String value = NO_VERB_OBJECT;
            String required = NO_VERB_OBJECT;
            if (arg.isMandatory()) {
                required = " [required]";
            } else {
                if (arg.getDefaultValue() instanceof String[]) {
                    for (String v : (String[])arg.getDefaultValue()) {
                        if (value.length() > 0) {
                            value = value + ", ";
                        }
                        value = value + v;
                    }
                } else if (arg.getDefaultValue() != null) {
                    Object v = arg.getDefaultValue();
                    if (arg.getMode() != Mode.BOOLEAN || v.equals(Boolean.TRUE)) {
                        value = v.toString();
                    }
                }
                if (value.length() > 0) {
                    value = " [Default: " + value + "]";
                }
            }
            this.stdout("  -%1$s %2$-10s %3$s%4$s%5$s", arg.getShortArg(), "--" + arg.getLongArg(), arg.getDescription(), value, required);
            ++numOptions;
        }
        if (numOptions == 0) {
            this.stdout("  No options", new Object[0]);
        }
    }

    protected void define(Mode mode, boolean mandatory, String verb, String directObject, String shortName, String longName, String description, Object defaultValue) {
        assert (!mandatory || mode != Mode.BOOLEAN);
        if (directObject == null) {
            directObject = NO_VERB_OBJECT;
        }
        String key = verb + "/" + directObject + "/" + longName;
        this.mArguments.put(key, new Arg(mode, mandatory, verb, directObject, shortName, longName, description, defaultValue));
    }

    protected void exit() {
        System.exit(1);
    }

    protected void stdout(String format, Object ... args) {
        this.mLog.printf(format + "\n", args);
    }

    protected void stderr(String format, Object ... args) {
        this.mLog.error(null, format, args);
    }

    static class Arg {
        private final String mVerb;
        private final String mDirectObject;
        private final String mShortName;
        private final String mLongName;
        private final String mDescription;
        private final Object mDefaultValue;
        private final Mode mMode;
        private final boolean mMandatory;
        private Object mCurrentValue;
        private boolean mInCommandLine;

        public Arg(Mode mode, boolean mandatory, String verb, String directObject, String shortName, String longName, String description, Object defaultValue) {
            this.mMode = mode;
            this.mMandatory = mandatory;
            this.mVerb = verb;
            this.mDirectObject = directObject;
            this.mShortName = shortName;
            this.mLongName = longName;
            this.mDescription = description;
            this.mDefaultValue = defaultValue;
            this.mInCommandLine = false;
            this.mCurrentValue = defaultValue instanceof String[] ? ((String[])defaultValue)[0] : this.mDefaultValue;
        }

        public boolean isMandatory() {
            return this.mMandatory;
        }

        public String getShortArg() {
            return this.mShortName;
        }

        public String getLongArg() {
            return this.mLongName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getVerb() {
            return this.mVerb;
        }

        public String getDirectObject() {
            return this.mDirectObject;
        }

        public Object getDefaultValue() {
            return this.mDefaultValue;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public void setCurrentValue(Object currentValue) {
            this.mCurrentValue = currentValue;
        }

        public Mode getMode() {
            return this.mMode;
        }

        public boolean isInCommandLine() {
            return this.mInCommandLine;
        }

        public void setInCommandLine(boolean inCommandLine) {
            this.mInCommandLine = inCommandLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        BOOLEAN{

            public boolean needsExtra() {
                return false;
            }

            public String process(Arg arg, String extra) {
                arg.setCurrentValue((Boolean)arg.getCurrentValue() == false);
                return null;
            }
        }
        ,
        INTEGER{

            public boolean needsExtra() {
                return true;
            }

            public String process(Arg arg, String extra) {
                try {
                    arg.setCurrentValue(Integer.parseInt(extra));
                    return null;
                }
                catch (NumberFormatException e) {
                    return String.format("Failed to parse '%1$s' as an integer: %2%s", extra, e.getMessage());
                }
            }
        }
        ,
        ENUM{

            public boolean needsExtra() {
                return true;
            }

            public String process(Arg arg, String extra) {
                String[] values;
                StringBuilder desc = new StringBuilder();
                for (String value : values = (String[])arg.getDefaultValue()) {
                    if (value.equals(extra)) {
                        arg.setCurrentValue(extra);
                        return null;
                    }
                    if (desc.length() != 0) {
                        desc.append(", ");
                    }
                    desc.append(value);
                }
                return String.format("'%1$s' is not one of %2$s", extra, desc.toString());
            }
        }
        ,
        STRING{

            public boolean needsExtra() {
                return true;
            }

            public String process(Arg arg, String extra) {
                arg.setCurrentValue(extra);
                return null;
            }
        };


        public abstract boolean needsExtra();

        public abstract String process(Arg var1, String var2);
    }
}

