/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Log;
import com.android.ddms.DebugPortProvider;
import com.android.ddms.PrefsDialog;
import com.android.ddms.UIThread;
import com.android.sdkstats.SdkStatsService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class Main {
    public static final String VERSION = "0.8.1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS")) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            System.setProperty("JAVA_STARTED_ON_FIRST_THREAD_" + rt.getName().split("@")[0], "1");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        PrefsDialog.init();
        Log.d((String)"ddms", (String)"Initializing");
        if (args.length >= 3 && args[0].equals("ping")) {
            SdkStatsService.ping((String)args[1], (String)args[2], null);
            return;
        }
        if (args.length > 0) {
            Log.e((String)"ddms", (String)("Unknown argument: " + args[0]));
            System.exit(1);
        }
        SdkStatsService.ping((String)"ddms", (String)VERSION, null);
        DebugPortManager.setProvider((DebugPortManager.IDebugPortProvider)DebugPortProvider.getInstance());
        UIThread ui = UIThread.getInstance();
        try {
            ui.runUI();
        }
        finally {
            PrefsDialog.save();
            AndroidDebugBridge.terminate();
        }
        Log.d((String)"ddms", (String)"Bye");
        System.exit(0);
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            Log.e((String)"ddms", (String)"shutting down due to uncaught exception");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Log.e((String)"ddms", (String)sw.toString());
            System.exit(1);
        }
    }
}

