/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.log.LogReceiver;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Device
implements IDevice {
    static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    private String mSerialNumber = null;
    private String mAvdName = null;
    private IDevice.DeviceState mState = null;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final ArrayList<Client> mClients = new ArrayList();
    private DeviceMonitor mMonitor;
    private static final String LOG_TAG = "Device";
    private SocketChannel mSocketChannel;

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.mAvdName;
    }

    void setAvdName(String avdName) {
        if (!this.isEmulator()) {
            throw new IllegalArgumentException("Cannot set the AVD name of the device is not an emulator");
        }
        this.mAvdName = avdName;
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState state) {
        this.mState = state;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mProperties);
    }

    @Override
    public int getPropertyCount() {
        return this.mProperties.size();
    }

    @Override
    public String getProperty(String name) {
        return this.mProperties.get(name);
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.mState == IDevice.DeviceState.ONLINE;
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches(RE_EMULATOR_SN);
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public boolean hasClients() {
        return this.mClients.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            return this.mClients.toArray(new Client[this.mClients.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String applicationName) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client c : this.mClients) {
                if (!applicationName.equals(c.getClientData().getClientDescription())) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public SyncService getSyncService() throws IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.sSocketAddr, this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.sSocketAddr, this);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.sSocketAddr, command, this, receiver);
    }

    @Override
    public void runEventLogService(LogReceiver receiver) throws IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.sSocketAddr, this, receiver);
    }

    @Override
    public void runLogService(String logname, LogReceiver receiver) throws IOException {
        AdbHelper.runLogService(AndroidDebugBridge.sSocketAddr, this, logname, receiver);
    }

    @Override
    public boolean createForward(int localPort, int remotePort) {
        try {
            return AdbHelper.createForward(AndroidDebugBridge.sSocketAddr, this, localPort, remotePort);
        }
        catch (IOException e) {
            Log.e("adb-forward", e);
            return false;
        }
    }

    @Override
    public boolean removeForward(int localPort, int remotePort) {
        try {
            return AdbHelper.removeForward(AndroidDebugBridge.sSocketAddr, this, localPort, remotePort);
        }
        catch (IOException e) {
            Log.e("adb-remove-forward", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientName(int pid) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client c : this.mClients) {
                if (c.getClientData().getPid() != pid) continue;
                return c.getClientData().getClientDescription();
            }
        }
        return null;
    }

    Device(DeviceMonitor monitor, String serialNumber, IDevice.DeviceState deviceState) {
        this.mMonitor = monitor;
        this.mSerialNumber = serialNumber;
        this.mState = deviceState;
    }

    DeviceMonitor getMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(Client client) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.add(client);
        }
    }

    List<Client> getClientList() {
        return this.mClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasClient(int pid) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (client.getClientData().getPid() != pid) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.clear();
        }
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(Client client, boolean notify) {
        this.mMonitor.addPortToAvailableList(client.getDebuggerListenPort());
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.remove(client);
        }
        if (notify) {
            this.mMonitor.getServer().deviceChanged(this, 2);
        }
    }

    void update(int changeMask) {
        this.mMonitor.getServer().deviceChanged(this, changeMask);
    }

    void update(Client client, int changeMask) {
        this.mMonitor.getServer().clientChanged(client, changeMask);
    }

    void addProperty(String label, String value) {
        this.mProperties.put(label, value);
    }

    @Override
    public String installPackage(String packageFilePath, boolean reinstall) throws IOException {
        String remoteFilePath = this.syncPackageToDevice(packageFilePath);
        String result = this.installRemotePackage(remoteFilePath, reinstall);
        this.removeRemotePackage(remoteFilePath);
        return result;
    }

    @Override
    public String syncPackageToDevice(String localFilePath) throws IOException {
        try {
            String packageFileName = this.getFileName(localFilePath);
            String remoteFilePath = String.format("/data/local/tmp/%1$s", packageFileName);
            Log.i(packageFileName, String.format("Uploading %1$s onto device '%2$s'", packageFileName, this.getSerialNumber()));
            SyncService sync = this.getSyncService();
            if (sync != null) {
                String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                Log.i(LOG_TAG, message);
                SyncService.SyncResult result = sync.pushFile(localFilePath, remoteFilePath, SyncService.getNullProgressMonitor());
                if (result.getCode() != 0) {
                    throw new IOException(String.format("Unable to upload file: %1$s", result.getMessage()));
                }
            } else {
                throw new IOException("Unable to open sync connection!");
            }
            return remoteFilePath;
        }
        catch (IOException e) {
            Log.e(LOG_TAG, String.format("Unable to open sync connection! reason: %1$s", e.getMessage()));
            throw e;
        }
    }

    private String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public String installRemotePackage(String remoteFilePath, boolean reinstall) throws IOException {
        InstallReceiver receiver = new InstallReceiver();
        String cmd = String.format(reinstall ? "pm install -r \"%1$s\"" : "pm install \"%1$s\"", remoteFilePath);
        this.executeShellCommand(cmd, receiver);
        return receiver.getErrorMessage();
    }

    @Override
    public void removeRemotePackage(String remoteFilePath) throws IOException {
        try {
            this.executeShellCommand("rm " + remoteFilePath, new NullOutputReceiver());
        }
        catch (IOException e) {
            Log.e(LOG_TAG, String.format("Failed to delete temporary package: %1$s", e.getMessage()));
            throw e;
        }
    }

    @Override
    public String uninstallPackage(String packageName) throws IOException {
        InstallReceiver receiver = new InstallReceiver();
        this.executeShellCommand("pm uninstall " + packageName, receiver);
        return receiver.getErrorMessage();
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (line.length() <= 0) continue;
                if (line.startsWith(SUCCESS_OUTPUT)) {
                    this.mErrorMessage = null;
                    continue;
                }
                Matcher m = FAILURE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                this.mErrorMessage = m.group(1);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

