/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData;
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int n) {
        this.startPage = n;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int n) {
        this.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        int n;
        Object object;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        Shell shell = this.getParent();
        if (shell != null) {
            pRINTDLG.hwndOwner = shell.handle;
        }
        int n2 = 0;
        int n3 = OS.GetProcessHeap();
        if (this.printerData != null && (object = this.printerData.otherData) != null && ((byte[])object).length != 0) {
            n2 = OS.HeapAlloc(n3, 8, ((byte[])object).length);
            OS.MoveMemory(n2, (byte[])object, ((byte[])object).length);
            pRINTDLG.hDevMode = n2;
        }
        pRINTDLG.Flags = 262144;
        if (this.printToFile) {
            pRINTDLG.Flags |= 0x20;
        }
        switch (this.scope) {
            case 1: {
                pRINTDLG.Flags |= 2;
                break;
            }
            case 2: {
                pRINTDLG.Flags |= 1;
                break;
            }
            default: {
                pRINTDLG.Flags |= 0;
            }
        }
        pRINTDLG.nMinPage = 1;
        pRINTDLG.nMaxPage = (short)-1;
        pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.startPage));
        pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.endPage));
        object = shell.getDisplay();
        Shell[] shellArray = ((Display)object).getShells();
        if ((this.getStyle() & 0x30000) != 0) {
            int n4 = 0;
            while (n4 < shellArray.length) {
                if (shellArray[n4].isEnabled() && shellArray[n4] != shell) {
                    shellArray[n4].setEnabled(false);
                } else {
                    shellArray[n4] = null;
                }
                ++n4;
            }
        }
        PrinterData printerData = null;
        String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object object2 = ((Display)object).getData(string);
        ((Display)object).setData(string, new Boolean(true));
        boolean bl = OS.PrintDlg(pRINTDLG);
        ((Display)object).setData(string, object2);
        if ((this.getStyle() & 0x30000) != 0) {
            n = 0;
            while (n < shellArray.length) {
                if (shellArray[n] != null && !shellArray[n].isDisposed()) {
                    shellArray[n].setEnabled(true);
                }
                ++n;
            }
        }
        if (bl) {
            n = pRINTDLG.hDevNames;
            int n5 = OS.GlobalSize(n) / TCHAR.sizeof * TCHAR.sizeof;
            int n6 = OS.GlobalLock(n);
            short[] sArray = new short[4];
            OS.MoveMemory(sArray, n6, 2 * sArray.length);
            TCHAR tCHAR = new TCHAR(0, n5);
            OS.MoveMemory(tCHAR, n6, n5);
            OS.GlobalUnlock(n);
            short s = sArray[0];
            int n7 = 0;
            while (s + n7 < n5) {
                if (tCHAR.tcharAt(s + n7) == 0) break;
                ++n7;
            }
            String string2 = tCHAR.toString(s, n7);
            short s2 = sArray[1];
            n7 = 0;
            while (s2 + n7 < n5) {
                if (tCHAR.tcharAt(s2 + n7) == 0) break;
                ++n7;
            }
            String string3 = tCHAR.toString(s2, n7);
            short s3 = sArray[2];
            n7 = 0;
            while (s3 + n7 < n5) {
                if (tCHAR.tcharAt(s3 + n7) == 0) break;
                ++n7;
            }
            String string4 = tCHAR.toString(s3, n7);
            printerData = new PrinterData(string2, string3);
            if ((pRINTDLG.Flags & 2) != 0) {
                printerData.scope = 1;
                printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
            } else if ((pRINTDLG.Flags & 1) != 0) {
                printerData.scope = 2;
            }
            boolean bl2 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
            if (printerData.printToFile) {
                printerData.fileName = string4;
            }
            printerData.copyCount = pRINTDLG.nCopies;
            printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
            n = pRINTDLG.hDevMode;
            n5 = OS.GlobalSize(n);
            n6 = OS.GlobalLock(n);
            printerData.otherData = new byte[n5];
            OS.MoveMemory(printerData.otherData, n6, n5);
            OS.GlobalUnlock(n);
            if (n2 != 0) {
                OS.HeapFree(n3, 0, n2);
            }
            this.endPage = printerData.endPage;
            this.printToFile = printerData.printToFile;
            this.scope = printerData.scope;
            this.startPage = printerData.startPage;
        }
        return printerData;
    }
}

