/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.sdkstats.SdkStatsService;
import com.android.traceview.ColorController;
import com.android.traceview.DmTraceReader;
import com.android.traceview.ProfileView;
import com.android.traceview.SelectionController;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceReader;
import com.android.traceview.TraceUnits;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MainWindow
extends ApplicationWindow {
    private static final String PING_NAME = "Traceview";
    private static final String PING_VERSION = "1.0";
    private TraceReader mReader;
    private String mTraceName;
    public static HashMap<String, String> sStringCache = new HashMap();

    public MainWindow(String traceName, TraceReader reader) {
        super(null);
        this.mReader = reader;
        this.mTraceName = traceName;
    }

    public void run() {
        this.setBlockOnOpen(true);
        this.open();
        Display.getCurrent().dispose();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Traceview: " + this.mTraceName);
        shell.setBounds(100, 10, 1282, 900);
    }

    protected Control createContents(Composite parent) {
        ColorController.assignMethodColors(parent.getDisplay(), this.mReader.getMethods());
        SelectionController selectionController = new SelectionController();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Display display = parent.getDisplay();
        Color darkGray = display.getSystemColor(16);
        SashForm sashForm1 = new SashForm(parent, 512);
        sashForm1.setBackground(darkGray);
        sashForm1.SASH_WIDTH = 3;
        GridData data = new GridData(1808);
        sashForm1.setLayoutData((Object)data);
        new TimeLineView((Composite)sashForm1, this.mReader, selectionController);
        new ProfileView((Composite)sashForm1, this.mReader, selectionController);
        return sashForm1;
    }

    private static String makeTempTraceFile(String base) throws IOException {
        File temp = File.createTempFile(base, ".trace");
        temp.deleteOnExit();
        FileChannel dstChannel = new FileOutputStream(temp).getChannel();
        FileChannel srcChannel = new FileInputStream(base + ".key").getChannel();
        long size = dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        srcChannel = new FileInputStream(base + ".data").getChannel();
        dstChannel.transferFrom(srcChannel, size, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
        return temp.getPath();
    }

    public static void main(String[] args) {
        String arg;
        int argc;
        DmTraceReader reader = null;
        boolean regression = false;
        SdkStatsService.ping((String)PING_NAME, (String)PING_VERSION, null);
        int len = args.length;
        for (argc = 0; argc < len && (arg = args[argc]).charAt(0) == '-' && arg.equals("-r"); ++argc) {
            regression = true;
        }
        if (argc != len - 1) {
            System.out.printf("Usage: java %s [-r] trace%n", MainWindow.class.getName());
            System.out.printf("  -r   regression only%n", new Object[0]);
            return;
        }
        String traceName = args[len - 1];
        File file = new File(traceName);
        if (file.exists() && file.isDirectory()) {
            System.out.printf("Qemu trace files not supported yet.\n", new Object[0]);
            System.exit(1);
        } else {
            if (!file.exists()) {
                if (new File(traceName + ".trace").exists()) {
                    traceName = traceName + ".trace";
                } else if (new File(traceName + ".data").exists() && new File(traceName + ".key").exists()) {
                    try {
                        traceName = MainWindow.makeTempTraceFile(traceName);
                    }
                    catch (IOException e) {
                        System.err.printf("cannot convert old trace file '%s'\n", traceName);
                        System.exit(1);
                    }
                } else {
                    System.err.printf("trace file '%s' not found\n", traceName);
                    System.exit(1);
                }
            }
            reader = new DmTraceReader(traceName, regression);
        }
        reader.getTraceUnits().setTimeScale(TraceUnits.TimeScale.MilliSeconds);
        new MainWindow(traceName, reader).run();
    }
}

