/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void drawBand(int n, int n2, int n3, int n4) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        long l = this.parent.handle;
        byte[] byArray = new byte[16];
        byArray[0] = -86;
        byArray[2] = 85;
        byArray[4] = -86;
        byArray[6] = 85;
        byArray[8] = -86;
        byArray[10] = 85;
        byArray[12] = -86;
        byArray[14] = 85;
        byte[] byArray2 = byArray;
        long l2 = OS.CreateBitmap(8, 8, 1, 1, byArray2);
        long l3 = OS.CreatePatternBrush(l2);
        long l4 = OS.GetDCEx(l, 0L, 2);
        long l5 = OS.SelectObject(l4, l3);
        OS.PatBlt(l4, n, n2, n3, n4, 5898313);
        OS.SelectObject(l4, l5);
        OS.ReleaseDC(l, l4);
        OS.DeleteObject(l3);
        OS.DeleteObject(l2);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    long windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        super.WM_ERASEBKGND(l, l2);
        this.drawBackground(l);
        return LRESULT.ONE;
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (OS.GetKeyState(1) < 0) {
                    return lRESULT;
                }
                int n = OS.GetKeyState(17) < 0 ? 1 : 9;
                POINT pOINT = new POINT();
                if ((this.style & 0x200) != 0) {
                    if (l == 38L || l == 40L) break;
                    pOINT.x = l == 37L ? -n : n;
                } else {
                    if (l == 37L || l == 39L) break;
                    pOINT.y = l == 38L ? -n : n;
                }
                long l3 = this.parent.handle;
                OS.MapWindowPoints(this.handle, l3, pOINT, 1);
                RECT rECT = new RECT();
                RECT rECT2 = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n2 = rECT.right - rECT.left;
                int n3 = rECT.bottom - rECT.top;
                OS.GetClientRect(l3, rECT2);
                int n4 = rECT2.right - rECT2.left;
                int n5 = rECT2.bottom - rECT2.top;
                int n6 = this.lastX;
                int n7 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n6 = Math.min(Math.max(0, pOINT.x - this.startX), n4 - n2);
                } else {
                    n7 = Math.min(Math.max(0, pOINT.y - this.startY), n5 - n3);
                }
                if (n6 == this.lastX && n7 == this.lastY) {
                    return lRESULT;
                }
                POINT pOINT2 = new POINT();
                pOINT2.x = pOINT.x;
                pOINT2.y = pOINT.y;
                OS.ClientToScreen(l3, pOINT2);
                if ((this.style & 0x200) != 0) {
                    pOINT2.y += n3 / 2;
                } else {
                    pOINT2.x += n2 / 2;
                }
                OS.SetCursorPos(pOINT2.x, pOINT2.y);
                Event event = new Event();
                event.x = n6;
                event.y = n7;
                event.width = n2;
                event.height = n3;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                if (event.doit && (this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n2, n3);
                }
                return lRESULT;
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        return new LRESULT(256L);
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        long l3 = this.parent.handle;
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, l2);
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        OS.MapWindowPoints(this.handle, 0L, pOINT, 1);
        this.startX = pOINT.x - rECT.left;
        this.startY = pOINT.y - rECT.top;
        OS.MapWindowPoints(0L, l3, rECT, 2);
        this.lastX = rECT.left;
        this.lastY = rECT.top;
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n;
        event.height = n2;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.menuShell().bringToTop();
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            if (OS.IsWinCE) {
                OS.UpdateWindow(l3);
            } else {
                int n3 = 384;
                OS.RedrawWindow(l3, null, 0L, n3);
            }
            this.drawBand(event.x, event.y, n, n2);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n, n2);
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONUP(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.dragging) {
            return lRESULT;
        }
        this.dragging = false;
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n;
        event.height = n2;
        this.drawBand(event.x, event.y, n, n2);
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n, n2);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_MOUSEMOVE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.dragging || (l & 1L) == 0L) {
            return lRESULT;
        }
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, l2);
        long l3 = this.parent.handle;
        OS.MapWindowPoints(this.handle, l3, pOINT, 1);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        OS.GetClientRect(l3, rECT2);
        int n4 = this.lastX;
        int n5 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n = rECT2.right - rECT2.left;
            n4 = Math.min(Math.max(0, pOINT.x - this.startX), n - n2);
        } else {
            n = rECT2.bottom - rECT2.top;
            n5 = Math.min(Math.max(0, pOINT.y - this.startY), n - n3);
        }
        if (n4 == this.lastX && n5 == this.lastY) {
            return lRESULT;
        }
        this.drawBand(this.lastX, this.lastY, n2, n3);
        Event event = new Event();
        event.x = n4;
        event.y = n5;
        event.width = n2;
        event.height = n3;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
        if (OS.IsWinCE) {
            OS.UpdateWindow(l3);
        } else {
            int n6 = 384;
            OS.RedrawWindow(l3, null, 0L, n6);
        }
        this.drawBand(this.lastX, this.lastY, n2, n3);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(this.lastX, this.lastY, n2, n3);
        }
        return lRESULT;
    }

    LRESULT WM_SETCURSOR(long l, long l2) {
        LRESULT lRESULT = super.WM_SETCURSOR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s = (short)OS.LOWORD(l2);
        if (s == 1) {
            long l3 = 0L;
            l3 = (this.style & 0x100) != 0 ? OS.LoadCursor(0L, 32645L) : OS.LoadCursor(0L, 32644L);
            OS.SetCursor(l3);
            return LRESULT.ONE;
        }
        return lRESULT;
    }
}

