/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPackage
extends Package {
    private static final String PROP_PATH = "Extra.Path";
    private static final String PROP_MIN_TOOLS_REV = "Extra.MinToolsRev";
    private final String mPath;
    private final int mMinToolsRevision;
    public static final int MIN_TOOLS_REV_NOT_SPECIFIED = 0;

    ExtraPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
        this.mPath = XmlParserUtils.getXmlString(packageNode, "path");
        this.mMinToolsRevision = XmlParserUtils.getXmlInt(packageNode, "min-tools-rev", 0);
    }

    ExtraPackage(RepoSource source, Properties props, String path, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        this.mPath = path != null ? path : this.getProperty(props, PROP_PATH, path);
        this.mMinToolsRevision = Integer.parseInt(this.getProperty(props, PROP_MIN_TOOLS_REV, Integer.toString(0)));
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        props.setProperty(PROP_PATH, this.mPath);
        if (this.mMinToolsRevision != 0) {
            props.setProperty(PROP_MIN_TOOLS_REV, Integer.toString(this.mMinToolsRevision));
        }
    }

    public boolean isPathValid() {
        if ("add-ons".equals(this.mPath) || "platforms".equals(this.mPath) || "tools".equals(this.mPath) || "docs".equals(this.mPath)) {
            return false;
        }
        return this.mPath != null && this.mPath.indexOf(47) == -1 && this.mPath.indexOf(92) == -1;
    }

    public String getPath() {
        return this.mPath;
    }

    public int getMinToolsRevision() {
        return this.mMinToolsRevision;
    }

    @Override
    public String getShortDescription() {
        String name = this.getPath();
        if (name != null) {
            name = name.replaceAll("[ _\t\f-]+", " ");
            boolean changed = false;
            char[] chars = name.toCharArray();
            int n = chars.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!Character.isLowerCase(chars[i]) || i != 0 && chars[i - 1] != ' ') continue;
                chars[i] = Character.toUpperCase(chars[i]);
                changed = true;
            }
            if (changed) {
                name = new String(chars);
            }
        }
        String s = String.format("%1$s package, revision %2$d", name, this.getRevision());
        if (this.mMinToolsRevision != 0) {
            s = s + String.format(" (tools rev: %1$d)", this.mMinToolsRevision);
        }
        return s;
    }

    @Override
    public String getLongDescription() {
        String s = String.format("Extra %1$s package, revision %2$d", this.getPath(), this.getRevision());
        if (this.mMinToolsRevision != 0) {
            s = s + String.format(" (min tools rev.: %1$d)", this.mMinToolsRevision);
        }
        s = s + ".";
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        return new File(osSdkRoot, this.getPath());
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return pkg instanceof ExtraPackage && ((ExtraPackage)pkg).mPath.equals(this.mPath);
    }
}

