//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: DECSK4.H
//  Version : V1.0
//  Date    : 01/14/2004
//  Note    : DECSK4 Data Structure / Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _DECSK4_H_
#define _DECSK4_H_

#ifdef _DECSK4_IMPLEMENTATION_
#define DECSK4API __declspec(dllexport)
#else
#define DECSK4API __declspec(dllimport)
#endif

//#define WINAPI __stdcall

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */


typedef void * DECSK4;


//+=====================================================+
//*                 decsk4_initialize                   *
//+=====================================================+
DECSK4API BOOL decsk4_initialize ( void );


//+=====================================================+
//*                 decsk4_terminate                    *
//+=====================================================+
DECSK4API void decsk4_terminate ( void );


//+=====================================================+
//*                 decsk4_new                          *
//+=====================================================+
DECSK4API DECSK4 * decsk4_new ( void );
// New an DECSK4 Object
// [in]-void
// [return]-DECSK4 *, NULL if error


//+=====================================================+
//*                 decsk4_free                         *
//+=====================================================+
DECSK4API void decsk4_free ( DECSK4 * pd );
// Free an DECSK4 Object
// [in]-DECSK4 *
// [return]-void



//+=====================================================+
//*                 decsk4_flush                        *
//+=====================================================+
DECSK4API void decsk4_flush ( DECSK4 * pd );
// Flush DECSK4 Bit Buffer
// [in]-DECSK4 *
// [return]-void


//+=====================================================+
//*                 decsk4_draw_init                    *
//+=====================================================+
DECSK4API BOOL decsk4_draw_init ( DECSK4 * pd, HWND hWnd );
// initialize the DECSK4 drawing module
// [in]-hWnd of the window to be drawn, if NULL the h263 stream will not be
//      drawn but be decompressed into RGB888 format, user can use
//      decsk4_get_decompressed_bitmap () to retrieve the decompressed video.
// [return]-TRUE if OK


//+=====================================================+
//*                 decsk4_draw_exit                    *
//+=====================================================+
DECSK4API void decsk4_draw_exit ( DECSK4 * pd );
// Terminate the DECSK4 Drawing module
// [in]-void
// [return]-void


//+=====================================================+
//*                 decsk4_receive_data                 *
//+=====================================================+
DECSK4API int decsk4_receive_data ( DECSK4 * pd, long len, void * data, int frames );
// receive a block of data, if these make a compressed frame, then decompress
// this frame. continue to decode and play a number of video frames which is
// specified by parameter - frames.
// [in]-DECSK4 *, length of the data, data buffer ( byte stuffing ), max
// number of frames to be decoded, -1 for unlimited decoding
// [return]-number of frames decoded



//+=====================================================+
//*                 decsk4_get_decompressed_bitmap_ex2  *
//+=====================================================+
DECSK4API DWORD decsk4_get_decompressed_bitmap_ex2 ( DECSK4 * pd, BYTE * buffer, DWORD buflen );
// get the ptr of decompress bitmap ( RGB888 24 bit format )
// [in]-DECSK4 *, buffer for returning bitmap, size of buffer
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 decsk4_get_decompressed_bitmap_jpg  *
//+=====================================================+
DECSK4API DWORD decsk4_get_decompressed_bitmap_jpg ( DECSK4 * pd, BYTE * buffer, DWORD buflen, int quality );
// get the ptr of decompress bitmap as jpeg image
// [in]-DECSK4 *, buffer for returning bitmap, size of buffer ( width*height*3 is recommended )
// [return]-size of the bitmap, 0 if system error



//+=====================================================+
//*                 decsk4_access_src_rect              *
//+=====================================================+
DECSK4API RECT * decsk4_access_src_rect ( DECSK4 * pd, RECT * rect );
// Set(Get) the source rect of the decompressed bitmap
// this rectangle is a portion of the original bitmap, this portion of bitmap
// will be stretched (scaled) to dest rect ( see decsk4_access_dst_rect )
// which specifies the displayed (target) rectangle.
//
// [in]-DECSK4 *, if rect is not NULL, the source rect will be set as the
//      values specified, if it's NULL, the source rect will not be changed
// [return]-the resultant source rect



////////////////////////////////////////////////////////////////////////
// New APIs for Plugin 2.96
DECSK4API void WINAPI decsk4_show(DECSK4 * pd, BOOL bShow);
// Show or hide decoded video.
// [in]-DECSK4 *, bShow

DECSK4API void WINAPI decsk4_get_size(DECSK4 *pd, DWORD *width, DWORD *height);
// Get size of last decoded frame.
// [in]-DECSK4 *
// [out] - width & height of the frame.
////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif // _DECSK4_H_

