//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: DECMP4.H
//  Version : V1.0
//  Date    : 01/14/2004
//  Note    : DECMP4 Data Structure / Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _DECMP4_H_
#define _DECMP4_H_

#ifdef _DECMP4_IMPLEMENTATION_
#define DECMP4API __declspec(dllexport)
#else
#define DECMP4API __declspec(dllimport)
#endif

//#define WINAPI __stdcall

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */


typedef void * DECMP4;


//+=====================================================+
//*                 decmp4_initialize                   *
//+=====================================================+
DECMP4API BOOL decmp4_initialize ( void );


//+=====================================================+
//*                 decmp4_terminate                    *
//+=====================================================+
DECMP4API void decmp4_terminate ( void );


//+=====================================================+
//*                 decmp4_new                          *
//+=====================================================+
DECMP4API DECMP4 * decmp4_new ( void );
// New an DECMP4 Object
// [in]-void
// [return]-DECMP4 *, NULL if error


//+=====================================================+
//*                 decmp4_free                         *
//+=====================================================+
DECMP4API void decmp4_free ( DECMP4 * pd );
// Free an DECMP4 Object
// [in]-DECMP4 *
// [return]-void



//+=====================================================+
//*                 decmp4_flush                        *
//+=====================================================+
DECMP4API void decmp4_flush ( DECMP4 * pd );
// Flush DECMP4 Bit Buffer
// [in]-DECMP4 *
// [return]-void


//+=====================================================+
//*                 decmp4_draw_init                    *
//+=====================================================+
DECMP4API BOOL decmp4_draw_init ( DECMP4 * pd, HWND hWnd );
// initialize the DECMP4 drawing module
// [in]-hWnd of the window to be drawn, if NULL the h263 stream will not be
//      drawn but be decompressed into RGB888 format, user can use
//      decmp4_get_decompressed_bitmap () to retrieve the decompressed video.
// [return]-TRUE if OK


//+=====================================================+
//*                 decmp4_draw_exit                    *
//+=====================================================+
DECMP4API void decmp4_draw_exit ( DECMP4 * pd );
// Terminate the DECMP4 Drawing module
// [in]-void
// [return]-void


//+=====================================================+
//*                 decmp4_receive_data                 *
//+=====================================================+
DECMP4API int decmp4_receive_data ( DECMP4 * pd, long len, void * data, int frames );
// receive a block of data, if these make a compressed frame, then decompress
// this frame. continue to decode and play a number of video frames which is
// specified by parameter - frames.
// [in]-DECMP4 *, length of the data, data buffer ( byte stuffing ), max
// number of frames to be decoded, -1 for unlimited decoding
// [return]-number of frames decoded


//+=====================================================+
//*                 decmp4_get_decompressed_bitmap_ex2  *
//+=====================================================+
DECMP4API DWORD decmp4_get_decompressed_bitmap_ex2 ( DECMP4 * pd, BYTE * buffer, DWORD buflen );
// get the ptr of decompress bitmap ( RGB888 24 bit format )
// [in]-DECMP4 *, buffer for returning bitmap, size of buffer
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 decmp4_get_decompressed_bitmap_jpg  *
//+=====================================================+
DECMP4API DWORD decmp4_get_decompressed_bitmap_jpg ( DECMP4 * pd, BYTE * buffer, DWORD buflen, int quality );
// get the ptr of decompress bitmap as jpeg image
// [in]-DECMP4 *, buffer for returning bitmap, size of buffer ( width*height*3 is recommended )
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 decmp4_access_src_rect              *
//+=====================================================+
DECMP4API RECT * decmp4_access_src_rect ( DECMP4 * pd, RECT * rect );
// Set(Get) the source rect of the decompressed bitmap
// this rectangle is a portion of the original bitmap, this portion of bitmap
// will be stretched (scaled) to dest rect ( see decmp4_access_dst_rect )
// which specifies the displayed (target) rectangle.
//
// [in]-DECMP4 *, if rect is not NULL, the source rect will be set as the
//      values specified, if it's NULL, the source rect will not be changed
// [return]-the resultant source rect


////////////////////////////////////////////////////////////////////////
// New APIs for Plugin 2.96
DECMP4API void WINAPI decmp4_show(DECMP4 * pd, BOOL bShow);
// Show or hide decoded video.
// [in]-DECMP4 *, bShow

DECMP4API void WINAPI decmp4_get_size(DECMP4 *pd, DWORD *width, DWORD *height);
// Get size of last decoded frame.
// [in]-DECMP4 *
// [out] - width & height of the frame.
////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif // _DECMP4_H_

