//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: DECVWEB.H
//  Version : V1.0
//  Date    : 10/4/2004
//  Note    : DECVWEB Data Structure / Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _DECVWEB_H_
#define _DECVWEB_H_

#ifdef _DECVWEB_IMPLEMENTATION_
#define DECVWEBAPI __declspec(dllexport)
#else
#define DECVWEBAPI __declspec(dllimport)
#endif

//#define WINAPI __stdcall

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */


typedef void * DECVWEB;


//+=====================================================+
//*                 decvweb_initialize                   *
//+=====================================================+
DECVWEBAPI BOOL decvweb_initialize ( void );


//+=====================================================+
//*                 decvweb_terminate                    *
//+=====================================================+
DECVWEBAPI void decvweb_terminate ( void );


//+=====================================================+
//*                 decvweb_new                          *
//+=====================================================+
DECVWEBAPI DECVWEB * decvweb_new ( BOOL ps_data );
// New an DECVWEB Object
// [in]-BOOL incoming data is PS format
// [return]-DECVWEB *, NULL if error


//+=====================================================+
//*                 decvweb_free                         *
//+=====================================================+
DECVWEBAPI void decvweb_free ( DECVWEB * pd );
// Free an DECVWEB Object
// [in]-DECVWEB *
// [return]-void



//+=====================================================+
//*                 decvweb_flush                        *
//+=====================================================+
DECVWEBAPI void decvweb_flush ( DECVWEB * pd );
// Flush DECVWEB Bit Buffer
// [in]-DECVWEB *
// [return]-void


//+=====================================================+
//*                 decvweb_draw_init                    *
//+=====================================================+
DECVWEBAPI BOOL decvweb_draw_init ( DECVWEB * pd, HWND hWnd );
// initialize the DECVWEB drawing module
// [in]-hWnd of the window to be drawn, if NULL the h263 stream will not be
//      drawn but be decompressed into RGB888 format, user can use
//      decvweb_get_decompressed_bitmap () to retrieve the decompressed video.
// [return]-TRUE if OK


//+=====================================================+
//*                 decvweb_draw_exit                    *
//+=====================================================+
DECVWEBAPI void decvweb_draw_exit ( DECVWEB * pd );
// Terminate the DECVWEB Drawing module
// [in]-void
// [return]-void


//+=====================================================+
//*                 decvweb_receive_data                 *
//+=====================================================+
DECVWEBAPI int decvweb_receive_data ( DECVWEB * pd, long len, void * data, int frames );
// receive a block of data, if these make a compressed frame, then decompress
// this frame. continue to decode and play a number of video frames which is
// specified by parameter - frames.
// [in]-DECVWEB *, length of the data, data buffer ( byte stuffing ), max
// number of frames to be decoded, -1 for unlimited decoding
// [return]-number of frames decoded


//+=====================================================+
//*                 decvweb_get_decompressed_bitmap_ex2  *
//+=====================================================+
DECVWEBAPI DWORD decvweb_get_decompressed_bitmap_ex2 ( DECVWEB * pd, BYTE * buffer, DWORD buflen );
// get the ptr of decompress bitmap ( RGB888 24 bit format )
// [in]-DECVWEB *, buffer for returning bitmap, size of buffer
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 decvweb_get_decompressed_bitmap_jpg  *
//+=====================================================+
DECVWEBAPI DWORD decvweb_get_decompressed_bitmap_jpg ( DECVWEB * pd, BYTE * buffer, DWORD buflen, int quality );
// get the ptr of decompress bitmap as jpeg image
// [in]-DECVWEB *, buffer for returning bitmap, size of buffer ( width*height*3 is recommended )
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 decvweb_access_src_rect              *
//+=====================================================+
DECVWEBAPI RECT * decvweb_access_src_rect ( DECVWEB * pd, RECT * rect );
// Set(Get) the source rect of the decompressed bitmap
// this rectangle is a portion of the original bitmap, this portion of bitmap
// will be stretched (scaled) to dest rect ( see decvweb_access_dst_rect )
// which specifies the displayed (target) rectangle.
//
// [in]-DECVWEB *, if rect is not NULL, the source rect will be set as the
//      values specified, if it's NULL, the source rect will not be changed
// [return]-the resultant source rect


////////////////////////////////////////////////////////////////////////
// New APIs for Plugin 2.96
DECVWEBAPI void WINAPI decvweb_show(DECVWEB * pd, BOOL bShow);
// Show or hide decoded video.
// [in]-DECVWEB *, bShow

DECVWEBAPI void WINAPI decvweb_get_size(DECVWEB *pd, DWORD *width, DWORD *height);
// Get size of last decoded frame.
// [in]-DECVWEB *
// [out] - width & height of the frame.
////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif // _DECVWEB_H_

