// TestAppDecDLLDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TestAppDecDLL.h"
#include "TestAppDecDLLDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define H263_NEW_HEADER_SIZE   14	    // new frame header
#define H263_HEADER_SIZE		5	    // old frame header
#define SKL4_NEW_HEADER_SIZE   18       // new frame header

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAppDecDLLDlg dialog

CTestAppDecDLLDlg::CTestAppDecDLLDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestAppDecDLLDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestAppDecDLLDlg)
	m_strFilePath = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestAppDecDLLDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestAppDecDLLDlg)
	DDX_Text(pDX, IDC_FILE_PATH, m_strFilePath);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestAppDecDLLDlg, CDialog)
	//{{AFX_MSG_MAP(CTestAppDecDLLDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_FILE, OnFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAppDecDLLDlg message handlers

BOOL CTestAppDecDLLDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestAppDecDLLDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestAppDecDLLDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTestAppDecDLLDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestAppDecDLLDlg::OnExit() 
{
	DestroyWindow();
}

void CTestAppDecDLLDlg::OnFile() 
{
	CString s;
	OPENFILENAME ofn; 
    TCHAR lpstrFilename[256] = ""; 
    ZeroMemory(&ofn, sizeof(ofn)); 
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = this->m_hWnd; 
    ofn.lpstrFilter = "All\0*.nw3;*.nwj;*.vwe;*.nw4;*.nw5;*.d01\0"
					  "H.263 (*.nw3)\0*.nw3\0"
					  "JPEG/MJPEG (*.nwj)\0*.nwj\0"
					  "MPEG4 (*.nw4)\0*.nw4\0"
					  "SKL4 (*.nw5)\0*.nw5\0"
					  "VWEB (*.vwe)\0*.vwe\0"
					  "DVR File (*.d01)\0*.d01\0"; 
    ofn.nMaxFile = 256; 
	ofn.Flags=OFN_FILEMUSTEXIST;
    ofn.lpstrFile=lpstrFilename;  

    if (GetOpenFileName(&ofn)) 
	{
		m_strFilePath = ofn.lpstrFile;
		UpdateData(false);	
	}

    SetSrcFileType();

	CTestAppDecDLLApp *app;
	app = ((CTestAppDecDLLApp*)AfxGetApp());

	app->ConvertInit(m_strFilePath, m_filetype, GetDlgItem(IDC_VIDEO)->m_hWnd);
	app->StartConvert();
	
}
void CTestAppDecDLLDlg::SetSrcFileType(void)
{
	m_strFilePath.MakeUpper();

	if(m_strFilePath.Find(".NW3")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_RAW_H263;
	else if(m_strFilePath.Find(".NWJ")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_RAW_JPEG;
	else if(m_strFilePath.Find(".NW4")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_RAW_MPEG4;
	else if(m_strFilePath.Find(".NW5")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_RAW_SKL4;
	else if(m_strFilePath.Find(".VWE")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_RAW_VWEB;
	else if(m_strFilePath.Find(".D01")==m_strFilePath.GetLength()-4)
		m_filetype = FILETYPE_DVR;
	else
		m_filetype = -1;
}

