#include "stdafx.h"
#include "psparser.h"
#include "oldfrm1.h"
#include "decoder.h"


//=============== decoder ======================================================
decoder::decoder()
{
}
decoder::~decoder()
{
}
void decoder::Init ( HWND hWnd )
{
}
void decoder::Exit ( void )
{
}
void decoder::ShowVideo ( int ShowVideo )
{
}
BOOL decoder::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  
	return FALSE;
}
BOOL decoder::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						LPBITMAPINFOHEADER pBMPInfo)
{
	return FALSE;
}
void decoder::GetFrameSize(DWORD *width, DWORD *height)
{
}

void decoder::ExpandBMP(BYTE *pBMPBuf)
{
	BITMAPFILEHEADER *pFile = (BITMAPFILEHEADER*)pBMPBuf;
	BITMAPINFOHEADER *pInfo = (BITMAPINFOHEADER*)(pBMPBuf+sizeof(BITMAPFILEHEADER));
	BYTE *data = pBMPBuf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	int i, line_width;

	if (pInfo->biBitCount == 16)
		line_width = pInfo->biWidth * 2;
	else if (pInfo->biBitCount == 24)
		line_width = pInfo->biWidth * 3;
	else
		return;

	for (i=pInfo->biHeight-1; i >= 0; i--)
	{
		BYTE *src, *target;
		src = data + i*line_width;

		target = data + i*2*line_width;
		memcpy(target, src, line_width);
		target += line_width;
		memcpy(target, src, line_width);
	}

	pInfo->biHeight *= 2;
	pInfo->biSizeImage *= 2;
}

//=============== DECH263 ======================================================
DECH263::DECH263()
{
	m_pDec = NULL;
}
DECH263::~DECH263()
{
}
void DECH263::Init ( HWND hWnd )
{
	if (m_pDec) return;
	dec263_initialize();
	m_pDec = dec263_new();
	dec263_draw_init(m_pDec, hWnd);
	dec263_show(m_pDec, FALSE);
}
void DECH263::Exit ( void )
{
	if (m_pDec) dec263_free (m_pDec);
	m_pDec = NULL;
	dec263_terminate();
}
void DECH263::ShowVideo ( int ShowVideo )
{
	if (m_pDec) dec263_show(m_pDec, ShowVideo);
}
BOOL DECH263::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  
	if (dec263_receive_data(m_pDec, frame_size, frame, -1) >= 1) 
		return TRUE;
	return FALSE;
}
BOOL DECH263::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize, 
						LPBITMAPINFOHEADER pBMPInfo)
{
	DWORD width, height;
	GetFrameSize(&width, &height);

	if (!dec263_get_decompressed_bitmap_ex2(m_pDec, pBMPBuf, dwBMPBufSize))
		return FALSE;

	//count actual data.
	DWORD actual_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
	if (width == 640 && height == 240)
	{	//expand video
		DWORD newsize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER) + 640 * 480 * 3;
		ExpandBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), newsize);
	}
	else
	{//copy info header & pixal data
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), dwBMPBufSize - sizeof( BITMAPFILEHEADER ));
	}

	return TRUE;
}
void DECH263::GetFrameSize(DWORD *width, DWORD *height)
{
	*width = 320;
	*height = 240;
	dec263_get_size(m_pDec, width, height);
}
decoder *DECH263::CreateDecoder(void)
{
    DECH263 *pp = new DECH263;
    return pp;
}

//=============== DECJPEG ======================================================
DECJPEG::DECJPEG()
{
	m_pDec = NULL;
}
DECJPEG::~DECJPEG()
{
}
void DECJPEG::Init ( HWND hWnd )
{
	if (m_pDec) return;
	JDEC_Init();
	m_pDec = JDEC_New (320, 240);
	JDEC_Draw_Init(m_pDec, hWnd);
	JDEC_show(m_pDec, FALSE);
}
void DECJPEG::Exit ( void )
{
	if (m_pDec) JDEC_Free (m_pDec);
	m_pDec = NULL;
	JDEC_Exit ();
}
void DECJPEG::ShowVideo ( int ShowVideo )
{
	if (m_pDec) JDEC_show(m_pDec, ShowVideo);
}
BOOL DECJPEG::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  
	int receive=0;
	if (JDEC_Receive_Data(m_pDec, frame_size, frame, &receive) >= 1)
		return TRUE;
	return FALSE;
}
BOOL DECJPEG::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						LPBITMAPINFOHEADER pBMPInfo)
{
	DWORD width, height;
	GetFrameSize(&width, &height);

    if (!JDEC_get_decompressed_bitmap_ex2(m_pDec, pBMPBuf, dwBMPBufSize))
		return FALSE;

	//count actual data.
	DWORD actual_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
	if (width == 640 && height == 240)
	{	//expand video
		DWORD newsize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER) + 640 * 480 * 3;
		ExpandBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), newsize);
	}
	else
	{//copy info header & pixal data
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), dwBMPBufSize - sizeof( BITMAPFILEHEADER ));
	}

	return 0;
}
void DECJPEG::GetFrameSize(DWORD *width, DWORD *height)
{
	*width = 320;
	*height = 240;
	JDEC_get_size(m_pDec, width, height);
}
decoder *DECJPEG::CreateDecoder(void)
{
    DECJPEG *pp = new DECJPEG;
    return pp;
}

//=============== DECMPEG ======================================================
DECMPEG::DECMPEG()
{
	m_pDec = NULL;
}
DECMPEG::~DECMPEG()
{
}
void DECMPEG::Init ( HWND hWnd )
{
	if (m_pDec) return;
	decmp4_initialize();
	m_pDec = decmp4_new ();
	decmp4_draw_init(m_pDec, hWnd);
	decmp4_show(m_pDec, TRUE);
}
void DECMPEG::Exit ( void )
{
    if (m_pDec) decmp4_free (m_pDec);
	m_pDec = NULL;
	decmp4_terminate();
}
void DECMPEG::ShowVideo ( int ShowVideo )
{
	if (m_pDec) decmp4_show(m_pDec, ShowVideo);
}
BOOL DECMPEG::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  
	if (decmp4_receive_data(m_pDec, frame_size, frame, 1) > 0)
		return TRUE;
	return FALSE;
}
BOOL DECMPEG::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						LPBITMAPINFOHEADER pBMPInfo)
{
	DWORD width, height;
	GetFrameSize(&width, &height);

    if (!decmp4_get_decompressed_bitmap_ex2(m_pDec, pBMPBuf, dwBMPBufSize))
		return FALSE;

	//count actual data.
	DWORD actual_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
	if (width == 640 && height == 240)
	{	//expand video
		DWORD newsize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER) + 640 * 480 * 3;
		ExpandBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), newsize);
	}
	else
	{//copy info header & pixal data
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), dwBMPBufSize - sizeof( BITMAPFILEHEADER ));
	}

	return TRUE;
}
void DECMPEG::GetFrameSize(DWORD *width, DWORD *height)
{
	*width = 320;
	*height = 240;
	decmp4_get_size(m_pDec, width, height);
}
decoder *DECMPEG::CreateDecoder(void)
{
    DECMPEG *pp = new DECMPEG;
    return pp;
}

//=============== DECHMP4 ======================================================
#define PSPARSER_BUF_SIZE       (720*480*3/2)

DECHMP4::DECHMP4()
{
	m_pDec = NULL;
}
DECHMP4::~DECHMP4()
{
}
void DECHMP4::Init ( HWND hWnd )
{
	if (m_pDec) return;

	m_PSParserBuf = new BYTE[PSPARSER_BUF_SIZE];
	m_PSParser = 0;

	m_PSParser = PSParser_New();

	decvweb_initialize ();
	
	m_pDec = decvweb_new(FALSE);
	if (!m_pDec) return;
	
    if (!decvweb_draw_init(m_pDec, hWnd))
	{
		decvweb_free(m_pDec);
		m_pDec = NULL;
		decvweb_show(m_pDec, FALSE);
		return;
	}
	decvweb_flush(m_pDec);
	decvweb_show(m_pDec, TRUE);
}
void DECHMP4::Exit ( void )
{
    if (m_pDec)
	{  
		decvweb_flush(m_pDec);
        decvweb_draw_exit(m_pDec);
        decvweb_free(m_pDec);
		m_pDec = NULL;
		decvweb_terminate ();
	}
	if (m_PSParserBuf)
		delete m_PSParserBuf;
	
	if (m_PSParser)
		PSParser_Free(m_PSParser);
}
void DECHMP4::ShowVideo ( int ShowVideo )
{
	if (m_pDec) decvweb_show(m_pDec, ShowVideo);
}
BOOL DECHMP4::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  
	if (!Process41RTFrame(pHeader))
		return FALSE;

	if (decvweb_receive_data(m_pDec, pHeader->size, frame, 1) > 0)
		return TRUE;
	return FALSE;
}

void DECHMP4::ScaleBMP(BYTE *pBMPBuf)
{
	BITMAPFILEHEADER *pFile = (BITMAPFILEHEADER*)pBMPBuf;
	BITMAPINFOHEADER *pInfo = (BITMAPINFOHEADER*)(pBMPBuf+sizeof(BITMAPFILEHEADER));
	BYTE *data = pBMPBuf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	int i, line_width, new_width, dst;

	if (pInfo->biBitCount == 16)
	{
		line_width = pInfo->biWidth * 2;
		new_width = 640 * 2;
		dst = 40 * 2;
	}
	else if (pInfo->biBitCount == 24)
	{	
		line_width = pInfo->biWidth * 3;
		new_width = 640 * 3;
		dst = 40 * 3;
	}
	else
		return;

	// 720X480 -> 640X480
	for (i=0; i<pInfo->biHeight; i++)
	{
		BYTE *src, *target;
		src = data + i*line_width;
		target = data + i*new_width;
		memcpy(target, src+dst, new_width);
	}

	pInfo->biWidth = 640;
	pInfo->biSizeImage *= 8/9;
//	g_pBMPInfo->biWidth = 640;
	//g_pBMPInfo->biSizeImage *= 8/9;
}

BOOL DECHMP4::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						LPBITMAPINFOHEADER pBMPInfo)
{
	DWORD width, height;
	GetFrameSize(&width, &height);

    if (!decvweb_get_decompressed_bitmap_ex2(m_pDec, pBMPBuf, dwBMPBufSize))
		return FALSE;

	//count actual data.
	DWORD actual_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
	if (width == 640 && height == 240)
	{	//expand video
		DWORD newsize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER) + 640 * 480 * 3;
		ExpandBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), newsize);
	}
	else
	{//copy info header & pixal data
		if (width == 720 && height == 480)
			ScaleBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), dwBMPBufSize - sizeof( BITMAPFILEHEADER ));


	}

	return TRUE;
}
void DECHMP4::GetFrameSize(DWORD *width, DWORD *height)
{
	*width = 320;
	*height = 240;
	decvweb_get_size(m_pDec, width, height);
}
decoder *DECHMP4::CreateDecoder(void)
{
    DECHMP4 *pp = new DECHMP4;
    return pp;
}
BOOL DECHMP4::Process41RTFrame(LPADV_HEADER pHeader)
{
	BYTE *frame_data;

	if (!m_PSParser || !m_PSParserBuf)
		return FALSE;

	//TO("psparser before: cam=%d, size=%d\n", pHeader->source, pHeader->size);

	//call PSParser
	int ret, len, frame_type;
	
	frame_data = ((unsigned char *)pHeader)+sizeof(ADV_HEADER);
	len = PSPARSER_BUF_SIZE;
	ret = PSParser_Parse (m_PSParser, frame_data, pHeader->size,
                                m_PSParserBuf, &len, &frame_type);
	if (ret < 0 || len <= 0)
		return FALSE;

	memcpy(frame_data, m_PSParserBuf, len);
	pHeader->size = len;

	//TO("psparser -2: cam=%d, size=%d\n", pHeader->source, pHeader->size);

	//add header used by webvdo.
	PackNewHeader(pHeader, NULL);

	//TO("psparser -3: cam=%d, size=%d\n", pHeader->source, pHeader->size);

	return TRUE;
}

void DECHMP4::PackNewHeader(ADV_HEADER *pHeader, int *pSize)
{
	int i, extra_size, original_size;
	BYTE *p = ((BYTE *)pHeader) + sizeof(ADV_HEADER);

	original_size = pHeader->size;
	extra_size = 0;

	OLD_HEADER_1 hdr;
	hdr.sync1 = 0xF6;  hdr.sync2 = 0xFF;
	hdr.sync3 = 0xF9;  hdr.sync4 = 0xDD;
	hdr.sync5 = 0xC5;

    hdr.size_hh = (BYTE)(pHeader->size>>24)&0xFF;
    hdr.size_hl = (BYTE)(pHeader->size>>16)&0xFF;
    hdr.time_hh = (BYTE)(pHeader->time>>24)&0xFF;
    hdr.time_hl = (BYTE)(pHeader->time>>16)&0xFF;
    hdr.time_lh = (BYTE)(pHeader->time>>8) &0xFF;
    hdr.time_ll = (BYTE)(pHeader->time)    &0xFF;

    hdr.flag  = 0x80|((OLD_HEADER_1_VERSION<<4)&0x70);
    hdr.res1  = 0x80;
    hdr.res2  = 0x80;

    i = 1;	//enable archive
    hdr.flag  = (i&1)<<3;

	//increase size.
	pHeader->size += sizeof(OLD_HEADER_1) + extra_size;

	for (i=pHeader->size-1; i >= 0; i--)
	{
		p[i+sizeof(OLD_HEADER_1)+extra_size] = p[i];
	}
	memcpy(p, &hdr, sizeof(OLD_HEADER_1));
	//*((DWORD*)(p+sizeof(OLD_HEADER_1))) = original_size;
}
//=============== DECSMP4 ======================================================
DECSMP4::DECSMP4()
{
	m_pDec = NULL;
}
DECSMP4::~DECSMP4()
{
}
void DECSMP4::Init ( HWND hWnd )
{
	if (m_pDec) return;

	decsk4_initialize();
	m_pDec = decsk4_new ();

	if (!m_pDec) return;
	
    if (!decsk4_draw_init(m_pDec, hWnd))
	{
		decsk4_free(m_pDec);
		m_pDec = NULL;
		decsk4_show(m_pDec, FALSE);
		return;
	}
	decsk4_flush(m_pDec);
	decsk4_show(m_pDec, TRUE);
}
void DECSMP4::Exit ( void )
{
    if (m_pDec)
	{  
        decsk4_draw_exit(m_pDec);
        decsk4_free(m_pDec);
		m_pDec = NULL;
		decsk4_terminate ();
	}
}
void DECSMP4::ShowVideo ( int ShowVideo )
{
	if (m_pDec) decsk4_show(m_pDec, ShowVideo);
}

BOOL DECSMP4::Decompress(char *frame, int frame_size, LPADV_HEADER pHeader)
{  	
	if (decsk4_receive_data(m_pDec, frame_size, frame, 1) > 0)
		return TRUE;
	return FALSE;
}
BOOL DECSMP4::GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						LPBITMAPINFOHEADER pBMPInfo)
{
	DWORD width, height;
	GetFrameSize(&width, &height);

    if (!decsk4_get_decompressed_bitmap_ex2(m_pDec, pBMPBuf, dwBMPBufSize))
		return FALSE;

	//count actual data.
	DWORD actual_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
	if (width == 640 && height == 240)
	{	//expand video
		DWORD newsize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER) + 640 * 480 * 3;
		ExpandBMP(pBMPBuf);
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), newsize);
	}
	else
	{//copy info header & pixal data
		memmove( pBMPInfo, pBMPBuf+sizeof( BITMAPFILEHEADER ), dwBMPBufSize - sizeof( BITMAPFILEHEADER ));
	}

	return TRUE;
}
void DECSMP4::GetFrameSize(DWORD *width, DWORD *height)
{
	*width = 320;
	*height = 240;
	decsk4_get_size(m_pDec, width, height);
}
decoder *DECSMP4::CreateDecoder(void)
{
    DECSMP4 *pp = new DECSMP4;
    return pp;
}