#include "stdafx.h"
#include "resource.h"
#include "Idecoder.h"
#include "nw3.h"

#define H263_NEW_HEADER_SIZE   14	// new frame header
#define H263_HEADER_SIZE		5	// old frame header

Idecoder *CVT263::CreateDecoder(void)
{
    CVT263 *pp = new CVT263;
    return pp;
}

CVT263::CVT263()
{
}

CVT263::~CVT263()
{
}

void CVT263::Init ( LPCTSTR src_filename, HWND hWnd)
{
	CString s;

    m_SrcFilename  = src_filename;

	m_iBufCount    = 0;
	m_iHeadPos     = 0;
	m_iIsCodecOk   = 0;
	m_BitRate      = 30;

	m_hFile = CreateFile(m_SrcFilename, GENERIC_READ, 0, NULL, 
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		s=src_filename;
		s+=" !";
		AfxMessageBox(s);
		return;
	}

	dec263_initialize();
	m_pDec = NULL;
	m_pDec = dec263_new();

	if (!m_pDec)
	{
		CloseHandle(m_hFile);
		m_hFile = NULL;
		return;
	}
	
	dec263_draw_init(m_pDec, hWnd);
	dec263_show(m_pDec, TRUE);

}

void CVT263::Exit ( void )
{
	if (!m_pDec) return;

	if (m_hFile!=NULL) CloseHandle(m_hFile);
	m_hFile = NULL;

	if (m_pDec) dec263_draw_exit (m_pDec);
	if (m_pDec) dec263_free (m_pDec);
	m_pDec = NULL;
	dec263_terminate();
}

BOOL CVT263::Convert (void)
{
	CString  s;
	char     *from, *frame;
	int      count, i;
	BOOL     bNewFrame, doit=FALSE;
	DWORD    dwTimeStamp, remain=0;
	DWORD    readcount=0, frame_size;
	DWORD    bmp_size, width, height;
	BYTE     *pbmp=NULL;    

    m_iIsCodecOk = 1;

    if (ReadFile(m_hFile, &readbuf, 102400, &readcount, NULL) && (readcount != 0))
	{
		memcpy(decbuf+m_iBufCount, readbuf, readcount);
		m_iBufCount+=readcount;
		while (FrameAvail(decbuf, &frame, &frame_size, &bNewFrame, &dwTimeStamp))
		{
			i = dec263_receive_data(m_pDec, frame_size, frame, 1);
			
			if (i == 0)
				AfxMessageBox("Get data error!");
			else
			{
				int mem_size;

				dec263_get_size(m_pDec, &width, &height);
				bmp_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
				mem_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  1024 * 768 * 3;

				if (!pbmp) pbmp = new unsigned char[mem_size];

				// Get BMP !
				if (!dec263_get_decompressed_bitmap_ex2(m_pDec, pbmp, bmp_size))
					AfxMessageBox("Get BMP error");
			}

			from = decbuf + frame_size;
			count = m_iBufCount - frame_size;
			if (count > 0)
				memcpy(decbuf, from, count);
			m_iBufCount = count;
		} // while (FrameAvail()
		doit=TRUE;
	} // ReadFile

	if (doit==FALSE) m_iIsCodecOk=0;

	if (pbmp)
		delete pbmp;

	return m_iIsCodecOk;
}

BOOL CVT263::FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                 BOOL *pNew, DWORD *dwTimeStamp)
{
	if (m_iBufCount - m_iHeadPos < (H263_NEW_HEADER_SIZE+H263_HEADER_SIZE))
		return FALSE;

	BOOL new_header;
	long offset;
	BYTE frame_size[4];
	BYTE time_stamp[4];
	int nFrameSize;

    offset = match_h263_header_pattern((BYTE*)(pBuf+m_iHeadPos), m_iBufCount, &new_header );
	
    if ( offset < 0 )
    {
		return FALSE;
    }
	else if (offset > 0)
	{
	    m_iBufCount -= offset;
		memcpy(pBuf, pBuf+m_iHeadPos+offset, m_iBufCount);
		m_iHeadPos = 0;
	}

	*dwTimeStamp = 0;

	if (new_header)
	{
		frame_size[0] = pBuf[14];
		frame_size[1] = pBuf[15];
		frame_size[2] = pBuf[3];
		frame_size[3] = pBuf[1];				
		nFrameSize = (int)(*(DWORD*)frame_size);
		nFrameSize += H263_NEW_HEADER_SIZE;

		time_stamp[0] = pBuf[11];
		time_stamp[1] = pBuf[9];
		time_stamp[2] = pBuf[7];
		time_stamp[3] = pBuf[5];
		*dwTimeStamp = (DWORD)(*(DWORD*)time_stamp);
	}
	else
		nFrameSize = (int)(*(WORD*)pBuf);

	if ( nFrameSize <= 0 )		// to avoid getting the wrong header
	{
		m_iBufCount = 0;
		m_iHeadPos = 0;
		return FALSE;
	}
	if (m_iBufCount >= (int)nFrameSize)
	{
		*frm = pBuf + m_iHeadPos;
		*size = nFrameSize;
		
		*pNew = new_header ? TRUE : FALSE;

		return TRUE;
	}
	else
		return FALSE;
}

long CVT263::match_h263_header_pattern (const BYTE * data, long len, BOOL * new_header )
{
    long    i;

    for ( i = 0; i <= len - H263_HEADER_SIZE; i ++ )
    {
        if ( data [ i + 2 ] != 0x00 ) continue;
        if ( data [ i + 3 ] != 0x00 ) continue;		
        if ( (data [ i + 4 ] & 0x80) != 0x80 ) continue;

		if ( i < H263_NEW_HEADER_SIZE )
		{
			*new_header = FALSE;
		}
		else
		{
			if ( (data [ i - 14 ] == 0xF6) && (data [ i - 12 ] == 0xFF) &&
				 (data [ i - 10 ] == 0xF9) && (data [ i - 8 ] == 0xDD) &&
				 (data [ i - 2 ] == 0xC5) )
			{
				*new_header = TRUE;
				i -= 14;
			}
			else
				*new_header = FALSE;
		}
        return ( i );
    }

    return ( -1 );
}