#include "stdafx.h"
#include "DEC263.h"
#include "resource.h"
#include "Idecoder.h"
#include "nw4.h"
#include "nwv.h"

#define H263_NEW_HEADER_SIZE   14	// new frame header
#define H263_HEADER_SIZE		5	// old frame header
#define VWEB_NEW_HEADER_SIZE   18

Idecoder *CVTHMP4::CreateDecoder(void)
{
    CVTHMP4 *pp = new CVTHMP4;
    return pp;
}


//===========================================================
// Public member
CVTHMP4::CVTHMP4()
{
}

CVTHMP4::~CVTHMP4()
{
}

void CVTHMP4::Init ( LPCTSTR src_filename, HWND hWnd )
{
	CString s;

    m_SrcFilename  = src_filename;
   
	m_iBufCount    = 0;
	m_iHeadPos     = 0;
	m_iIsCodecOk   = 0;
	m_BitRate      = 30;
	m_bFirst       = TRUE;

	m_hFile = CreateFile(m_SrcFilename, GENERIC_READ, 0, NULL, 
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		s=src_filename;
		s+=" !";
		AfxMessageBox(s);
		return;
	}

	decvweb_initialize();
	m_pDec = NULL;
	m_pDec = decvweb_new(FALSE);

	if (!m_pDec)
	{
		CloseHandle(m_hFile);
		return;
	}
	decvweb_draw_init(m_pDec, hWnd);
}

void CVTHMP4::Exit ( void )
{
	if (!m_pDec) return;

	CloseHandle(m_hFile);

	decvweb_draw_exit (m_pDec);
	decvweb_free(m_pDec);
	decvweb_terminate ();
}

void CVTHMP4::ScaleBMP(BYTE *pBMPBuf)
{
	BITMAPFILEHEADER *pFile = (BITMAPFILEHEADER*)pBMPBuf;
	BITMAPINFOHEADER *pInfo = (BITMAPINFOHEADER*)(pBMPBuf+sizeof(BITMAPFILEHEADER));
	BYTE *data = pBMPBuf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	int i, line_width, new_width, dst;

	if (pInfo->biBitCount == 16)
	{
		line_width = pInfo->biWidth * 2;
		new_width = 640 * 2;
		dst = 40 * 2;
	}
	else if (pInfo->biBitCount == 24)
	{	
		line_width = pInfo->biWidth * 3;
		new_width = 640 * 3;
		dst = 40 * 3;
	}
	else
		return;

	// 720X480 -> 640X480
	for (i=0; i<pInfo->biHeight; i++)
	{
		BYTE *src, *target;
		src = data + i*line_width;
		target = data + i*new_width;
		memcpy(target, src+dst, new_width);
	}

	pInfo->biWidth = 640;
	pInfo->biSizeImage *= 8/9;
}

BOOL CVTHMP4::Convert (void)
{
	DWORD readcount=0, dwTimeStamp, odwTimeStamp = 0, remain = 0;
	DWORD bmp_size, width, height;
	unsigned char *pbmp=NULL;
	CString s;
	BOOL doit=FALSE;
	
	pbmp = NULL;
	dwTimeStamp = 0;

	m_iIsCodecOk = 1;

	if( ReadFile(m_hFile, readbuf, sizeof(readbuf), &readcount, NULL) && (readcount != 0))
	{
		char *frame;
		DWORD frame_size;
		BOOL  new_frame;

		memcpy(decbuf+m_iBufCount, readbuf, readcount);
		m_iBufCount+=readcount;
		while (FrameAvail(decbuf, &frame, &frame_size, &new_frame, &dwTimeStamp))
		{
			if (decvweb_receive_data(m_pDec, frame_size, frame, 1) > 0)
			{
				decvweb_get_size(m_pDec, &width, &height);

				if (!pbmp)
				{
					int mem_size;

					bmp_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
					mem_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  1024 * 768 * 3;

					pbmp = new unsigned char[mem_size];
					if (!pbmp)
					{
						m_iIsCodecOk = 0;
						break;
					}
				}

				// Get BMP !
				if (!decvweb_get_decompressed_bitmap_ex2(m_pDec, pbmp, bmp_size))
					AfxMessageBox("Get BMP error!");
				

			}//if (decmp4_receive_data
			int left = m_iBufCount - frame_size;
			if (left > 0)
			{
				memcpy(decbuf, frame+frame_size, left);
				m_iBufCount = left;
			}
			else
				m_iBufCount = 0;
		}//while (FrameAvailMPEG4
		doit=TRUE;
	}// ReadFile(

	if (doit==FALSE) 
	{
		m_iIsCodecOk=0;
	}

	if (pbmp)
		delete pbmp;
	
	return m_iIsCodecOk;
}

BOOL CVTHMP4::FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                 BOOL *pNew, DWORD *dwTimeStamp)
{
	if (m_iBufCount - m_iHeadPos < (H263_NEW_HEADER_SIZE+H263_HEADER_SIZE))
		return FALSE;

	BOOL new_header;
	long offset;
	BYTE frame_size[4];
	int nFrameSize, nExtendInfoSize;

	nExtendInfoSize = 0;

	offset = match_vweb_header_pattern((BYTE*)(pBuf+m_iHeadPos), m_iBufCount, &new_header );
	
    if ( offset < 0 )
    {
		//offset < 0 because not enough data in the buffer. receive more and check again.
		//m_iHeadPos = 0;
		//m_iBufCount = 0;
		return FALSE;
    }
	else if (offset >= 0)
	{
		BYTE *pb;
        if (new_header)
        {
            pb = (BYTE*) pBuf+m_iHeadPos+offset; //-18;
            frame_size[0] = pb[14];
            frame_size[1] = pb[15];
            frame_size[2] = pb[3];
            frame_size[3] = pb[1];
            nFrameSize = (int)(*(DWORD*)frame_size);
            nFrameSize += VWEB_NEW_HEADER_SIZE;

			LPOLD_HEADER_1 pHdr = (LPOLD_HEADER_1)pb;
			int version;
			version = (pHdr->flag & 0x70) >>4;
			if (version == 2)
				nExtendInfoSize = sizeof(WEBVDO_EXTENDINFO);
        }
        else
        {
            pb = (BYTE*) pBuf+m_iHeadPos+offset;
            nFrameSize = (int)(*(WORD*)pb);
        }

		if (offset > 0)
		{
			m_iBufCount -= offset;
			memcpy(pBuf, pBuf+m_iHeadPos+offset, m_iBufCount);
			m_iHeadPos = 0;
		}
	}

	*dwTimeStamp = 0;


	if ( nFrameSize <= 0 )		// to avoid getting the wrong header
	{
		m_iBufCount = 0;
		m_iHeadPos = 0;
		return FALSE;
	}

	if (m_iBufCount >= (int)nFrameSize+nExtendInfoSize)
	{
		*frm = pBuf + m_iHeadPos;
		*size = nFrameSize;
		
		*pNew = new_header ? TRUE : FALSE;

		return TRUE;
	}
	else
		return FALSE;
}

long CVTHMP4::match_vweb_header_pattern ( BYTE * data, long len, BOOL * new_header )
{

    long    i;

    for ( i = 0; i <= len - H263_HEADER_SIZE; i ++ )
    {
        // match ss ss PSC ==> ss ss 00 00 ( 1xxx xxxx )
        if ( data [ i + 0 ] != 0x00 ) continue;
        if ( data [ i + 1 ] != 0x00 ) continue;
        if ( data [ i + 2 ] != 0x01 ) continue;
//        if ( (data [ i + 5 ] & 0xF0) != 0xB0 ) continue;

        // match !
                // check if having new header
                if ( i < VWEB_NEW_HEADER_SIZE )
                {
                        *new_header = FALSE;
                }
                else
                {
                        if ( (data [ i - 18 ] == 0xF6) && (data [ i - 16 ] == 0xFF) &&
                             (data [ i - 14 ] == 0xF9) && (data [ i - 12 ] == 0xDD) &&
                             (data [ i - 6 ] == 0xC5) )
                        {
                                *new_header = TRUE;
                                i -= 18;
                        }
                        else
                                *new_header = FALSE;
                }
        return ( i );
    }

    // no match
    return ( -1 );
}